/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vm;

import com.vmware.common.annotations.Action;
import com.vmware.common.annotations.Option;
import com.vmware.common.annotations.Sample;
import com.vmware.connection.ConnectedVimServiceBase;
import com.vmware.vim25.ArrayOfManagedObjectReference;
import com.vmware.vim25.ArrayOfVirtualDevice;
import com.vmware.vim25.ConcurrentAccessFaultMsg;
import com.vmware.vim25.DatastoreSummary;
import com.vmware.vim25.DuplicateNameFaultMsg;
import com.vmware.vim25.FileFaultFaultMsg;
import com.vmware.vim25.InsufficientResourcesFaultFaultMsg;
import com.vmware.vim25.InvalidCollectorVersionFaultMsg;
import com.vmware.vim25.InvalidDatastoreFaultMsg;
import com.vmware.vim25.InvalidNameFaultMsg;
import com.vmware.vim25.InvalidPropertyFaultMsg;
import com.vmware.vim25.InvalidStateFaultMsg;
import com.vmware.vim25.LocalizedMethodFault;
import com.vmware.vim25.ManagedObjectReference;
import com.vmware.vim25.ResourceAllocationInfo;
import com.vmware.vim25.RuntimeFaultFaultMsg;
import com.vmware.vim25.SharesInfo;
import com.vmware.vim25.SharesLevel;
import com.vmware.vim25.TaskInProgressFaultMsg;
import com.vmware.vim25.TaskInfoState;
import com.vmware.vim25.VirtualCdrom;
import com.vmware.vim25.VirtualCdromRemoteAtapiBackingInfo;
import com.vmware.vim25.VirtualDevice;
import com.vmware.vim25.VirtualDeviceBackingInfo;
import com.vmware.vim25.VirtualDeviceConfigSpec;
import com.vmware.vim25.VirtualDeviceConfigSpecFileOperation;
import com.vmware.vim25.VirtualDeviceConfigSpecOperation;
import com.vmware.vim25.VirtualDisk;
import com.vmware.vim25.VirtualDiskFlatVer2BackingInfo;
import com.vmware.vim25.VirtualEthernetCard;
import com.vmware.vim25.VirtualEthernetCardNetworkBackingInfo;
import com.vmware.vim25.VirtualIDEController;
import com.vmware.vim25.VirtualMachineConfigSpec;
import com.vmware.vim25.VirtualPCNet32;
import com.vmware.vim25.VirtualSCSIController;
import com.vmware.vim25.VmConfigFaultFaultMsg;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

@Sample(name="vm-reconfig", description="Reconfigures a virtual machine, which include reconfiguring the disk size, disk mode, etc.")
public class VMReconfig
extends ConnectedVimServiceBase {
    ManagedObjectReference virtualMachine = null;
    String vmName = null;
    String operation = null;
    String device = null;
    String value = null;
    String disksize = null;
    String diskmode = null;

    @Option(name="vmname", required=true, description="name of the virtual machine")
    public void setVmName(String string) {
        this.vmName = string;
    }

    @Option(name="device", description="[cpu|memory|disk|cd|nic]")
    public void setDevice(String string) {
        this.device = string;
    }

    @Option(name="operation", required=true, description="[add|remove|update]update operation is only possible for cpu and memory, add|remove are not allowed for cpu and memory")
    public void setOperation(String string) {
        this.operation = string;
    }

    @Option(name="value", description="high|low|normal|numeric value, label of device when removing")
    public void setValue(String string) {
        this.value = string;
    }

    @Option(name="disksize", required=false, description="Size of virtual disk")
    public void setDisksize(String string) {
        this.disksize = string;
    }

    @Option(name="diskmode", required=false, description="persistent|independent_persistent,independent_nonpersistent")
    public void setDiskmode(String string) {
        this.diskmode = string;
    }

    boolean getTaskResultAfterDone(ManagedObjectReference managedObjectReference) throws InvalidPropertyFaultMsg, RuntimeFaultFaultMsg, InvalidCollectorVersionFaultMsg {
        boolean bl = false;
        Object[] objectArray = this.waitForValues.wait(managedObjectReference, new String[]{"info.state", "info.error"}, new String[]{"state"}, new Object[][]{{TaskInfoState.SUCCESS, TaskInfoState.ERROR}});
        if (objectArray[0].equals(TaskInfoState.SUCCESS)) {
            bl = true;
        }
        if (objectArray[1] instanceof LocalizedMethodFault) {
            throw new RuntimeException(((LocalizedMethodFault)objectArray[1]).getLocalizedMessage());
        }
        return bl;
    }

    List<Integer> getControllerKey(ManagedObjectReference managedObjectReference) throws InvalidPropertyFaultMsg, RuntimeFaultFaultMsg {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        List list = ((ArrayOfVirtualDevice)this.getMOREFs.entityProps(managedObjectReference, new String[]{"config.hardware.device"}).get("config.hardware.device")).getVirtualDevice();
        HashMap<Integer, Object> hashMap = new HashMap<Integer, Object>();
        for (Object object : list) {
            hashMap.put(object.getKey(), object);
        }
        boolean bl = false;
        for (VirtualDevice virtualDevice : list) {
            if (!(virtualDevice instanceof VirtualSCSIController)) continue;
            VirtualSCSIController virtualSCSIController = (VirtualSCSIController)virtualDevice;
            int[] nArray = new int[16];
            nArray[7] = 1;
            List list2 = virtualSCSIController.getDevice();
            for (Integer n : list2) {
                if (((VirtualDevice)hashMap.get(n)).getUnitNumber() == null) continue;
                nArray[((VirtualDevice)hashMap.get((Object)n)).getUnitNumber().intValue()] = 1;
            }
            for (int i = 0; i < nArray.length; ++i) {
                if (nArray[i] == 1) continue;
                arrayList.add(virtualSCSIController.getKey());
                arrayList.add(i);
                bl = true;
                break;
            }
            if (!bl) continue;
            break;
        }
        if (!bl) {
            throw new RuntimeException("The SCSI controller on the vm has maxed out its capacity. Please add an additional SCSI controller");
        }
        return arrayList;
    }

    boolean customValidation() {
        boolean bl = true;
        if (this.device.equalsIgnoreCase("disk")) {
            if (this.operation.equalsIgnoreCase("add")) {
                if (this.disksize == null || this.diskmode == null) {
                    System.out.println("For add disk operation, disksize and diskmode are the Mandatory options");
                    bl = false;
                }
                if (this.disksize != null && Integer.parseInt(this.disksize) <= 0) {
                    System.out.println("Disksize must be a greater than zero");
                    bl = false;
                }
            }
            if (this.operation.equalsIgnoreCase("remove") && this.value == null) {
                System.out.println("Please specify a label in value field to remove the disk");
            }
        }
        if (this.device.equalsIgnoreCase("nic") && this.operation == null) {
            System.out.println("For add nic operation is the Mandatory option");
            bl = false;
        }
        if (this.device.equalsIgnoreCase("cd") && this.operation == null) {
            System.out.println("For add cd operation is the Mandatory options");
            bl = false;
        }
        if (this.operation != null) {
            if (this.operation.equalsIgnoreCase("add") || this.operation.equalsIgnoreCase("remove") || this.operation.equalsIgnoreCase("update")) {
                if (!(!this.device.equals("cpu") && !this.device.equals("memory") || this.operation != null && this.operation.equals("update"))) {
                    System.out.println("Invalid operation specified for device cpu or memory");
                    bl = false;
                }
            } else {
                System.out.println("Operation must be either add, remove or update");
                bl = false;
            }
        }
        return bl;
    }

    ResourceAllocationInfo getShares() {
        ResourceAllocationInfo resourceAllocationInfo = new ResourceAllocationInfo();
        SharesInfo sharesInfo = new SharesInfo();
        if (this.value.equalsIgnoreCase(SharesLevel.HIGH.toString())) {
            sharesInfo.setLevel(SharesLevel.HIGH);
        } else if (this.value.equalsIgnoreCase(SharesLevel.NORMAL.toString())) {
            sharesInfo.setLevel(SharesLevel.NORMAL);
        } else if (this.value.equalsIgnoreCase(SharesLevel.LOW.toString())) {
            sharesInfo.setLevel(SharesLevel.LOW);
        } else {
            sharesInfo.setLevel(SharesLevel.CUSTOM);
            sharesInfo.setShares(Integer.parseInt(this.value));
        }
        resourceAllocationInfo.setShares(sharesInfo);
        return resourceAllocationInfo;
    }

    String getDatastoreNameWithFreeSpace(int n) throws InvalidPropertyFaultMsg, RuntimeFaultFaultMsg {
        String string = null;
        List list = ((ArrayOfManagedObjectReference)this.getMOREFs.entityProps(this.virtualMachine, new String[]{"datastore"}).get("datastore")).getManagedObjectReference();
        for (ManagedObjectReference managedObjectReference : list) {
            DatastoreSummary datastoreSummary = (DatastoreSummary)this.getMOREFs.entityProps(managedObjectReference, new String[]{"summary"}).get("summary");
            if (datastoreSummary.getFreeSpace() <= (long)n) continue;
            string = datastoreSummary.getName();
            break;
        }
        return string;
    }

    VirtualDeviceConfigSpec getDiskDeviceConfigSpec() throws RuntimeFaultFaultMsg, InvalidPropertyFaultMsg {
        String string = this.operation;
        VirtualDeviceConfigSpec virtualDeviceConfigSpec = new VirtualDeviceConfigSpec();
        if (string.equalsIgnoreCase("Add")) {
            VirtualDisk virtualDisk = new VirtualDisk();
            VirtualDiskFlatVer2BackingInfo virtualDiskFlatVer2BackingInfo = new VirtualDiskFlatVer2BackingInfo();
            String string2 = this.getDatastoreNameWithFreeSpace(Integer.parseInt(this.disksize));
            int n = 0;
            int n2 = 0;
            List<Integer> list = this.getControllerKey(this.virtualMachine);
            if (!list.isEmpty()) {
                n = list.get(0);
                n2 = list.get(1);
            }
            String string3 = "[" + string2 + "] " + this.vmName + "/" + this.value + ".vmdk";
            virtualDiskFlatVer2BackingInfo.setFileName(string3);
            virtualDiskFlatVer2BackingInfo.setDiskMode(this.diskmode);
            virtualDisk.setControllerKey(Integer.valueOf(n));
            virtualDisk.setUnitNumber(Integer.valueOf(n2));
            virtualDisk.setBacking((VirtualDeviceBackingInfo)virtualDiskFlatVer2BackingInfo);
            int n3 = 1024 * Integer.parseInt(this.disksize);
            virtualDisk.setCapacityInKB((long)n3);
            virtualDisk.setKey(-1);
            virtualDeviceConfigSpec.setOperation(VirtualDeviceConfigSpecOperation.ADD);
            virtualDeviceConfigSpec.setFileOperation(VirtualDeviceConfigSpecFileOperation.CREATE);
            virtualDeviceConfigSpec.setDevice((VirtualDevice)virtualDisk);
        } else if (string.equalsIgnoreCase("Remove")) {
            VirtualDisk virtualDisk = null;
            List list = ((ArrayOfVirtualDevice)this.getMOREFs.entityProps(this.virtualMachine, new String[]{"config.hardware.device"}).get("config.hardware.device")).getVirtualDevice();
            for (VirtualDevice virtualDevice : list) {
                if (!(virtualDevice instanceof VirtualDisk) || !this.value.equalsIgnoreCase(virtualDevice.getDeviceInfo().getLabel())) continue;
                virtualDisk = (VirtualDisk)virtualDevice;
                break;
            }
            if (virtualDisk != null) {
                virtualDeviceConfigSpec.setOperation(VirtualDeviceConfigSpecOperation.REMOVE);
                virtualDeviceConfigSpec.setFileOperation(VirtualDeviceConfigSpecFileOperation.DESTROY);
                virtualDeviceConfigSpec.setDevice(virtualDisk);
            } else {
                System.out.println("No device found " + this.value);
                return null;
            }
        }
        return virtualDeviceConfigSpec;
    }

    VirtualDeviceConfigSpec getCDDeviceConfigSpec() throws RuntimeFaultFaultMsg, InvalidPropertyFaultMsg {
        String string = this.operation;
        VirtualDeviceConfigSpec virtualDeviceConfigSpec = new VirtualDeviceConfigSpec();
        List list = ((ArrayOfVirtualDevice)this.getMOREFs.entityProps(this.virtualMachine, new String[]{"config.hardware.device"}).get("config.hardware.device")).getVirtualDevice();
        if (string.equalsIgnoreCase("Add")) {
            virtualDeviceConfigSpec.setOperation(VirtualDeviceConfigSpecOperation.ADD);
            VirtualCdrom virtualCdrom = new VirtualCdrom();
            VirtualCdromRemoteAtapiBackingInfo virtualCdromRemoteAtapiBackingInfo = new VirtualCdromRemoteAtapiBackingInfo();
            virtualCdromRemoteAtapiBackingInfo.setDeviceName("");
            virtualCdromRemoteAtapiBackingInfo.setUseAutoDetect(Boolean.valueOf(true));
            HashMap<Integer, VirtualDevice> hashMap = new HashMap<Integer, VirtualDevice>();
            for (VirtualDevice virtualDevice : list) {
                hashMap.put(virtualDevice.getKey(), virtualDevice);
            }
            int n = 0;
            int n2 = 0;
            boolean bl = false;
            for (VirtualDevice virtualDevice : list) {
                if (!(virtualDevice instanceof VirtualIDEController)) continue;
                VirtualIDEController virtualIDEController = (VirtualIDEController)virtualDevice;
                int[] nArray = new int[2];
                List list2 = virtualIDEController.getDevice();
                for (Integer n3 : list2) {
                    if (((VirtualDevice)hashMap.get(n3)).getUnitNumber() == null) continue;
                    nArray[((VirtualDevice)hashMap.get((Object)n3)).getUnitNumber().intValue()] = 1;
                }
                for (int i = 0; i < nArray.length; ++i) {
                    if (nArray[i] == 1) continue;
                    n = virtualIDEController.getKey();
                    n2 = i;
                    bl = true;
                    break;
                }
                if (!bl) continue;
                break;
            }
            if (!bl) {
                throw new RuntimeException("The IDE controller on the vm has maxed out its capacity. Please add an additional IDE controller");
            }
            virtualCdrom.setBacking((VirtualDeviceBackingInfo)virtualCdromRemoteAtapiBackingInfo);
            virtualCdrom.setControllerKey(Integer.valueOf(n));
            virtualCdrom.setUnitNumber(Integer.valueOf(n2));
            virtualCdrom.setKey(-1);
            virtualDeviceConfigSpec.setDevice((VirtualDevice)virtualCdrom);
            return virtualDeviceConfigSpec;
        }
        VirtualCdrom virtualCdrom = null;
        virtualDeviceConfigSpec.setOperation(VirtualDeviceConfigSpecOperation.REMOVE);
        for (VirtualDevice virtualDevice : list) {
            if (!(virtualDevice instanceof VirtualCdrom) || !this.value.equalsIgnoreCase(virtualDevice.getDeviceInfo().getLabel())) continue;
            virtualCdrom = (VirtualCdrom)virtualDevice;
            break;
        }
        if (virtualCdrom == null) {
            System.out.println("No device available " + this.value);
            return null;
        }
        virtualDeviceConfigSpec.setDevice(virtualCdrom);
        return virtualDeviceConfigSpec;
    }

    VirtualDeviceConfigSpec getNICDeviceConfigSpec() throws RuntimeFaultFaultMsg, InvalidPropertyFaultMsg {
        String string = this.operation;
        VirtualDeviceConfigSpec virtualDeviceConfigSpec = new VirtualDeviceConfigSpec();
        if (string.equalsIgnoreCase("Add")) {
            virtualDeviceConfigSpec.setOperation(VirtualDeviceConfigSpecOperation.ADD);
            VirtualPCNet32 virtualPCNet32 = new VirtualPCNet32();
            VirtualEthernetCardNetworkBackingInfo virtualEthernetCardNetworkBackingInfo = new VirtualEthernetCardNetworkBackingInfo();
            virtualEthernetCardNetworkBackingInfo.setDeviceName(this.value);
            virtualPCNet32.setAddressType("generated");
            virtualPCNet32.setBacking((VirtualDeviceBackingInfo)virtualEthernetCardNetworkBackingInfo);
            virtualPCNet32.setKey(-1);
            virtualDeviceConfigSpec.setDevice((VirtualDevice)virtualPCNet32);
        } else if (string.equalsIgnoreCase("Remove")) {
            VirtualEthernetCard virtualEthernetCard = null;
            virtualDeviceConfigSpec.setOperation(VirtualDeviceConfigSpecOperation.REMOVE);
            List list = ((ArrayOfVirtualDevice)this.getMOREFs.entityProps(this.virtualMachine, new String[]{"config.hardware.device"}).get("config.hardware.device")).getVirtualDevice();
            for (VirtualDevice virtualDevice : list) {
                if (!(virtualDevice instanceof VirtualEthernetCard) || !this.value.equalsIgnoreCase(virtualDevice.getDeviceInfo().getLabel())) continue;
                virtualEthernetCard = (VirtualEthernetCard)virtualDevice;
                break;
            }
            if (virtualEthernetCard != null) {
                virtualDeviceConfigSpec.setDevice(virtualEthernetCard);
            } else {
                System.out.println("No device available " + this.value);
                return null;
            }
        }
        return virtualDeviceConfigSpec;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void reConfig() throws InvalidPropertyFaultMsg, DuplicateNameFaultMsg, TaskInProgressFaultMsg, VmConfigFaultFaultMsg, InsufficientResourcesFaultFaultMsg, InvalidDatastoreFaultMsg, FileFaultFaultMsg, ConcurrentAccessFaultMsg, InvalidStateFaultMsg, InvalidNameFaultMsg, InvalidCollectorVersionFaultMsg, RuntimeFaultFaultMsg {
        VirtualDeviceConfigSpec virtualDeviceConfigSpec;
        String string = this.device;
        VirtualMachineConfigSpec virtualMachineConfigSpec = new VirtualMachineConfigSpec();
        if (string.equalsIgnoreCase("memory") && this.operation.equals("update")) {
            System.out.println("Reconfiguring The Virtual Machine For Memory Update " + this.vmName);
            try {
                virtualMachineConfigSpec.setMemoryAllocation(this.getShares());
            }
            catch (NumberFormatException numberFormatException) {
                System.out.println("Value of Memory update must be one of high|low|normal|[numeric value]");
                return;
            }
        } else if (string.equalsIgnoreCase("cpu") && this.operation.equals("update")) {
            System.out.println("Reconfiguring The Virtual Machine For CPU Update " + this.vmName);
            try {
                virtualMachineConfigSpec.setCpuAllocation(this.getShares());
            }
            catch (NumberFormatException numberFormatException) {
                System.out.println("Value of CPU update must be one of high|low|normal|[numeric value]");
                return;
            }
        } else if (string.equalsIgnoreCase("disk") && !this.operation.equals("update")) {
            System.out.println("Reconfiguring The Virtual Machine For Disk Update " + this.vmName);
            virtualDeviceConfigSpec = this.getDiskDeviceConfigSpec();
            if (virtualDeviceConfigSpec == null) return;
            ArrayList<VirtualDeviceConfigSpec> arrayList = new ArrayList<VirtualDeviceConfigSpec>();
            arrayList.add(virtualDeviceConfigSpec);
            virtualMachineConfigSpec.getDeviceChange().addAll(arrayList);
        } else if (string.equalsIgnoreCase("nic") && !this.operation.equals("update")) {
            System.out.println("Reconfiguring The Virtual Machine For NIC Update " + this.vmName);
            virtualDeviceConfigSpec = this.getNICDeviceConfigSpec();
            if (virtualDeviceConfigSpec == null) return;
            ArrayList<VirtualDeviceConfigSpec> arrayList = new ArrayList<VirtualDeviceConfigSpec>();
            arrayList.add(virtualDeviceConfigSpec);
            virtualMachineConfigSpec.getDeviceChange().addAll(arrayList);
        } else if (string.equalsIgnoreCase("cd") && !this.operation.equals("update")) {
            System.out.println("Reconfiguring The Virtual Machine For CD Update " + this.vmName);
            virtualDeviceConfigSpec = this.getCDDeviceConfigSpec();
            if (virtualDeviceConfigSpec == null) return;
            ArrayList<VirtualDeviceConfigSpec> arrayList = new ArrayList<VirtualDeviceConfigSpec>();
            arrayList.add(virtualDeviceConfigSpec);
            virtualMachineConfigSpec.getDeviceChange().addAll(arrayList);
        } else {
            System.out.println("Invalid device type [memory|cpu|disk|nic|cd]");
            return;
        }
        virtualDeviceConfigSpec = this.vimPort.reconfigVMTask(this.virtualMachine, virtualMachineConfigSpec);
        if (this.getTaskResultAfterDone((ManagedObjectReference)virtualDeviceConfigSpec)) {
            System.out.println("Virtual Machine reconfigured successfully");
            return;
        } else {
            System.out.println("Virtual Machine reconfigur failed");
        }
    }

    @Action
    public void run() throws InvalidPropertyFaultMsg, DuplicateNameFaultMsg, TaskInProgressFaultMsg, InsufficientResourcesFaultFaultMsg, VmConfigFaultFaultMsg, InvalidDatastoreFaultMsg, FileFaultFaultMsg, ConcurrentAccessFaultMsg, InvalidStateFaultMsg, InvalidCollectorVersionFaultMsg, InvalidNameFaultMsg, RuntimeFaultFaultMsg {
        ManagedObjectReference managedObjectReference = this.connection.getServiceContent().getPropertyCollector();
        if (this.customValidation()) {
            this.connect();
            this.virtualMachine = this.getMOREFs.vmByVMname(this.vmName, managedObjectReference);
            if (this.virtualMachine != null) {
                this.reConfig();
            } else {
                System.out.println("Virtual Machine " + this.vmName + " Not Found");
            }
        }
    }
}

