/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.common.samples;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class SystemParameters {
    final Map<String, String> parameters = new HashMap<String, String>();

    public SystemParameters() {
        Properties properties = System.getProperties();
        Enumeration<?> names = properties.propertyNames();
        while (names.hasMoreElements()) {
            Object name = names.nextElement();
            this.set(name, properties.get(name));
        }
    }

    private void set(Object key, Object value) {
        if (key != null) {
            this.set(key.toString(), value.toString());
        }
    }

    public boolean has(String name) {
        return this.parameters.containsKey(name);
    }

    public Set<String> parameterNames() {
        return this.parameters.keySet();
    }

    public String get(String name) {
        String value = null;
        if (name != null && !"".equals(name)) {
            value = this.parameters.get(name);
        }
        return value;
    }

    public SystemParameters set(String key, String value) {
        if (key != null && value != null) {
            this.parameters.put(key, value);
        }
        return this;
    }

    public static SystemParameters parse(File ... files) throws IOException {
        SystemParameters p = new SystemParameters();
        for (File file : files) {
            p.parse(file);
        }
        return p;
    }

    public SystemParameters parse(File file) throws IOException {
        FileInputStream inputStream = new FileInputStream(file);
        return this.parse(inputStream);
    }

    public SystemParameters parse(InputStream input) throws IOException {
        Properties properties = new Properties();
        properties.load(input);
        Set<String> keys = properties.stringPropertyNames();
        for (String key : keys) {
            String value = properties.getProperty(key);
            this.parameters.put(key, value);
        }
        return this;
    }
}

