/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.common.samples.registry;

import com.vmware.common.samples.SystemParameters;
import com.vmware.common.samples.parameters.OptionReference;
import com.vmware.common.samples.parameters.Options;
import com.vmware.common.samples.parameters.Parameters;
import com.vmware.common.samples.parameters.SampleParameters;
import com.vmware.common.samples.registry.ActionReference;
import com.vmware.common.samples.registry.SampleExecutionRecord;
import java.lang.reflect.InvocationTargetException;
import java.util.Set;

public class SampleReference
implements Comparable<SampleReference> {
    private final String name;
    private final String description;
    private final Class<?> sample;
    private final ActionReference action;
    private final Options options;
    private final SystemParameters systemParameters;

    public SampleReference(SystemParameters systemParameters, String name, String description, Class<?> sample, ActionReference action, Options options) {
        this.systemParameters = systemParameters;
        this.name = name;
        this.description = description;
        this.sample = sample;
        this.action = action;
        this.options = options;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getPackage() {
        return this.sample.getPackage().getName();
    }

    public Set<OptionReference> listOptions() {
        return this.options.list;
    }

    public SampleExecutionRecord run(String[] args) throws IllegalAccessException, InstantiationException, InvocationTargetException {
        SampleParameters parameters = this.parse(args, this.systemParameters);
        Object pojo = this.sample.newInstance();
        pojo = parameters.inject(pojo);
        return this.run(pojo);
    }

    public SampleExecutionRecord run(Object pojo) {
        return this.action.action(pojo);
    }

    private SampleParameters parse(String[] args, SystemParameters systemParameters) {
        return Parameters.build(this.sample, this.options, args, systemParameters);
    }

    @Override
    public int compareTo(SampleReference sampleReference) {
        return this.sample.getCanonicalName().compareTo(sampleReference.sample.getCanonicalName());
    }
}

