/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.sso.client.samples;

import com.rsa.names._2009._12.product.riat.wsdl.STSService;
import com.rsa.names._2009._12.product.riat.wsdl.STSServicePortType;
import com.vmware.sso.client.soaphandlers.HeaderHandlerResolver;
import com.vmware.sso.client.soaphandlers.SamlTokenExtractionHandler;
import com.vmware.sso.client.soaphandlers.TimeStampHandler;
import com.vmware.sso.client.soaphandlers.UserCredentialHandler;
import com.vmware.sso.client.utils.Utils;
import java.util.GregorianCalendar;
import java.util.Map;
import java.util.TimeZone;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSession;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.handler.HandlerResolver;
import org.oasis_open.docs.ws_sx.ws_trust._200512.LifetimeType;
import org.oasis_open.docs.ws_sx.ws_trust._200512.RenewingType;
import org.oasis_open.docs.ws_sx.ws_trust._200512.RequestSecurityTokenType;
import org.oasis_open.docs.wss._2004._01.oasis_200401_wss_wssecurity_utility_1_0.AttributedDateTime;
import org.w3c.dom.Element;

public class AcquireBearerTokenByUserCredentialSample {
    public static Element getToken(String[] stringArray) throws DatatypeConfigurationException {
        STSService sTSService = new STSService();
        HeaderHandlerResolver headerHandlerResolver = new HeaderHandlerResolver();
        headerHandlerResolver.addHandler(new TimeStampHandler());
        UserCredentialHandler userCredentialHandler = new UserCredentialHandler(stringArray[1], stringArray[2]);
        SamlTokenExtractionHandler samlTokenExtractionHandler = new SamlTokenExtractionHandler();
        headerHandlerResolver.addHandler(userCredentialHandler);
        headerHandlerResolver.addHandler(samlTokenExtractionHandler);
        sTSService.setHandlerResolver((HandlerResolver)headerHandlerResolver);
        STSServicePortType sTSServicePortType = sTSService.getSTSServicePort();
        RequestSecurityTokenType requestSecurityTokenType = new RequestSecurityTokenType();
        LifetimeType lifetimeType = new LifetimeType();
        DatatypeFactory datatypeFactory = DatatypeFactory.newInstance();
        GregorianCalendar gregorianCalendar = new GregorianCalendar(TimeZone.getTimeZone("GMT"));
        XMLGregorianCalendar xMLGregorianCalendar = datatypeFactory.newXMLGregorianCalendar(gregorianCalendar);
        AttributedDateTime attributedDateTime = new AttributedDateTime();
        attributedDateTime.setValue(xMLGregorianCalendar.toXMLFormat());
        AttributedDateTime attributedDateTime2 = new AttributedDateTime();
        xMLGregorianCalendar.add(datatypeFactory.newDuration(1800000L));
        attributedDateTime2.setValue(xMLGregorianCalendar.toXMLFormat());
        lifetimeType.setCreated(attributedDateTime);
        lifetimeType.setExpires(attributedDateTime2);
        requestSecurityTokenType.setTokenType("urn:oasis:names:tc:SAML:2.0:assertion");
        requestSecurityTokenType.setRequestType("http://docs.oasis-open.org/ws-sx/ws-trust/200512/Issue");
        requestSecurityTokenType.setLifetime(lifetimeType);
        requestSecurityTokenType.setKeyType("http://docs.oasis-open.org/ws-sx/ws-trust/200512/Bearer");
        requestSecurityTokenType.setSignatureAlgorithm("http://www.w3.org/2001/04/xmldsig-more#rsa-sha256");
        requestSecurityTokenType.setDelegatable(Boolean.valueOf(true));
        RenewingType renewingType = new RenewingType();
        renewingType.setAllow(Boolean.FALSE);
        renewingType.setOK(Boolean.FALSE);
        requestSecurityTokenType.setRenewing(renewingType);
        Map map = ((BindingProvider)sTSServicePortType).getRequestContext();
        map.put("javax.xml.ws.service.endpoint.address", stringArray[0]);
        sTSServicePortType.issue(requestSecurityTokenType);
        return samlTokenExtractionHandler.getToken();
    }

    private static void printUsage() {
        System.out.println("run.bat com.vmware.sso.client.samples.AcquireBearerTokenByUserCredentialSample [sso url] [username] [password]");
    }

    public static void main(String[] stringArray) throws DatatypeConfigurationException {
        if (stringArray.length < 3) {
            AcquireBearerTokenByUserCredentialSample.printUsage();
            return;
        }
        HostnameVerifier hostnameVerifier = new HostnameVerifier(){

            @Override
            public boolean verify(String string, SSLSession sSLSession) {
                return true;
            }
        };
        HttpsURLConnection.setDefaultHostnameVerifier(hostnameVerifier);
        Utils.trustAllHttpsCertificates();
        System.out.println("Aquiring a bearer token by using user credentials");
        Utils.printToken(AcquireBearerTokenByUserCredentialSample.getToken(stringArray));
    }
}

