/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.sso.client.soaphandlers;

import com.vmware.sso.client.soaphandlers.SSOHeaderHandler;
import com.vmware.sso.client.utils.Utils;
import com.vmware.sso.client.wssecurity.WsSecuritySignatureAssertion;
import java.security.PrivateKey;
import java.security.SignatureException;
import java.security.cert.X509Certificate;
import javax.xml.soap.SOAPException;
import javax.xml.ws.handler.soap.SOAPMessageContext;

public class WsSecuritySignatureAssertionHandler
extends SSOHeaderHandler {
    private final String _assertionId;
    private final PrivateKey _privateKey;
    private final X509Certificate _userCert;

    public WsSecuritySignatureAssertionHandler(PrivateKey privateKey, X509Certificate x509Certificate, String string) {
        this._privateKey = privateKey;
        this._userCert = x509Certificate;
        this._assertionId = string;
    }

    public boolean handleMessage(SOAPMessageContext sOAPMessageContext) {
        if (Utils.isOutgoingMessage(sOAPMessageContext)) {
            WsSecuritySignatureAssertion wsSecuritySignatureAssertion = new WsSecuritySignatureAssertion(this._privateKey, this._userCert, this._assertionId);
            try {
                wsSecuritySignatureAssertion.sign(sOAPMessageContext.getMessage());
            }
            catch (SignatureException signatureException) {
                System.out.println("Could not sign the SOAPMessage - SignatureException");
                signatureException.printStackTrace();
                throw new RuntimeException(signatureException);
            }
            catch (SOAPException sOAPException) {
                System.out.println("Could not sign the SOAPMessage - SOAPException");
                sOAPException.printStackTrace();
                throw new RuntimeException(sOAPException);
            }
        }
        return true;
    }
}

