/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.spbm.samples;

import com.vmware.common.annotations.Action;
import com.vmware.common.annotations.Option;
import com.vmware.common.annotations.Sample;
import com.vmware.pbm.InvalidArgumentFaultMsg;
import com.vmware.pbm.PbmCapabilityConstraintInstance;
import com.vmware.pbm.PbmCapabilityConstraints;
import com.vmware.pbm.PbmCapabilityInstance;
import com.vmware.pbm.PbmCapabilityMetadata;
import com.vmware.pbm.PbmCapabilityMetadataPerCategory;
import com.vmware.pbm.PbmCapabilityProfileCreateSpec;
import com.vmware.pbm.PbmCapabilityPropertyInstance;
import com.vmware.pbm.PbmCapabilitySubProfile;
import com.vmware.pbm.PbmCapabilitySubProfileConstraints;
import com.vmware.pbm.PbmCapabilityVendorNamespaceInfo;
import com.vmware.pbm.PbmDuplicateNameFaultMsg;
import com.vmware.pbm.PbmFaultProfileStorageFaultFaultMsg;
import com.vmware.pbm.PbmProfileId;
import com.vmware.pbm.PbmServiceInstanceContent;
import com.vmware.spbm.connection.ConnectedServiceBase;
import com.vmware.spbm.connection.helpers.PbmUtil;
import com.vmware.vim25.ManagedObjectReference;
import com.vmware.vim25.RuntimeFaultFaultMsg;
import java.util.ArrayList;
import java.util.List;

@Sample(name="createprofile", description="Creates a new storage profile with one rule-set based on vSAN capabilities.")
public class CreateVSANProfile
extends ConnectedServiceBase {
    private PbmServiceInstanceContent spbmsc;
    private Integer stripeWidth;
    private String profileName;
    private Boolean forceProvision = false;

    PbmCapabilityInstance buildCapability(String string, Object object, List<PbmCapabilityMetadataPerCategory> list) throws InvalidArgumentFaultMsg {
        PbmCapabilityMetadata pbmCapabilityMetadata = PbmUtil.getCapabilityMeta(string, list);
        if (pbmCapabilityMetadata == null) {
            throw new InvalidArgumentFaultMsg("Specified Capability does not exist", null);
        }
        PbmCapabilityPropertyInstance pbmCapabilityPropertyInstance = new PbmCapabilityPropertyInstance();
        pbmCapabilityPropertyInstance.setId(string);
        pbmCapabilityPropertyInstance.setValue(object);
        PbmCapabilityConstraintInstance pbmCapabilityConstraintInstance = new PbmCapabilityConstraintInstance();
        pbmCapabilityConstraintInstance.getPropertyInstance().add(pbmCapabilityPropertyInstance);
        PbmCapabilityInstance pbmCapabilityInstance = new PbmCapabilityInstance();
        pbmCapabilityInstance.setId(pbmCapabilityMetadata.getId());
        pbmCapabilityInstance.getConstraint().add(pbmCapabilityConstraintInstance);
        return pbmCapabilityInstance;
    }

    @Action
    public void createProfile() throws RuntimeFaultFaultMsg, com.vmware.pbm.RuntimeFaultFaultMsg, InvalidArgumentFaultMsg, PbmDuplicateNameFaultMsg, PbmFaultProfileStorageFaultFaultMsg {
        PbmCapabilityVendorNamespaceInfo pbmCapabilityVendorNamespaceInfo2;
        Object object2;
        this.spbmsc = this.connection.getPbmServiceContent();
        ManagedObjectReference managedObjectReference = this.spbmsc.getProfileManager();
        Boolean bl = false;
        List list = this.connection.getPbmPort().pbmFetchVendorInfo(managedObjectReference, null);
        block0: for (Object object2 : list) {
            for (PbmCapabilityVendorNamespaceInfo pbmCapabilityVendorNamespaceInfo2 : object2.getVendorNamespaceInfo()) {
                if (!pbmCapabilityVendorNamespaceInfo2.getNamespaceInfo().getNamespace().equalsIgnoreCase("vSan")) continue;
                bl = true;
                continue block0;
            }
        }
        if (!bl.booleanValue()) {
            throw new RuntimeFaultFaultMsg("Cannot create storage profile. vSAN Provider not found.", null);
        }
        List list2 = this.connection.getPbmPort().pbmFetchCapabilityMetadata(managedObjectReference, PbmUtil.getStorageResourceType(), null);
        object2 = new ArrayList();
        object2.add(this.buildCapability("stripeWidth", this.stripeWidth, list2));
        if (this.forceProvision.booleanValue()) {
            object2.add(this.buildCapability("forceProvisioning", this.forceProvision, list2));
        }
        PbmCapabilitySubProfile pbmCapabilitySubProfile = new PbmCapabilitySubProfile();
        pbmCapabilitySubProfile.getCapability().addAll(object2);
        pbmCapabilityVendorNamespaceInfo2 = new PbmCapabilitySubProfileConstraints();
        pbmCapabilitySubProfile.setName("Rule-Set " + (pbmCapabilityVendorNamespaceInfo2.getSubProfiles().size() + 1));
        pbmCapabilityVendorNamespaceInfo2.getSubProfiles().add(pbmCapabilitySubProfile);
        PbmCapabilityProfileCreateSpec pbmCapabilityProfileCreateSpec = new PbmCapabilityProfileCreateSpec();
        pbmCapabilityProfileCreateSpec.setName(this.profileName);
        pbmCapabilityProfileCreateSpec.setDescription("Storage Profile Created by SDK Samples. Rule based on vSAN capability");
        pbmCapabilityProfileCreateSpec.setResourceType(PbmUtil.getStorageResourceType());
        pbmCapabilityProfileCreateSpec.setConstraints((PbmCapabilityConstraints)pbmCapabilityVendorNamespaceInfo2);
        PbmProfileId pbmProfileId = this.connection.getPbmPort().pbmCreate(managedObjectReference, pbmCapabilityProfileCreateSpec);
        System.out.println("Profile " + this.profileName + " created with ID: " + pbmProfileId.getUniqueId());
    }

    @Option(name="forceprovision", description="If set, the object will be provisioned even if the policy is not satisfiable", required=false, parameter=false)
    public void setForceProvision(Boolean bl) {
        this.forceProvision = bl;
    }

    @Option(name="profilename", description="Name of the storage profile", required=true)
    public void setProfileName(String string) {
        this.profileName = string;
    }

    @Option(name="stripewidth", description="Minimum stripe width of each mirror", required=true)
    public void setStripeWidth(Integer n) {
        this.stripeWidth = n;
    }
}

