﻿/*

 ********************************************************

 * Copyright (c) VMware, Inc.2010, 2016. All Rights Reserved.

 ********************************************************

 *

 * DISCLAIMER. THIS PROGRAM IS PROVIDED TO YOU "AS IS" WITHOUT

 * WARRANTIES OR CONDITIONS OF ANY KIND, WHETHER ORAL OR WRITTEN,

 * EXPRESS OR IMPLIED. THE AUTHOR SPECIFICALLY DISCLAIMS ANY IMPLIED

 * WARRANTIES OR CONDITIONS OF MERCHANTABILITY, SATISFACTORY QUALITY,

 * NON-INFRINGEMENT AND FITNESS FOR A PARTICULAR PURPOSE.

 */



namespace AcquireHoKTokenByHoKTokenSample

{

    using System;

    using System.Net;

    using System.Security.Cryptography.X509Certificates;

    using System.Xml;

    using vmware.sso;

    using VMware.Binding.WsTrust;



    public class AcquireHoKTokenByHoKToken

    {

        # region private function Definition



        /// <summary>

        ///  This method is used to print message if there is insufficient parameter

        /// </summary>

        private static void PrintUsage()

        {

            Console.WriteLine("AcquireHoKTokenByHoKTokenSample [sso url] [username] [password]");

        }



        # endregion



        # region public function Definition



        /// <summary>

        ///  This method is used to get Token

        /// </summary>

        /// <param name="args">string Array  [sso url] [username] [password]</param>

        public static XmlElement GetToken(String[] args)

        {

            var ssoUrl = args[0];

            var ssoUserName = args[1];

            var ssoPassword = args[2];



            try

            {

                /*Code to Acquire HoK Token By User Credential starts Here*/



                ServicePointManager.SecurityProtocol |= SecurityProtocolType.Tls12;

                SamlTokenHelper.SetupServerCertificateValidation();

                X509Certificate2 signingCertificate = SamlTokenHelper.GetCertificate();

                STSService_PortTypeClient service =

                    SamlTokenHelper.GetSTSService(ssoUrl, ssoUserName, ssoPassword, signingCertificate);

                RequestSecurityTokenResponseCollectionType response =

                    service.Issue(SamlTokenHelper.GetHokRequestSecurityTokenType());

                RequestSecurityTokenResponseType rstResponse =

                    response.RequestSecurityTokenResponse;



                XmlElement token = rstResponse.RequestedSecurityToken;

                Console.WriteLine("Original SAML Token");

                SamlTokenHelper.PrintToken(token);



                /*Code to Acquire HoK Token By User Credential ends Here*/



                /*Code to Acquire HoK Token By HoK Token Sample starts Here*/



                // Initiate a new connection to acquire the next token

                STSService_PortTypeClient service2 = SamlTokenHelper.GetSTSService(ssoUrl, null, null, signingCertificate, token);



                RequestSecurityTokenResponseCollectionType responseAdditional =

                    service2.Issue(SamlTokenHelper.GetHokRequestSecurityTokenType());

                RequestSecurityTokenResponseType rstResponseAdditional =

                    response.RequestSecurityTokenResponse;

                XmlElement tokenAdditional = rstResponseAdditional.RequestedSecurityToken;

                Console.WriteLine("Renewed SAML Token");

                SamlTokenHelper.PrintToken(tokenAdditional);

                return tokenAdditional;



                /*Code to Acquire HoK Token By HoK Token Sample ends Here*/

            }

            catch (Exception ex)

            {

                Console.WriteLine(ex.ToString());



                throw ex;

            }

        }



        /// <summary>

        /// Main function of the application

        /// </summary>

        /// <param name="args">string args  [sso url] [username] [password]</param>

        public static void Main(string[] args)

        {

            if (args.Length < 3)

            {

                PrintUsage();

            }

            else

            {

                GetToken(args);

            }



            Console.WriteLine("Press Any Key To Exit.");

            Console.ReadLine();

        }



        # endregion

    }

}