﻿/*

 ********************************************************

 * Copyright (c) VMware, Inc.2010, 2016. All Rights Reserved.

 ********************************************************

 *

 * DISCLAIMER. THIS PROGRAM IS PROVIDED TO YOU "AS IS" WITHOUT

 * WARRANTIES OR CONDITIONS OF ANY KIND, WHETHER ORAL OR WRITTEN,

 * EXPRESS OR IMPLIED. THE AUTHOR SPECIFICALLY DISCLAIMS ANY IMPLIED

 * WARRANTIES OR CONDITIONS OF MERCHANTABILITY, SATISFACTORY QUALITY,

 * NON-INFRINGEMENT AND FITNESS FOR A PARTICULAR PURPOSE.

 */



namespace RenewTokenSample

{

    using AcquireHoKTokenByUserCredentialSample;

    using System;

    using System.Net;

    using System.Security.Cryptography.X509Certificates;

    using System.Xml;

    using VMware.Binding.WsTrust;

    using vmware.sso;



    public class RenewToken

    {

        # region private function Definition



        /// <summary>

        ///  This method is used to print message if there is insufficient parameter

        /// </summary>

        private static void PrintUsage()

        {

            Console.WriteLine("RenewTokenSample [sso url] [username] [password] [durationInSeconds]");

        }



        # endregion



        # region public function Definition



        /// <summary>

        ///  This method is used to renew Token

        /// </summary>

        /// <param name="args">string Array  [sso url] [username] [password] [durationInSeconds]</param>

        public static XmlElement GetRenewToken(String url, XmlElement token, int durationInSeconds)

        {

            /**

            * For this request we need at least the following element in the

            * RequestSecurityTokenType set

            *

            * 1. Lifetime - represented by LifetimeType which specifies the

            * lifetime for the token to be issued

            *

            * 2. Tokentype - "urnoasisnamestcSAML20assertion", which is the

            * class that models the requested token

            *

            * 3. RequestType -

            * "httpdocsoasisopenorgwssxwstrust200512Renew", as we want

            * to get a token issued

            *

            */

            RequestSecurityTokenType tokenType = new RequestSecurityTokenType();

            tokenType.TokenType = TokenTypeEnum.urnoasisnamestcSAML20assertion;

            tokenType.RequestType = RequestTypeEnum.httpdocsoasisopenorgwssxwstrust200512Renew;

            tokenType.RenewTarget = token;

            LifetimeType lifetime = SamlTokenHelper.GetLifetime(new TimeSpan(0, 0, durationInSeconds));



            try

            {

                ServicePointManager.SecurityProtocol |= SecurityProtocolType.Tls12;

                SamlTokenHelper.SetupServerCertificateValidation();

                X509Certificate2 signingCertificate = SamlTokenHelper.GetCertificate();

                STSService_PortTypeClient service = SamlTokenHelper.GetSTSService(url, null, null, signingCertificate);

                RequestSecurityTokenResponseType responseToken = service.Renew(tokenType);

                return responseToken.RequestedSecurityToken;

            }

            catch (Exception ex)

            {

                Console.WriteLine("Exception : " + ex.Message);

                throw ex;

            }

        }



        /// <summary>

        /// Main function of the application

        /// </summary>

        /// <param name="args">string args</param>

        public static void Main(string[] args)

        {

            if (args.Length < 4)

            {

                PrintUsage();

            }

            else

            {

                XmlElement token = AcquireHoKTokenByUserCredential.GetToken(args).RequestedSecurityToken;

                Console.WriteLine("Original SAML Token");

                SamlTokenHelper.PrintToken(token);

                if (token != null)

                {

                    Console.WriteLine("Renewed SAML Token");



                    SamlTokenHelper.PrintToken(GetRenewToken(args[0], token, Int32.Parse(args[3])));

                }

                else

                {

                    Console.WriteLine("Not able to get token from SSO server");

                }

            }

            Console.WriteLine("Press Any Key To Exit.");

            Console.Read();

        }



        # endregion

    }

}