﻿/*

 ********************************************************

 * Copyright (c) VMware, Inc.2010, 2016. All Rights Reserved.

 ********************************************************

 *

 * DISCLAIMER. THIS PROGRAM IS PROVIDED TO YOU "AS IS" WITHOUT

 * WARRANTIES OR CONDITIONS OF ANY KIND, WHETHER ORAL OR WRITTEN,

 * EXPRESS OR IMPLIED. THE AUTHOR SPECIFICALLY DISCLAIMS ANY IMPLIED

 * WARRANTIES OR CONDITIONS OF MERCHANTABILITY, SATISFACTORY QUALITY,

 * NON-INFRINGEMENT AND FITNESS FOR A PARTICULAR PURPOSE.

 */



namespace ValidateTokenSample

{

    using AcquireBearerTokenByUserCredentialSample;

    using System;

    using System.Net;

    using System.Xml;

    using VMware.Binding.WsTrust;

    using vmware.sso;



    internal class ValidateToken

    {

        # region private function Definition



        /// <summary>

        ///  This method is used to print message if there is insufficient parameter

        /// </summary>

        private static void PrintUsage()

        {

            Console.WriteLine("ValidateTokenSample [sso url] [username] [password]");

        }



        /// <summary>

        /// Method to do intentional tampering of token to invalidate it for verification

        /// </summary>

        /// <param name="token">SAML token</param>

        private static void TamperToken(XmlElement token)

        {

            String issueInstanct = token.Attributes.GetNamedItem(SamlTokenHelper.strIssueInstant).Value;

            TimeSpan duration = new TimeSpan(2, 0, 0);

            String expireDate = XmlConvert.ToString(DateTime.Now.Subtract(duration), XmlDateTimeSerializationMode.Utc);

            Console.WriteLine("Changing the Issue time to " + expireDate + " from " + issueInstanct);

            token.Attributes.GetNamedItem(SamlTokenHelper.strIssueInstant).Value = expireDate;

        }



        # endregion



        # region public function Definition



        /// <summary>

        /// This method is used to validate Token

        /// </summary>

        /// <param name="url">SSO Server Url</param>

        /// <param name="token">SAML Token to be validated</param>

        public static void TokenValidation(String url, XmlElement token)

        {

            RequestSecurityTokenType tokenType = new RequestSecurityTokenType();

            tokenType.TokenType = TokenTypeEnum.httpdocsoasisopenorgwssxwstrust200512RSTRStatus;

            tokenType.RequestType = RequestTypeEnum.httpdocsoasisopenorgwssxwstrust200512Validate;

            tokenType.ValidateTarget = token;



            ServicePointManager.SecurityProtocol |= SecurityProtocolType.Tls12;

            SamlTokenHelper.SetupServerCertificateValidation();



            try

            {

                STSService_PortTypeClient service = SamlTokenHelper.GetSTSService(url, null, null, null);



                RequestSecurityTokenResponseType responseToken = service.Validate(tokenType);

                StatusType status = (StatusType)responseToken.Status;



                //checking for the validity of token

                if (status.Code.Equals(StatusCodeEnum.httpdocsoasisopenorgwssxwstrust200512statusvalid))

                {

                    Console.WriteLine("Token Status : Valid");

                }

                else

                {

                    Console.WriteLine("Token Status : Invalid");

                    Console.WriteLine("Reason : " + status.Reason);

                }

            }

            catch (Exception ex)

            {

                Console.WriteLine("{0}", ex.Message);

            }

        }



        /// <summary>

        /// Main function of the application

        /// </summary>

        /// <param name="args">string args [sso url] [username] [password]</param>

        static void Main(string[] args)

        {

            if (args.Length < 3)

            {

                PrintUsage();

            }

            else

            {

                XmlElement token = AcquireBearerTokenByUserCredential.GetBearerToken(args[0], args[1], args[2]).RequestedSecurityToken;

                SamlTokenHelper.PrintToken(token);

                if (token != null)

                {

                    TokenValidation(args[0], token);

                    Console.WriteLine("Tampering the token locally - Validation should fail now");

                    TamperToken(token);

                    TokenValidation(args[0], token);

                }

                else

                {

                    Console.WriteLine("Not able to get token from SSO server");

                }

            }

            Console.WriteLine("Press Any Key To Exit.");

            Console.Read();

        }



        # endregion

    }

}