@setlocal
@echo off

set WSDLHOME="%~dp0..\..\wsdl\vim25"
set SDK_LIB="%~dp0..\cs\samples\lib\"
set STS_SDK_LIB="%~dp0..\..\..\ssoclient\dotnet\cs\samples\lib\"

powershell Set-ExecutionPolicy Unrestricted || goto ERROR

copy %WSDLHOME%\vim-types.xsd %WSDLHOME%\vim-types_fixed.xsd || goto ERROR

echo Fixing HttpNfcLeaseInfo type, adding missing leaseState property
powershell -F Fix-VimTypes.ps1 -FileName %WSDLHOME%\vim-types_fixed.xsd || goto ERROR

echo Generating VimService.cs
svcutil %WSDLHOME%\core-types.xsd %WSDLHOME%\query-messagetypes.xsd %WSDLHOME%\query-types.xsd %WSDLHOME%\vim-messagetypes.xsd %WSDLHOME%\vim-types_fixed.xsd %WSDLHOME%\vim.wsdl %WSDLHOME%\VimService.wsdl /noConfig /serializer:XmlSerializer /useSerializerForFaults /namespace:*,Vim25Api /async /o:VimService.cs || goto ERROR

echo Compiling original VimService.dll
csc /t:library /out:Vim25ApiUnpatched.dll VimService.cs >nul || goto ERROR

@rem Build xml serializer
svcutil /t:xmlSerializer Vim25ApiUnpatched.dll /out:VimServiceSerializers.cs || goto ERROR

@rem Backup VimSerice.cs
copy VimService.cs VimService.Orig.cs || goto ERROR

echo Optimizing VimService.cs by stripping serializer hint attributes.
powershell -F Fix-WcfContract.ps1 -SourceFileName VimService.Orig.cs -DestinationFileName VimService.cs || goto ERROR

echo Compiling optimized VimService.dll
csc /t:library /out:Vim25Service.dll VimService.cs VimServiceSerializers.cs >nul || goto ERROR

echo Copying Vim25Service.dll to lib dir
copy Vim25Service.dll %SDK_LIB% || goto ERROR
copy Vim25Service.dll %STS_SDK_LIB% || goto ERROR

echo Done.
goto EOF

:ERROR
echo FAILED
@endlocal
exit /b 1

:EOF
@endlocal