/*
 * ******************************************************
 * Copyright (c) VMware, Inc. 2010.  All Rights Reserved.
 * ******************************************************
 *
 * DISCLAIMER. THIS PROGRAM IS PROVIDED TO YOU "AS IS" WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, WHETHER ORAL OR WRITTEN,
 * EXPRESS OR IMPLIED. THE AUTHOR SPECIFICALLY DISCLAIMS ANY IMPLIED
 * WARRANTIES OR CONDITIONS OF MERCHANTABILITY, SATISFACTORY QUALITY,
 * NON-INFRINGEMENT AND FITNESS FOR A PARTICULAR PURPOSE.
 */

using System;
using System.Collections;
using AppUtil;
using Vim25Api;
using System.Net;

namespace HostPowerOps
{
   public class HostPowerOpsV25
    {
        static Vim25Api.VimService _service;
        static ServiceContent _sic;
       public static void powerDownHost(VimApi.ManagedObjectReference hmor, String[] args, ArrayList apiVersions, Cookie cookie)
       {
      ExtendedAppUtil ecb = null;                  
      ecb = ExtendedAppUtil.initialize("PowerDownHostToStandBy"
                                       , HostPowerOps.constructOptions()
                                       ,args);
      ecb.connect(cookie);

      _service = ecb.getServiceConnectionV25().Service;
      _sic = ecb.getServiceConnectionV25().ServiceContent;          
      // Convert the vim managed object to vim25 managed object
      ManagedObjectReference hmor1  = 
         VersionUtil.convertManagedObjectReference(hmor);
                
      ManagedObjectReference taskmor =  _service.PowerDownHostToStandBy_Task(hmor1,120,false,true);
      String result = ecb.getServiceUtilV25().WaitForTask(taskmor);
      if(result.Equals("sucess")) {
         Console.WriteLine("Operation powerDownHostToStandBy"
                            +" completed sucessfully");
      }
   }
    }
}
