/*
 * ******************************************************
 * Copyright (c) VMware, Inc. 2010.  All Rights Reserved.
 * ******************************************************
 *
 * DISCLAIMER. THIS PROGRAM IS PROVIDED TO YOU "AS IS" WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, WHETHER ORAL OR WRITTEN,
 * EXPRESS OR IMPLIED. THE AUTHOR SPECIFICALLY DISCLAIMS ANY IMPLIED
 * WARRANTIES OR CONDITIONS OF MERCHANTABILITY, SATISFACTORY QUALITY,
 * NON-INFRINGEMENT AND FITNESS FOR A PARTICULAR PURPOSE.
 */

using System;
using AppUtil;
using Vim25Api;

namespace SDRSRecommendation
{
    ///<summary>
    /// This sample demonstrates how to Run the Storage DRS on a given SDRS cluster and show
    /// the list of recommendations generated by SDRS.
    ///</summary>
    ///<param name="storagepodname">Required: Name of storage pod</param>
    ///
    ///List storage recommnedation
    ///--url [webserviceurl]
    ///--username [username] --password [password]  --storagepodname [storagepodname]
    ///</remarks>
    public class SDRSRecommendation
    {
        private static AppUtil.AppUtil cb = null;

        /// <summary>
        /// Method to list all storage recommendation
        /// </summary>
        private void StorageRecommendation()
        {
            string podName = cb.get_option("storagepodname");
            PodStorageDrsEntry podStorageDrsEntry = null;
            ManagedObjectReference srmRef = cb._connection._sic.storageResourceManager;
            ManagedObjectReference sdrsMor = cb._svcUtil.getEntityByName("StoragePod", podName);
            if (sdrsMor != null)
            {
                cb._connection._service.RefreshStorageDrsRecommendation(srmRef, sdrsMor);
                Console.WriteLine("Success: Refresh Cluster Recommendation");
                string[] type = new string[] { "podStorageDrsEntry" };
                podStorageDrsEntry = (PodStorageDrsEntry)cb._svcUtil.GetDynamicProperty(sdrsMor, "podStorageDrsEntry");
                ClusterRecommendation[] clusterrecommendations = podStorageDrsEntry.recommendation;
                if (clusterrecommendations != null)
                {
                    Console.WriteLine("List of Recommnedation");
                    foreach (ClusterRecommendation recommend in clusterrecommendations)
                    {
                        Console.WriteLine(recommend.type + "Reson" + recommend.reason + "target"
                               + recommend.target.Value);
                    }
                }
                else
                {
                    Console.WriteLine("No recommendations for this storage pod");
                }
            }
            else
            {
                throw new Exception("Failure: StoragePod " + podName
               + " not found.");
            }

        }

        private static OptionSpec[] constructOptions()
        {
            OptionSpec[] useroptions = new OptionSpec[1];
            useroptions[0] = new OptionSpec("storagepodname", "String", 1
                                           , "Storage pod name"
                                           , null);
            return useroptions;
        }

        public static void Main(string[] args)
        {
            SDRSRecommendation app = new SDRSRecommendation();
            cb = AppUtil.AppUtil.initialize("SDRSRecommendation", SDRSRecommendation.constructOptions(), args);
            try
            {
                cb.connect();
                app.StorageRecommendation();
                cb.disConnect();
            }
            catch (Exception e)
            {
                Console.WriteLine(e.Message);
            }
        }
    }
}
