/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.sso.client.samples;

import com.rsa.names._2009._12.product.riat.wsdl.STSService;
import com.rsa.names._2009._12.product.riat.wsdl.STSServicePortType;
import com.vmware.sso.client.samples.AcquireBearerTokenByUserCredentialSample;
import com.vmware.sso.client.samples.AcquireHoKTokenByUserCredentialSample;
import com.vmware.sso.client.soaphandlers.HeaderHandlerResolver;
import com.vmware.sso.client.soaphandlers.TimeStampHandler;
import com.vmware.sso.client.utils.SecurityUtil;
import com.vmware.sso.client.utils.Utils;
import jakarta.xml.ws.BindingProvider;
import jakarta.xml.ws.handler.HandlerResolver;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSession;
import javax.xml.datatype.DatatypeConfigurationException;
import org.oasis_open.docs.ws_sx.ws_trust._200512.RequestSecurityTokenResponseType;
import org.oasis_open.docs.ws_sx.ws_trust._200512.RequestSecurityTokenType;
import org.oasis_open.docs.ws_sx.ws_trust._200512.StatusType;
import org.oasis_open.docs.ws_sx.ws_trust._200512.ValidateTargetType;
import org.w3c.dom.Element;

public class ValidateTokenSample {
    public static boolean isTokenValid(String string, Element element) throws DatatypeConfigurationException {
        STSService sTSService = new STSService();
        HeaderHandlerResolver headerHandlerResolver = new HeaderHandlerResolver();
        headerHandlerResolver.addHandler(new TimeStampHandler());
        sTSService.setHandlerResolver((HandlerResolver)headerHandlerResolver);
        STSServicePortType sTSServicePortType = sTSService.getSTSServicePort();
        RequestSecurityTokenType requestSecurityTokenType = new RequestSecurityTokenType();
        requestSecurityTokenType.setTokenType("http://docs.oasis-open.org/ws-sx/ws-trust/200512/RSTR/Status");
        requestSecurityTokenType.setRequestType("http://docs.oasis-open.org/ws-sx/ws-trust/200512/Validate");
        ValidateTargetType validateTargetType = new ValidateTargetType();
        validateTargetType.setAny(element);
        requestSecurityTokenType.setValidateTarget(validateTargetType);
        Map map = ((BindingProvider)sTSServicePortType).getRequestContext();
        map.put("jakarta.xml.ws.service.endpoint.address", string);
        RequestSecurityTokenResponseType requestSecurityTokenResponseType = sTSServicePortType.validate(requestSecurityTokenType);
        StatusType statusType = requestSecurityTokenResponseType.getStatus();
        String string2 = statusType.getCode();
        System.out.println("Token Status is determined to be " + string2);
        return string2.equalsIgnoreCase("http://docs.oasis-open.org/ws-sx/ws-trust/200512/status/valid");
    }

    private static void printUsage() {
        System.out.println("run.bat com.vmware.sso.client.samples.ValidateTokenSample [sso url] [username] [password]");
    }

    public static void main(String[] stringArray) throws DatatypeConfigurationException {
        if (stringArray.length < 3) {
            ValidateTokenSample.printUsage();
            return;
        }
        HostnameVerifier hostnameVerifier = new HostnameVerifier(){

            @Override
            public boolean verify(String string, SSLSession sSLSession) {
                return true;
            }
        };
        HttpsURLConnection.setDefaultHostnameVerifier(hostnameVerifier);
        Utils.trustAllHttpsCertificates();
        System.out.println("Acquiring bearer token using AcquireBearerTokenByUserCredentialSample sample");
        Element element = AcquireBearerTokenByUserCredentialSample.getToken(stringArray);
        Utils.printToken(element);
        System.out.println("Validating the acquired token");
        System.out.println("The bearer token is " + (ValidateTokenSample.isTokenValid(stringArray[0], element) ? "valid" : "invalid"));
        System.out.println("\nAcquiring HoK token using AcquireHoKTokenByUserCredentialSample sample");
        SecurityUtil securityUtil = SecurityUtil.loadFromDefaultFiles();
        element = AcquireHoKTokenByUserCredentialSample.getToken(stringArray, securityUtil.getPrivateKey(), securityUtil.getUserCert());
        Utils.printToken(element);
        System.out.println("Validating the acquired token");
        System.out.println("The HoK token is " + (ValidateTokenSample.isTokenValid(stringArray[0], element) ? "valid" : "invalid"));
    }
}

