/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.sso.client.utils;

import com.vmware.sso.client.utils.TrustAllTrustManager;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBElement;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.soap.SOAPException;
import jakarta.xml.soap.SOAPHeader;
import jakarta.xml.ws.handler.soap.SOAPMessageContext;
import java.io.IOException;
import java.io.OutputStream;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSessionContext;
import javax.net.ssl.TrustManager;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.oasis_open.docs.wss._2004._01.oasis_200401_wss_wssecurity_secext_1_0.ObjectFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Utils {
    static final ObjectFactory wsseObjFactory = new ObjectFactory();

    public static String getNodeProperty(Node node, String string) {
        return node.getAttributes().getNamedItem(string).getNodeValue();
    }

    public static Node getSecurityElement(SOAPHeader sOAPHeader) {
        NodeList nodeList = sOAPHeader.getElementsByTagNameNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "Security");
        if (nodeList == null || nodeList.getLength() == 0) {
            JAXBElement jAXBElement = wsseObjFactory.createSecurity(wsseObjFactory.createSecurityHeaderType());
            Element element = Utils.marshallJaxbElement(jAXBElement).getDocumentElement();
            return sOAPHeader.appendChild(sOAPHeader.getOwnerDocument().importNode(element, true));
        }
        if (nodeList.getLength() > 1) {
            throw new RuntimeException("Error inserting Security header into the SOAP message. Too many Security found.");
        }
        return nodeList.item(0);
    }

    public static SOAPHeader getSOAPHeader(SOAPMessageContext sOAPMessageContext) throws SOAPException {
        return sOAPMessageContext.getMessage().getSOAPPart().getEnvelope().getHeader() == null ? sOAPMessageContext.getMessage().getSOAPPart().getEnvelope().addHeader() : sOAPMessageContext.getMessage().getSOAPPart().getEnvelope().getHeader();
    }

    public static boolean isHoKToken(Node node) {
        if (Utils.isSamlToken(node)) {
            NodeList nodeList = ((Element)node).getElementsByTagNameNS("urn:oasis:names:tc:SAML:2.0:assertion", "SubjectConfirmation");
            if (nodeList.getLength() != 1) {
                throw new IllegalArgumentException("Token provided is not a SAML token");
            }
            Node node2 = nodeList.item(0).getAttributes().getNamedItem("Method");
            return "urn:oasis:names:tc:SAML:2.0:cm:holder-of-key".equalsIgnoreCase(node2.getNodeValue());
        }
        throw new RuntimeException("The Node does not represnt a SAML token");
    }

    public static boolean isOutgoingMessage(SOAPMessageContext sOAPMessageContext) {
        Boolean bl = (Boolean)sOAPMessageContext.get((Object)"jakarta.xml.ws.handler.message.outbound");
        return bl;
    }

    public static boolean isSamlToken(Node node) {
        boolean bl = false;
        bl = "urn:oasis:names:tc:SAML:2.0:assertion".equalsIgnoreCase(node.getNamespaceURI()) && "assertion".equalsIgnoreCase(node.getLocalName());
        return bl;
    }

    public static final <T> Document marshallJaxbElement(JAXBElement<T> jAXBElement) {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        Document document = null;
        try {
            JAXBContext jAXBContext = JAXBContext.newInstance((String)"org.oasis_open.docs.ws_sx.ws_trust._200512:org.oasis_open.docs.wss._2004._01.oasis_200401_wss_wssecurity_secext_1_0:org.oasis_open.docs.wss._2004._01.oasis_200401_wss_wssecurity_utility_1_0");
            document = documentBuilderFactory.newDocumentBuilder().newDocument();
            jAXBContext.createMarshaller().marshal(jAXBElement, (Node)document);
        }
        catch (JAXBException jAXBException) {
            jAXBException.printStackTrace();
            throw new RuntimeException("Error marshalling JAXB document", jAXBException);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            parserConfigurationException.printStackTrace();
            throw new RuntimeException("Error marshalling JAXB document", parserConfigurationException);
        }
        return document;
    }

    public static void printMessage(SOAPMessageContext sOAPMessageContext) {
        try {
            System.out.println("*********Message Start********");
            System.out.println("This is a " + ((Boolean)sOAPMessageContext.get((Object)"jakarta.xml.ws.handler.message.outbound") != false ? "Outbound request" : "Inbound response"));
            sOAPMessageContext.getMessage().writeTo((OutputStream)System.out);
            System.out.println("*********Message End**********");
        }
        catch (SOAPException sOAPException) {
            sOAPException.printStackTrace();
            throw new RuntimeException(sOAPException);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new RuntimeException(iOException);
        }
    }

    public static void printToken(Element element) {
        if (Utils.isSamlToken(element)) {
            System.out.println("Token details:");
            System.out.println("\tAssertionId = " + Utils.getNodeProperty(element, "ID"));
            System.out.println("\tToken type = " + (Utils.isHoKToken(element) ? "Holder-Of-Key" : "Bearer"));
            System.out.println("\tIssued On = " + Utils.getNodeProperty(element, "IssueInstant"));
        } else {
            System.out.println("Invalid token");
        }
    }

    public static void trustAllHttpsCertificates() {
        try {
            TrustManager[] trustManagerArray = new TrustManager[1];
            TrustAllTrustManager trustAllTrustManager = new TrustAllTrustManager();
            trustManagerArray[0] = trustAllTrustManager;
            SSLContext sSLContext = SSLContext.getInstance("SSL");
            SSLSessionContext sSLSessionContext = sSLContext.getServerSessionContext();
            sSLSessionContext.setSessionTimeout(0);
            sSLContext.init(null, trustManagerArray, null);
            HttpsURLConnection.setDefaultSSLSocketFactory(sSLContext.getSocketFactory());
        }
        catch (KeyManagementException keyManagementException) {
            keyManagementException.printStackTrace();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            noSuchAlgorithmException.printStackTrace();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            illegalArgumentException.printStackTrace();
        }
    }
}

