/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.sso.client.wssecurity;

import com.vmware.sso.client.utils.Utils;
import com.vmware.sso.client.wssecurity.WsSecuritySignatureImpl;
import jakarta.xml.soap.SOAPMessage;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import javax.xml.namespace.QName;
import org.oasis_open.docs.wss._2004._01.oasis_200401_wss_wssecurity_secext_1_0.KeyIdentifierType;
import org.oasis_open.docs.wss._2004._01.oasis_200401_wss_wssecurity_secext_1_0.ObjectFactory;
import org.oasis_open.docs.wss._2004._01.oasis_200401_wss_wssecurity_secext_1_0.SecurityTokenReferenceType;
import org.w3c.dom.Node;

public class WsSecuritySignatureAssertion
extends WsSecuritySignatureImpl {
    private final String _assertionId;

    public WsSecuritySignatureAssertion(PrivateKey privateKey, X509Certificate x509Certificate, String string) {
        super(privateKey, x509Certificate);
        assert (string != null);
        this._assertionId = string;
    }

    @Override
    protected String addUseKeySignatureId(SOAPMessage sOAPMessage) {
        return null;
    }

    @Override
    protected Node createKeyInfoContent(SOAPMessage sOAPMessage) {
        return this.createSecurityTokenReference();
    }

    private Node createSecurityTokenReference() {
        ObjectFactory objectFactory = new ObjectFactory();
        SecurityTokenReferenceType securityTokenReferenceType = objectFactory.createSecurityTokenReferenceType();
        KeyIdentifierType keyIdentifierType = objectFactory.createKeyIdentifierType();
        keyIdentifierType.setValue(this._assertionId);
        keyIdentifierType.setValueType("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLID");
        securityTokenReferenceType.getAny().add(objectFactory.createKeyIdentifier(keyIdentifierType));
        securityTokenReferenceType.getOtherAttributes().put(new QName("http://docs.oasis-open.org/wss/oasis-wss-wssecurity-secext-1.1.xsd", "TokenType", "wsse11"), "http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV2.0");
        return Utils.marshallJaxbElement(objectFactory.createSecurityTokenReference(securityTokenReferenceType)).getFirstChild();
    }
}

