/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.fcd;

import com.vmware.common.annotations.Action;
import com.vmware.common.annotations.Option;
import com.vmware.common.annotations.Sample;
import com.vmware.connection.ConnectedVimServiceBase;
import com.vmware.fcd.helpers.FcdHelper;
import com.vmware.fcd.helpers.FcdVslmHelper;
import com.vmware.vslm.VslmPortType;
import java.util.Arrays;

@Sample(name="fcd-controlflagsoperations", description="This sample sets and clears control flags on VStorageObject from vslm.")
public class FcdControlFlagsOperations
extends ConnectedVimServiceBase {
    private String vStorageObjectId;
    private String controlFlags;

    @Option(name="vstorageobjectid", required=true, description="Uuid of the vstorageobject.")
    public void setVStorageObjectId(String string) {
        this.vStorageObjectId = string;
    }

    @Option(name="controlflags", required=true, description="Control flags enum array to be set on the VStorageObject.")
    public void setControlFlags(String string) {
        this.controlFlags = string;
    }

    void controlFlagOperations() throws Exception {
        FcdVslmHelper fcdVslmHelper = new FcdVslmHelper(this.connection);
        VslmPortType vslmPortType = fcdVslmHelper.getVslmPort();
        System.out.println("Operation: Setting control flags on VStorageObject from vslm : " + this.controlFlags);
        vslmPortType.vslmSetVStorageObjectControlFlags(fcdVslmHelper.getVStorageObjMgr(), FcdHelper.makeId((String)this.vStorageObjectId), Arrays.asList(this.controlFlags));
        System.out.printf("Control flag [flag = %s ] set for vStorageObject : %n [ Uuid = %s ]%n from vslm.", this.controlFlags, this.vStorageObjectId);
        System.out.println("Operation: Clearing control flags on VStorageObject from vslm.");
        vslmPortType.vslmClearVStorageObjectControlFlags(fcdVslmHelper.getVStorageObjMgr(), FcdHelper.makeId((String)this.vStorageObjectId), Arrays.asList(this.controlFlags));
        System.out.printf("Control flag [flag = %s] cleared from vStorageObject : %n [ Uuid = %s ] %n from vslm.", this.controlFlags, this.vStorageObjectId);
    }

    @Action
    public void run() throws Exception {
        System.out.println("Invoking control flag operations on VStorageObject from VSLM ::");
        this.controlFlagOperations();
    }
}

