/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.fcd;

import com.vmware.common.annotations.Action;
import com.vmware.common.annotations.Before;
import com.vmware.common.annotations.Option;
import com.vmware.common.annotations.Sample;
import com.vmware.connection.ConnectedVimServiceBase;
import com.vmware.fcd.helpers.FcdUtil;
import com.vmware.fcd.helpers.FcdVslmHelper;
import com.vmware.vim25.InvalidCollectorVersionFaultMsg;
import com.vmware.vim25.InvalidPropertyFaultMsg;
import com.vmware.vim25.LocalizedMethodFault;
import com.vmware.vim25.ManagedObjectReference;
import com.vmware.vim25.RuntimeFaultFaultMsg;
import com.vmware.vim25.TaskInfoState;
import com.vmware.vim25.VStorageObject;
import com.vmware.vim25.VslmCreateSpec;
import com.vmware.vslm.VslmPortType;
import com.vmware.vslm.VslmTaskInfo;
import java.util.HashMap;
import java.util.Map;

@Sample(name="fcd-create", description="This sample creates a virtual storage object(FCD) from vslm endpoint")
public class FcdCreateFromVslm
extends ConnectedVimServiceBase {
    private String vStorageObjectName;
    private String datastoreName;
    private long vStorageObjectSizeInMB;
    private String provisioningType = "thin";
    private String deviceName;
    private final Map<String, FcdUtil.DiskProvisioningTypes> provisioningTypeHashMap = new HashMap<String, FcdUtil.DiskProvisioningTypes>();

    @Option(name="vstorageobjectname", required=true, description="Name of the Disk.")
    public void setVStorageObjectName(String string) {
        this.vStorageObjectName = string;
    }

    @Option(name="datastorename", required=true, description="Name of datastore.")
    public void setDatastoreName(String string) {
        this.datastoreName = string;
    }

    @Option(name="vstorageobjectsizeinMB", required=true, description="Size of the Disk (in MB)")
    public void setVStorageObjectSize(long l) {
        this.vStorageObjectSizeInMB = l;
    }

    @Option(name="provisioningtype", required=false, description="Provisioning Type of the Disk.\n [thin | eagerZeroedThick | lazyZeroedThick | virtualMode | physicalMode]")
    public void setProvisioningType(String string) {
        this.provisioningType = string;
    }

    @Option(name="devicename", required=false, description="Canonical name of the LUN to use for RDM provisioning type.")
    public void setDeviceName(String string) {
        this.deviceName = string;
    }

    @Before
    public void init() {
        this.provisioningTypeHashMap.put("thin", FcdUtil.DiskProvisioningTypes.THIN);
        this.provisioningTypeHashMap.put("eagerzeroedthick", FcdUtil.DiskProvisioningTypes.EAGER_ZEROED_THICK);
        this.provisioningTypeHashMap.put("lazyzeroedthick", FcdUtil.DiskProvisioningTypes.LAZY_ZEROED_THICK);
        this.provisioningTypeHashMap.put("virtualmode", FcdUtil.DiskProvisioningTypes.VIRTUAL_MODE);
        this.provisioningTypeHashMap.put("physicalmode", FcdUtil.DiskProvisioningTypes.PHYSICAL_MODE);
    }

    boolean getTaskResultAfterDone(ManagedObjectReference managedObjectReference) throws InvalidPropertyFaultMsg, RuntimeFaultFaultMsg, InvalidCollectorVersionFaultMsg {
        boolean bl = false;
        Object[] objectArray = this.waitForValues.wait(managedObjectReference, new String[]{"info.state", "info.error"}, new String[]{"state"}, (Object[][])new Object[][]{{TaskInfoState.SUCCESS, TaskInfoState.ERROR}});
        if (objectArray[0].equals(TaskInfoState.SUCCESS)) {
            bl = true;
        }
        if (objectArray[1] instanceof LocalizedMethodFault) {
            throw new RuntimeException(((LocalizedMethodFault)objectArray[1]).getLocalizedMessage());
        }
        return bl;
    }

    void createVStorageObject() throws Exception {
        VslmTaskInfo vslmTaskInfo;
        VStorageObject vStorageObject = null;
        ManagedObjectReference managedObjectReference = this.connection.getServiceContent().getVStorageObjectManager();
        FcdUtil.DiskProvisioningTypes diskProvisioningTypes = this.provisioningTypeHashMap.get(this.provisioningType.trim().toLowerCase());
        if (diskProvisioningTypes == null) {
            throw new RuntimeException("The input provisioning Type is not valid.");
        }
        ManagedObjectReference managedObjectReference2 = (ManagedObjectReference)this.getMOREFs.inContainerByType(this.serviceContent.getRootFolder(), "Datastore").get(this.datastoreName);
        if (managedObjectReference2 == null) {
            throw new RuntimeException("The datastore name is not valid.");
        }
        VslmCreateSpec vslmCreateSpec = FcdUtil.generateVslmCreateSpec(managedObjectReference2, diskProvisioningTypes, this.deviceName, this.vStorageObjectName, this.vStorageObjectSizeInMB);
        FcdVslmHelper fcdVslmHelper = new FcdVslmHelper(this.connection);
        VslmPortType vslmPortType = fcdVslmHelper.getVslmPort();
        System.out.println("Operation: Creating a vStorageObject");
        ManagedObjectReference managedObjectReference3 = vslmPortType.vslmCreateDiskTask(fcdVslmHelper.getVStorageObjMgr(), vslmCreateSpec);
        Boolean bl = fcdVslmHelper.waitForTask(managedObjectReference3);
        if (bl.booleanValue()) {
            System.out.println("Create disk task is succeded");
            vslmTaskInfo = vslmPortType.vslmQueryInfo(managedObjectReference3);
            vStorageObject = (VStorageObject)vslmTaskInfo.getResult();
            System.out.printf("Success: Created vStorageObject :  %n [ Name = %s ] %n [ Uuid = %s ] %n [ DatastorePath = %s ]%n", vStorageObject.getConfig().getName(), vStorageObject.getConfig().getId().getId(), FcdUtil.getFcdFilePath(vStorageObject));
        }
        System.out.println("Operation: Retrieve the  createdVStorageObjects in datastore.");
        vslmTaskInfo = vslmPortType.vslmRetrieveVStorageObject(fcdVslmHelper.getVStorageObjMgr(), vStorageObject.getConfig().getId());
        if (!vslmTaskInfo.getConfig().getId().getId().equals(vStorageObject.getConfig().getId().getId())) {
            String string = "Error: Created VStorageObject [ " + vStorageObject.getConfig().getId().getId() + "] and retrieved VStorageObject are different.";
            throw new RuntimeException(string);
        }
        System.out.printf("Success: Retrieved vStorageObject :: %n [ %s ]%n", vslmTaskInfo.getConfig().getId().getId());
    }

    @Action
    public void run() throws Exception {
        this.init();
        this.createVStorageObject();
    }
}

