/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.fcd;

import com.vmware.common.annotations.Action;
import com.vmware.common.annotations.Option;
import com.vmware.common.annotations.Sample;
import com.vmware.connection.ConnectedVimServiceBase;
import com.vmware.fcd.helpers.FcdHelper;
import com.vmware.fcd.helpers.FcdVslmHelper;
import com.vmware.vim25.ID;
import com.vmware.vim25.ManagedObjectReference;
import com.vmware.vim25.VStorageObject;
import com.vmware.vslm.VslmPortType;
import com.vmware.vslm.VslmVsoVStorageObjectAssociations;
import com.vmware.vslm.VslmVsoVStorageObjectAssociationsVmDiskAssociation;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@Sample(name="legacy-disk-and-association", description="This sample registers a given legacy disk as FCD, attach FCD to VM and retrieve FCD associations.")
public class FcdLegacyDiskAndAssociationOperations
extends ConnectedVimServiceBase {
    private String vStorageObjectId;
    private String legacyDiskFileName;
    private String dataCenterName;
    private String fcdName;
    private String vmName;
    private Integer controllerKey;
    private Integer unitNumber;

    @Option(name="vstorageobjectid", required=true, description="Uuid of the vstorageobject to  be attached  to vm.")
    public void setVStorageObjectId(String string) {
        this.vStorageObjectId = string;
    }

    @Option(name="legacydiskfilename", required=true, description="File name of the legacy disk.")
    public void setLegacyDiskFileName(String string) {
        this.legacyDiskFileName = string;
    }

    @Option(name="datacentername", required=true, description="Name of the datacenter")
    public void setDataCenterName(String string) {
        this.dataCenterName = string;
    }

    @Option(name="fcdname", required=false, description="File name of the legacy disk.")
    public void setFcdName(String string) {
        this.fcdName = string;
    }

    @Option(name="vmname", required=true, description="Name of virtual machine.")
    public void setVmName(String string) {
        this.vmName = string;
    }

    @Option(name="controllerkey", required=false, description="Device Key of the controller.")
    public void setControllerKey(String string) {
        this.controllerKey = Integer.parseInt(string);
    }

    @Option(name="unitnumber", required=false, description="Unit number of the virtual machine.")
    public void setUnitNumber(String string) {
        this.unitNumber = Integer.parseInt(string);
    }

    void legacyDiskAndAssociationOperations() throws Exception {
        String string = this.getDiskPathForVc(this.legacyDiskFileName);
        FcdVslmHelper fcdVslmHelper = new FcdVslmHelper(this.connection);
        VslmPortType vslmPortType = fcdVslmHelper.getVslmPort();
        System.out.println("Operation: Register a legacy disk as FCD with disk Path :: " + string);
        VStorageObject vStorageObject = vslmPortType.vslmRegisterDisk(fcdVslmHelper.getVStorageObjMgr(), string, this.fcdName);
        System.out.printf("Success: Registered Disk(now a vStorageObject) : [Uuid = %s ] with Name [ %s ]%n", vStorageObject.getConfig().getId().getId(), vStorageObject.getConfig().getName());
        ManagedObjectReference managedObjectReference = this.connection.getServiceContent().getPropertyCollector();
        ManagedObjectReference managedObjectReference2 = this.getMOREFs.vmByVMname(this.vmName, managedObjectReference);
        System.out.println("VM MOR : " + managedObjectReference2.getValue());
        System.out.println("Operation: Retrieving a vStorageObject");
        VStorageObject vStorageObject2 = vslmPortType.vslmRetrieveVStorageObject(fcdVslmHelper.getVStorageObjMgr(), FcdHelper.makeId((String)this.vStorageObjectId));
        System.out.println("Success: Retrieved vStorageObject ::" + vStorageObject2.getConfig().getId().getId());
        System.out.println("Operation:  Attaching a given vStorageObject to the given virtualMachine.");
        ManagedObjectReference managedObjectReference3 = vslmPortType.vslmAttachDiskTask(fcdVslmHelper.getVStorageObjMgr(), vStorageObject2.getConfig().getId(), managedObjectReference2, this.controllerKey, this.unitNumber);
        Boolean bl = fcdVslmHelper.waitForTask(managedObjectReference3);
        if (!bl.booleanValue()) {
            String string2 = "Error: Attaching [ " + vStorageObject2.getConfig().getId().getId() + "] vStorageObject";
            throw new RuntimeException(string2);
        }
        System.out.printf("Success: Attached vStorageObjectId : [ Name = %s , Id = %s ] to VM [ Name = %s ]%n", vStorageObject2.getConfig().getName(), vStorageObject2.getConfig().getId().getId(), this.vmName);
        System.out.println("Operation: Retrieve the vStorageObjects in datastore.");
        VStorageObject vStorageObject3 = vslmPortType.vslmRetrieveVStorageObject(fcdVslmHelper.getVStorageObjMgr(), vStorageObject2.getConfig().getId());
        if (vStorageObject3.getConfig().getId().getId().equals(vStorageObject2.getConfig().getId().getId())) {
            if (vStorageObject3.getConfig().getConsumerId().get(0) == null) {
                String string3 = "Error: Given vStorageObject [ " + vStorageObject2.getConfig().getId().getId() + "] does not have a consumer attached to it.";
                throw new RuntimeException(string3);
            }
        } else {
            String string4 = "Error: Given vStorageObject [ " + vStorageObject2.getConfig().getId().getId() + "] and retrieved VStorageObject are different.";
            throw new RuntimeException(string4);
        }
        System.out.printf("Success: Retrieved vStorageObject :: %n [ Uuid = %s ] is associated with consumer [ ConsumerId = %s ]%n", vStorageObject3.getConfig().getId().getId(), ((ID)vStorageObject3.getConfig().getConsumerId().get(0)).getId());
        System.out.println("Operation : Retrieve vStorage object association ::");
        List list = vslmPortType.vslmRetrieveVStorageObjectAssociations(fcdVslmHelper.getVStorageObjMgr(), Arrays.asList(vStorageObject2.getConfig().getId()));
        System.out.printf("RetrieveVStorageObjectAssociations returned association list of size : [ %s ] for vStorageObject : [ %s ] from vslm.%n", list.size(), vStorageObject2.getConfig().getId());
        for (VslmVsoVStorageObjectAssociations vslmVsoVStorageObjectAssociations : list) {
            for (VslmVsoVStorageObjectAssociationsVmDiskAssociation vslmVsoVStorageObjectAssociationsVmDiskAssociation : vslmVsoVStorageObjectAssociations.getVmDiskAssociation()) {
                System.out.printf("VirtualMachine Key :: [ %s ]and Disk Key :: [ %s ]", vslmVsoVStorageObjectAssociationsVmDiskAssociation.getVmId(), vslmVsoVStorageObjectAssociationsVmDiskAssociation.getDiskKey());
            }
        }
    }

    private String getDiskPathForVc(String string) {
        Object object;
        String string2 = "\\[(.*)\\]\\s(.*)/(.*\\.vmdk)";
        String string3 = null;
        String string4 = null;
        String string5 = null;
        if (Pattern.matches(string2, string)) {
            System.out.println("Info: FileName Pattern matches required pattern.");
            object = Pattern.compile(string2);
            Matcher matcher = ((Pattern)object).matcher(string);
            if (matcher.find()) {
                string3 = matcher.group(1);
                string4 = matcher.group(2);
                string5 = matcher.group(3);
            }
        }
        object = "https://" + this.connection.getHost() + "/folder/" + string4 + "/" + string5 + "?dcPath=" + this.dataCenterName + "&dsName=" + string3;
        return object;
    }

    @Action
    public void run() throws Exception {
        System.out.println("Registering Legacy disk as FCD, attaching FCD to VM and retrieving FCD associations from VSLM ::");
        this.legacyDiskAndAssociationOperations();
    }
}

