/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.fcd;

import com.vmware.common.annotations.Action;
import com.vmware.common.annotations.Before;
import com.vmware.common.annotations.Option;
import com.vmware.common.annotations.Sample;
import com.vmware.connection.ConnectedVimServiceBase;
import com.vmware.fcd.helpers.FcdVslmHelper;
import com.vmware.vim25.BaseConfigInfoBackingInfo;
import com.vmware.vim25.BaseConfigInfoDiskFileBackingInfoProvisioningType;
import com.vmware.vim25.BaseConfigInfoFileBackingInfo;
import com.vmware.vim25.ID;
import com.vmware.vim25.KeyValue;
import com.vmware.vim25.ManagedObjectReference;
import com.vmware.vim25.VStorageObject;
import com.vmware.vim25.VStorageObjectSnapshotInfo;
import com.vmware.vim25.VStorageObjectSnapshotInfoVStorageObjectSnapshot;
import com.vmware.vim25.VirtualDiskCompatibilityMode;
import com.vmware.vim25.VslmCreateSpec;
import com.vmware.vim25.VslmCreateSpecBackingSpec;
import com.vmware.vim25.VslmCreateSpecDiskFileBackingSpec;
import com.vmware.vim25.VslmCreateSpecRawDiskMappingBackingSpec;
import com.vmware.vslm.VslmPortType;
import com.vmware.vslm.VslmTaskInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Sample(name="fcd-metatdataoperations", description="This sample creates FCD with metadata, retrieves metadata, retrieves metadata value and update metadata from vslm.")
public class FcdMetadataOperations
extends ConnectedVimServiceBase {
    private String vStorageObjectName;
    private String datastoreName;
    private long vStorageObjectSizeInMB;
    private String provisioningType = "thin";
    private String deviceName;
    private final Map<String, DiskProvisioningTypes> provisioningTypeHashMap = new HashMap<String, DiskProvisioningTypes>();
    private String description = "snapshot description";

    @Option(name="vstorageobjectname", required=true, description="Name of the Disk.")
    public void setVStorageObjectName(String string) {
        this.vStorageObjectName = string;
    }

    @Option(name="datastorename", required=true, description="Name of datastore.")
    public void setDatastoreName(String string) {
        this.datastoreName = string;
    }

    @Option(name="vstorageobjectsizeinMB", required=true, description="Size of the Disk (in MB)")
    public void setVStorageObjectSize(long l) {
        this.vStorageObjectSizeInMB = l;
    }

    @Option(name="provisioningtype", required=false, description="Provisioning Type of the Disk.\n [thin | eagerZeroedThick | lazyZeroedThick | virtualMode | physicalMode]")
    public void setProvisioningType(String string) {
        this.provisioningType = string;
    }

    @Option(name="devicename", required=false, description="Canonical name of the LUN to use for RDM provisioning type.")
    public void setDeviceName(String string) {
        this.deviceName = string;
    }

    @Before
    public void init() {
        this.provisioningTypeHashMap.put("thin", DiskProvisioningTypes.THIN);
        this.provisioningTypeHashMap.put("eagerzeroedthick", DiskProvisioningTypes.EAGER_ZEROED_THICK);
        this.provisioningTypeHashMap.put("lazyzeroedthick", DiskProvisioningTypes.LAZY_ZEROED_THICK);
        this.provisioningTypeHashMap.put("virtualmode", DiskProvisioningTypes.VIRTUAL_MODE);
        this.provisioningTypeHashMap.put("physicalmode", DiskProvisioningTypes.PHYSICAL_MODE);
    }

    void metadataOperations() throws Exception {
        Object object2;
        FcdVslmHelper fcdVslmHelper = new FcdVslmHelper(this.connection);
        VslmPortType vslmPortType = fcdVslmHelper.getVslmPort();
        DiskProvisioningTypes diskProvisioningTypes = this.provisioningTypeHashMap.get(this.provisioningType.trim().toLowerCase());
        if (diskProvisioningTypes == null) {
            throw new RuntimeException("The input provisioning Type is not valid.");
        }
        ManagedObjectReference managedObjectReference = (ManagedObjectReference)this.getMOREFs.inContainerByType(this.serviceContent.getRootFolder(), "Datastore").get(this.datastoreName);
        if (managedObjectReference == null) {
            throw new RuntimeException("The datastore name is not valid.");
        }
        VslmCreateSpec vslmCreateSpec = this.generateVslmCreateSpec(managedObjectReference, diskProvisioningTypes);
        System.out.println("Operation: Creating a vStorageObject with metadata");
        ManagedObjectReference managedObjectReference2 = vslmPortType.vslmCreateDiskTask(fcdVslmHelper.getVStorageObjMgr(), vslmCreateSpec);
        VStorageObject vStorageObject = null;
        Boolean bl = fcdVslmHelper.waitForTask(managedObjectReference2);
        if (!bl.booleanValue()) {
            String string = "Error: Creating [ " + this.vStorageObjectName + "] vStorageObject";
            throw new RuntimeException(string);
        }
        System.out.println("Create disk with metadata task has succeded");
        VslmTaskInfo vslmTaskInfo = vslmPortType.vslmQueryInfo(managedObjectReference2);
        vStorageObject = (VStorageObject)vslmTaskInfo.getResult();
        System.out.printf("Success: Created vStorageObject :  %n [ Name = %s ] %n [ Uuid = %s ] %n [ DatastorePath = %s ]%n", vStorageObject.getConfig().getName(), vStorageObject.getConfig().getId().getId(), FcdMetadataOperations.getFcdFilePath(vStorageObject));
        System.out.println("Operation: Retrieve the  createdVStorageObjects in datastore.");
        vslmTaskInfo = vslmPortType.vslmRetrieveVStorageObject(fcdVslmHelper.getVStorageObjMgr(), vStorageObject.getConfig().getId());
        if (!vslmTaskInfo.getConfig().getId().getId().equals(vStorageObject.getConfig().getId().getId())) {
            String string = "Error: Created VStorageObject [ " + vStorageObject.getConfig().getId().getId() + "] and retrieved VStorageObject are different.";
            throw new RuntimeException(string);
        }
        System.out.printf("Success: Retrieved vStorageObject :: %n [ %s ]%n", vslmTaskInfo.getConfig().getId().getId());
        System.out.println("Operation: Creating snapshot of given vStorageObject from vslm.");
        ManagedObjectReference managedObjectReference3 = vslmPortType.vslmCreateSnapshotTask(fcdVslmHelper.getVStorageObjMgr(), vStorageObject.getConfig().getId(), this.description);
        ID iD = null;
        Boolean bl2 = fcdVslmHelper.waitForTask(managedObjectReference3);
        if (!bl2.booleanValue()) {
            String string = "Error: Creating vStorageObject [ " + vStorageObject.getConfig().getId() + "] snapshot from vslm.";
            throw new RuntimeException(string);
        }
        System.out.println("snapshot disk task is succeded");
        VslmTaskInfo vslmTaskInfo2 = vslmPortType.vslmQueryInfo(managedObjectReference3);
        iD = (ID)vslmTaskInfo2.getResult();
        System.out.printf("Success: Created snapshot : [ Id = %s ] of vStorageObject : [ UUID = %s ] from vslm.", iD.getId(), vStorageObject.getConfig().getId().getId());
        System.out.println("Operation: Retrieve VStorageObject snapshots from vslm.");
        vslmTaskInfo2 = vslmPortType.vslmRetrieveSnapshotInfo(fcdVslmHelper.getVStorageObjMgr(), vStorageObject.getConfig().getId());
        if (vslmTaskInfo2.getSnapshots().size() <= 0 || !FcdMetadataOperations.isSnapshotIdInSnapshotList((VStorageObjectSnapshotInfo)vslmTaskInfo2, iD)) {
            String string = "Error: Retrieving VStorageObject Snapshot [ " + iD.getId() + " ] from vslm.";
            throw new RuntimeException(string);
        }
        System.out.printf("Success: Retrieved vStorageObject Snapshot :: [ %s ] from vslm.", iD.getId());
        System.out.println("Operation: Retrieving metadata of a given VStorageObject from vslm.");
        List list = vslmPortType.vslmRetrieveVStorageObjectMetadata(fcdVslmHelper.getVStorageObjMgr(), vStorageObject.getConfig().getId(), iD, null);
        if (list == null || list.isEmpty()) {
            String string = "Error: Retrieved metadata ofvStorageObject [ " + vStorageObject.getConfig().getId().getId() + "] from vslm.";
            throw new RuntimeException(string);
        }
        System.out.printf("Success: Retrieved metadata of vStorageObject :: vStorageObjectId %n [ %s ]%n", vStorageObject.getConfig().getId().getId());
        System.out.printf("metadata key value returned by retrieveVStorageObjectMetadata: %n", new Object[0]);
        for (Object object2 : list) {
            System.out.printf("Metadata key [ " + object2.getKey() + " ] %n ", new Object[0]);
            System.out.printf("Metadata value [ " + object2.getValue() + " ] %n ", new Object[0]);
        }
        System.out.println("Operation: Retrieving metadata value of a given VStorageObject from vslm.");
        String string = vslmPortType.vslmRetrieveVStorageObjectMetadataValue(fcdVslmHelper.getVStorageObjMgr(), vStorageObject.getConfig().getId(), iD, ((KeyValue)list.get(0)).getKey());
        if (string == null) {
            object2 = "Error: Retrieved metadata value ofvStorageObject [ " + vStorageObject.getConfig().getId().getId() + "] from vslm.";
            throw new RuntimeException((String)object2);
        }
        System.out.printf("Success: Retrieved metadata value of vStorageObject :: vStorageObjectId %n [ %s ]%n", vStorageObject.getConfig().getId().getId());
        System.out.printf("metadata value returned by retrieveVStorageObjectMetadataValue: %n", new Object[0]);
        System.out.printf("Metadata value [ " + (String)string + " ] %n ", new Object[0]);
        object2 = ((KeyValue)list.get(0)).getValue() + "-updated";
        KeyValue keyValue = new KeyValue();
        keyValue.setKey(((KeyValue)list.get(0)).getKey());
        keyValue.setValue((String)object2);
        ArrayList<KeyValue> arrayList = new ArrayList<KeyValue>();
        arrayList.add(keyValue);
        System.out.println("Operation: Updating metadata value of a given VStorageObject from vslm.");
        ManagedObjectReference managedObjectReference4 = vslmPortType.vslmUpdateVStorageObjectMetadataTask(fcdVslmHelper.getVStorageObjMgr(), vStorageObject.getConfig().getId(), arrayList, null);
        Boolean bl3 = fcdVslmHelper.waitForTask(managedObjectReference4);
        if (!bl3.booleanValue()) {
            String string2 = "Error: Updating metadata of vStorageObject [ " + vStorageObject.getConfig().getId().getId() + "] from vslm.";
            throw new RuntimeException(string2);
        }
        System.out.printf("Success: Updating metadata  of vStorageObject :: vStorageObjectId %n [ %s ]%n", vStorageObject.getConfig().getId().getId());
        System.out.println("Operation: Retrieving metadata of a given VStorageObject from vslm.");
        List list2 = vslmPortType.vslmRetrieveVStorageObjectMetadata(fcdVslmHelper.getVStorageObjMgr(), vStorageObject.getConfig().getId(), null, null);
        if (list2 == null) {
            String string3 = "Error: Retrieved metadata of vStorageObject [ " + vStorageObject.getConfig().getId().getId() + "] from vslm.";
            throw new RuntimeException(string3);
        }
        System.out.println("retrievedMetadataList : " + list2);
        System.out.printf("Success: Retrieved metadata of vStorageObject :: vStorageObjectId %n [ %s ]%n", vStorageObject.getConfig().getId().getId());
        System.out.println("Verify list of metadata key-values updated properly from vslm ::");
        for (KeyValue keyValue2 : list2) {
            if (!keyValue2.getKey().equals(((KeyValue)list.get(0)).getKey()) || !keyValue2.getValue().equals(object2)) continue;
            System.out.println("VStorage object metadata updated succesfully from vslm :");
            System.out.println("updated metadata key : " + keyValue2.getKey());
            System.out.println("updated metadata value : " + keyValue2.getValue());
            break;
        }
    }

    public static boolean isSnapshotIdInSnapshotList(VStorageObjectSnapshotInfo vStorageObjectSnapshotInfo, ID iD) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (VStorageObjectSnapshotInfoVStorageObjectSnapshot vStorageObjectSnapshotInfoVStorageObjectSnapshot : vStorageObjectSnapshotInfo.getSnapshots()) {
            arrayList.add(vStorageObjectSnapshotInfoVStorageObjectSnapshot.getId().getId());
        }
        return arrayList.contains(iD.getId());
    }

    public VslmCreateSpec generateVslmCreateSpec(ManagedObjectReference managedObjectReference, DiskProvisioningTypes diskProvisioningTypes) throws IllegalArgumentException {
        VslmCreateSpecDiskFileBackingSpec vslmCreateSpecDiskFileBackingSpec;
        VslmCreateSpecDiskFileBackingSpec vslmCreateSpecDiskFileBackingSpec2;
        System.out.println("Info :: Creating VslmCreateSpec with dsMor: " + managedObjectReference.getValue() + " provisioningType:" + diskProvisioningTypes.toString());
        if (diskProvisioningTypes != DiskProvisioningTypes.VIRTUAL_MODE && diskProvisioningTypes != DiskProvisioningTypes.PHYSICAL_MODE) {
            vslmCreateSpecDiskFileBackingSpec2 = new VslmCreateSpecDiskFileBackingSpec();
            vslmCreateSpecDiskFileBackingSpec2.setDatastore(managedObjectReference);
            vslmCreateSpecDiskFileBackingSpec2.setProvisioningType(BaseConfigInfoDiskFileBackingInfoProvisioningType.valueOf((String)diskProvisioningTypes.toString()).value());
            vslmCreateSpecDiskFileBackingSpec = vslmCreateSpecDiskFileBackingSpec2;
        } else {
            if (this.deviceName == null || this.deviceName.isEmpty()) {
                throw new IllegalArgumentException("The devicename is mandatory for specified disktype [ " + diskProvisioningTypes.value() + " ]");
            }
            vslmCreateSpecDiskFileBackingSpec2 = new VslmCreateSpecRawDiskMappingBackingSpec();
            vslmCreateSpecDiskFileBackingSpec2.setDatastore(managedObjectReference);
            vslmCreateSpecDiskFileBackingSpec2.setCompatibilityMode(VirtualDiskCompatibilityMode.valueOf((String)diskProvisioningTypes.toString()).value());
            vslmCreateSpecDiskFileBackingSpec2.setLunUuid(this.deviceName);
            vslmCreateSpecDiskFileBackingSpec = vslmCreateSpecDiskFileBackingSpec2;
        }
        vslmCreateSpecDiskFileBackingSpec2 = new VslmCreateSpec();
        vslmCreateSpecDiskFileBackingSpec2.setBackingSpec((VslmCreateSpecBackingSpec)vslmCreateSpecDiskFileBackingSpec);
        vslmCreateSpecDiskFileBackingSpec2.setName(this.vStorageObjectName);
        vslmCreateSpecDiskFileBackingSpec2.setCapacityInMB(this.vStorageObjectSizeInMB);
        vslmCreateSpecDiskFileBackingSpec2.getMetadata().add(this.generateMetadataPair(1).get(0));
        return vslmCreateSpecDiskFileBackingSpec2;
    }

    public List<KeyValue> generateMetadataPair(int n) {
        ArrayList<KeyValue> arrayList = new ArrayList<KeyValue>();
        for (int i = 0; i < n; ++i) {
            KeyValue keyValue = new KeyValue();
            keyValue.setKey("SampleKey-" + i);
            keyValue.setValue("SampleValue-" + i);
            arrayList.add(keyValue);
        }
        return arrayList;
    }

    public static String getFcdFilePath(VStorageObject vStorageObject) {
        BaseConfigInfoBackingInfo baseConfigInfoBackingInfo = vStorageObject.getConfig().getBacking();
        if (baseConfigInfoBackingInfo instanceof BaseConfigInfoFileBackingInfo) {
            BaseConfigInfoFileBackingInfo baseConfigInfoFileBackingInfo = (BaseConfigInfoFileBackingInfo)baseConfigInfoBackingInfo;
            return baseConfigInfoFileBackingInfo.getFilePath();
        }
        return null;
    }

    @Action
    public void run() throws Exception {
        System.out.println("Invoking metadata operations from VSLM ::");
        this.init();
        this.metadataOperations();
    }

    private static enum DiskProvisioningTypes {
        THIN("thin"),
        EAGER_ZEROED_THICK("eagerZeroedThick"),
        LAZY_ZEROED_THICK("lazyZeroedThick"),
        VIRTUAL_MODE("virtualMode"),
        PHYSICAL_MODE("physicalMode");

        private final String value;

        private DiskProvisioningTypes(String string2) {
            this.value = string2;
        }

        public String value() {
            return this.value;
        }
    }
}

