/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.fcd;

import com.vmware.common.annotations.Action;
import com.vmware.common.annotations.Before;
import com.vmware.common.annotations.Option;
import com.vmware.common.annotations.Sample;
import com.vmware.connection.ConnectedVimServiceBase;
import com.vmware.fcd.helpers.FcdHelper;
import com.vmware.fcd.helpers.FcdVslmHelper;
import com.vmware.vim25.BaseConfigInfoDiskFileBackingInfoProvisioningType;
import com.vmware.vim25.HostScsiDisk;
import com.vmware.vim25.ManagedObjectReference;
import com.vmware.vim25.VStorageObject;
import com.vmware.vim25.VirtualDiskCompatibilityMode;
import com.vmware.vim25.VslmCloneSpec;
import com.vmware.vim25.VslmCreateSpecBackingSpec;
import com.vmware.vim25.VslmCreateSpecDiskFileBackingSpec;
import com.vmware.vim25.VslmCreateSpecRawDiskMappingBackingSpec;
import com.vmware.vim25.VslmRelocateSpec;
import com.vmware.vslm.VslmDatastoreSyncStatus;
import com.vmware.vslm.VslmPortType;
import com.vmware.vslm.VslmTaskInfo;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Sample(name="fcd-migrationoperation", description="This sample clones and relocates a virtual storage object from vslm.")
public class FcdMigrationOperations
extends ConnectedVimServiceBase {
    private String vStorageObjectId;
    private String destDatastoreName;
    private String clonedDiskName;
    private String provisioningType = "thin";
    private HostScsiDisk hostScsiDisk = null;
    private final Map<String, DiskProvisioningTypes> provisioningTypeHashMap = new HashMap<String, DiskProvisioningTypes>();

    @Before
    public void init() {
        this.provisioningTypeHashMap.put("thin", DiskProvisioningTypes.THIN);
        this.provisioningTypeHashMap.put("eagerzeroedthick", DiskProvisioningTypes.EAGER_ZEROED_THICK);
        this.provisioningTypeHashMap.put("lazyzeroedthick", DiskProvisioningTypes.LAZY_ZEROED_THICK);
        this.provisioningTypeHashMap.put("virtualmode", DiskProvisioningTypes.VIRTUAL_MODE);
        this.provisioningTypeHashMap.put("physicalmode", DiskProvisioningTypes.PHYSICAL_MODE);
    }

    @Option(name="vstorageobjectid", required=true, description="Uuid of the vstorageobject.")
    public void setVStorageObjectId(String string) {
        this.vStorageObjectId = string;
    }

    @Option(name="destdatastoredame", required=true, description="Name of destination datastore.")
    public void setDestDatastoreName(String string) {
        this.destDatastoreName = string;
    }

    @Option(name="cloneddiskname", required=true, description="Name of the cloned Disk.")
    public void setVStorageObjectName(String string) {
        this.clonedDiskName = string;
    }

    @Option(name="provisioningtype", required=false, description="Provisioning Type of the Disk.\n [thin | eagerZeroedThick | lazyZeroedThick | virtualMode | physicalMode]")
    public void setProvisioningType(String string) {
        this.provisioningType = string;
    }

    @Option(name="hostscsidisk", required=false, description="Uuid of the scsi disk.")
    public void setHostScsiDisk(HostScsiDisk hostScsiDisk) {
        this.hostScsiDisk = hostScsiDisk;
    }

    void cloneRelocateOperations() throws Exception {
        FcdVslmHelper fcdVslmHelper = new FcdVslmHelper(this.connection);
        VslmPortType vslmPortType = fcdVslmHelper.getVslmPort();
        DiskProvisioningTypes diskProvisioningTypes = this.provisioningTypeHashMap.get(this.provisioningType.trim().toLowerCase());
        if (diskProvisioningTypes == null) {
            throw new RuntimeException("The input provisioning Type is not valid.");
        }
        ManagedObjectReference managedObjectReference = (ManagedObjectReference)this.getMOREFs.inContainerByType(this.serviceContent.getRootFolder(), "Datastore").get(this.destDatastoreName);
        if (managedObjectReference == null) {
            throw new RuntimeException("The datastore name is not valid.");
        }
        VslmCloneSpec vslmCloneSpec = this.generateVslmCloneSpec(managedObjectReference, diskProvisioningTypes);
        System.out.println("Operation: Cloning a vStorageObject from vslm.");
        ManagedObjectReference managedObjectReference2 = vslmPortType.vslmCloneVStorageObjectTask(fcdVslmHelper.getVStorageObjMgr(), FcdHelper.makeId((String)this.vStorageObjectId), vslmCloneSpec);
        Boolean bl = fcdVslmHelper.waitForTask(managedObjectReference2);
        VStorageObject vStorageObject = null;
        if (!bl.booleanValue()) {
            String string = "Error: Cloning [ " + FcdHelper.makeId((String)this.vStorageObjectId) + "] vStorageObject from vslm.";
            throw new RuntimeException(string);
        }
        VslmTaskInfo vslmTaskInfo = vslmPortType.vslmQueryInfo(managedObjectReference2);
        vStorageObject = (VStorageObject)vslmTaskInfo.getResult();
        System.out.printf("Success: vStorageObject : [ Uuid = %s ]   cloned : [ Uuid = %s ] to [ datastore = %s ] from vslm.%n", this.vStorageObjectId, vStorageObject.getConfig().getId().getId(), managedObjectReference);
        System.out.println("Operation: Retrieve the clonedVStorageObject in datastore from vslm.");
        vslmTaskInfo = vslmPortType.vslmRetrieveVStorageObject(fcdVslmHelper.getVStorageObjMgr(), vStorageObject.getConfig().getId());
        if (!vslmTaskInfo.getConfig().getId().getId().equals(vStorageObject.getConfig().getId().getId())) {
            String string = "Error: Cloned VStorageObject [ " + vStorageObject.getConfig().getId().getId() + " ] and retrieved VStorageObject are different from vslm.";
            throw new RuntimeException(string);
        }
        System.out.printf("Success: Retrieved vStorageObject :: [ %s ] from vslm.", vslmTaskInfo.getConfig().getId().getId());
        VslmRelocateSpec vslmRelocateSpec = this.generateVslmRelocateSpec(managedObjectReference, diskProvisioningTypes);
        System.out.println("Operation: Relocating a vStorageObject from vslm.");
        ManagedObjectReference managedObjectReference3 = vslmPortType.vslmRelocateVStorageObjectTask(fcdVslmHelper.getVStorageObjMgr(), FcdHelper.makeId((String)this.vStorageObjectId), vslmRelocateSpec);
        Boolean bl2 = fcdVslmHelper.waitForTask(managedObjectReference3);
        VStorageObject vStorageObject2 = null;
        if (!bl2.booleanValue()) {
            String string = "Error: Relocating [ " + FcdHelper.makeId((String)this.vStorageObjectId) + "] vStorageObject to [ datastore = %s ] from vslm." + managedObjectReference;
            throw new RuntimeException(string);
        }
        VslmTaskInfo vslmTaskInfo2 = vslmPortType.vslmQueryInfo(managedObjectReference3);
        vStorageObject2 = (VStorageObject)vslmTaskInfo2.getResult();
        System.out.printf("Success: Relocated vStorageObject :  %n [ Name = %s ] %n [ Uuid = %s ] %n to destination datastore [ datastore = %s ].%n", vStorageObject2.getConfig().getName(), vStorageObject2.getConfig().getId().getId(), managedObjectReference.getValue());
        System.out.println("Operation: Retrieve the  createdVStorageObjects in datastore from vslm.");
        vslmTaskInfo2 = vslmPortType.vslmRetrieveVStorageObject(fcdVslmHelper.getVStorageObjMgr(), vStorageObject2.getConfig().getId());
        if (!vslmTaskInfo2.getConfig().getId().getId().equals(vStorageObject2.getConfig().getId().getId())) {
            String string = "Error: Created VStorageObject [ " + vStorageObject2.getConfig().getId().getId() + " ] and retrieved VStorageObject are different from vslm.";
            throw new RuntimeException(string);
        }
        System.out.printf("Success: Retrieved vStorageObject :: [ %s ] from vslm.", vslmTaskInfo2.getConfig().getId().getId());
        System.out.println("Operation:  Query synchronization status of the global catalog from vslm.");
        List list = vslmPortType.vslmQueryGlobalCatalogSyncStatus(fcdVslmHelper.getVStorageObjMgr());
        if (!list.isEmpty()) {
            System.out.println("Success: Retrieved synchronization status for the below datastores : ");
            for (Object object : list) {
                System.out.println("Datastore URL : " + object.getDatastoreURL());
            }
        } else {
            String string = "Error : Failed to retrieve synchronization status of the global catalog.";
            throw new RuntimeException(string);
        }
        System.out.println("Operation:  Query synchronization status of the global catalog for a specified datastore from vslm.");
        VslmDatastoreSyncStatus vslmDatastoreSyncStatus = vslmPortType.vslmQueryGlobalCatalogSyncStatusForDatastore(fcdVslmHelper.getVStorageObjMgr(), ((VslmDatastoreSyncStatus)list.get(0)).getDatastoreURL());
        if (vslmDatastoreSyncStatus == null) {
            Object object;
            object = "Error : Failed to retrieve synchronization status of the global catalog for a specified datastore.";
            throw new RuntimeException((String)object);
        }
        System.out.println("Success: Retrieved synchronization status for datastore : ");
        System.out.println("Datastore URL : " + ((VslmDatastoreSyncStatus)list.get(0)).getDatastoreURL());
    }

    public VslmCloneSpec generateVslmCloneSpec(ManagedObjectReference managedObjectReference, DiskProvisioningTypes diskProvisioningTypes) throws IllegalArgumentException {
        VslmCreateSpecRawDiskMappingBackingSpec vslmCreateSpecRawDiskMappingBackingSpec;
        VslmCreateSpecRawDiskMappingBackingSpec vslmCreateSpecRawDiskMappingBackingSpec2;
        System.out.println("Info :: Creating VslmCloneSpec with dsMor: " + managedObjectReference.getValue() + " provisioningType: " + diskProvisioningTypes.toString());
        if (diskProvisioningTypes != DiskProvisioningTypes.VIRTUAL_MODE && diskProvisioningTypes != DiskProvisioningTypes.PHYSICAL_MODE) {
            vslmCreateSpecRawDiskMappingBackingSpec2 = new VslmCreateSpecDiskFileBackingSpec();
            vslmCreateSpecRawDiskMappingBackingSpec2.setDatastore(managedObjectReference);
            vslmCreateSpecRawDiskMappingBackingSpec2.setProvisioningType(BaseConfigInfoDiskFileBackingInfoProvisioningType.valueOf((String)diskProvisioningTypes.toString()).value());
            vslmCreateSpecRawDiskMappingBackingSpec = vslmCreateSpecRawDiskMappingBackingSpec2;
        } else {
            vslmCreateSpecRawDiskMappingBackingSpec2 = new VslmCreateSpecRawDiskMappingBackingSpec();
            vslmCreateSpecRawDiskMappingBackingSpec2.setDatastore(managedObjectReference);
            vslmCreateSpecRawDiskMappingBackingSpec2.setCompatibilityMode(VirtualDiskCompatibilityMode.valueOf((String)diskProvisioningTypes.toString()).value());
            vslmCreateSpecRawDiskMappingBackingSpec2.setLunUuid(this.hostScsiDisk.getUuid());
            vslmCreateSpecRawDiskMappingBackingSpec = vslmCreateSpecRawDiskMappingBackingSpec2;
        }
        vslmCreateSpecRawDiskMappingBackingSpec2 = new VslmCloneSpec();
        vslmCreateSpecRawDiskMappingBackingSpec2.setBackingSpec((VslmCreateSpecBackingSpec)vslmCreateSpecRawDiskMappingBackingSpec);
        vslmCreateSpecRawDiskMappingBackingSpec2.setName(this.clonedDiskName);
        return vslmCreateSpecRawDiskMappingBackingSpec2;
    }

    public VslmRelocateSpec generateVslmRelocateSpec(ManagedObjectReference managedObjectReference, DiskProvisioningTypes diskProvisioningTypes) throws IllegalArgumentException {
        VslmCreateSpecRawDiskMappingBackingSpec vslmCreateSpecRawDiskMappingBackingSpec;
        VslmCreateSpecRawDiskMappingBackingSpec vslmCreateSpecRawDiskMappingBackingSpec2;
        System.out.println("Info :: Creating VslmRelocateSpec with dsMor: " + managedObjectReference.getValue() + " provisioningType:" + diskProvisioningTypes.toString());
        if (diskProvisioningTypes != DiskProvisioningTypes.VIRTUAL_MODE && diskProvisioningTypes != DiskProvisioningTypes.PHYSICAL_MODE) {
            vslmCreateSpecRawDiskMappingBackingSpec2 = new VslmCreateSpecDiskFileBackingSpec();
            vslmCreateSpecRawDiskMappingBackingSpec2.setDatastore(managedObjectReference);
            vslmCreateSpecRawDiskMappingBackingSpec2.setProvisioningType(BaseConfigInfoDiskFileBackingInfoProvisioningType.valueOf((String)diskProvisioningTypes.toString()).value());
            vslmCreateSpecRawDiskMappingBackingSpec = vslmCreateSpecRawDiskMappingBackingSpec2;
        } else {
            vslmCreateSpecRawDiskMappingBackingSpec2 = new VslmCreateSpecRawDiskMappingBackingSpec();
            vslmCreateSpecRawDiskMappingBackingSpec2.setDatastore(managedObjectReference);
            vslmCreateSpecRawDiskMappingBackingSpec2.setCompatibilityMode(VirtualDiskCompatibilityMode.valueOf((String)diskProvisioningTypes.toString()).value());
            vslmCreateSpecRawDiskMappingBackingSpec2.setLunUuid(this.hostScsiDisk.getUuid());
            vslmCreateSpecRawDiskMappingBackingSpec = vslmCreateSpecRawDiskMappingBackingSpec2;
        }
        vslmCreateSpecRawDiskMappingBackingSpec2 = new VslmRelocateSpec();
        vslmCreateSpecRawDiskMappingBackingSpec2.setBackingSpec((VslmCreateSpecBackingSpec)vslmCreateSpecRawDiskMappingBackingSpec);
        return vslmCreateSpecRawDiskMappingBackingSpec2;
    }

    @Action
    public void run() throws Exception {
        System.out.println("Cloning and Relocating vStorage Object from VSLM ::");
        this.init();
        this.cloneRelocateOperations();
    }

    private static enum DiskProvisioningTypes {
        THIN("thin"),
        EAGER_ZEROED_THICK("eagerZeroedThick"),
        LAZY_ZEROED_THICK("lazyZeroedThick"),
        VIRTUAL_MODE("virtualMode"),
        PHYSICAL_MODE("physicalMode");

        private final String value;

        private DiskProvisioningTypes(String string2) {
            this.value = string2;
        }

        public String value() {
            return this.value;
        }
    }
}

