/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.fcd;

import com.vmware.common.annotations.Action;
import com.vmware.common.annotations.Option;
import com.vmware.common.annotations.Sample;
import com.vmware.connection.ConnectedVimServiceBase;
import com.vmware.fcd.helpers.FcdVslmHelper;
import com.vmware.vim25.ManagedObjectReference;
import com.vmware.vslm.VslmPortType;

@Sample(name="fcd-reconciledatastoreinventoryoperations", description="This sample reconcile the datastore inventory info of virtual storage objects and schedules reconcile of the inventory info of virtual storage objects on one of the hosts that is connected with the datastore from vslm.")
public class FcdReconcileDatastoreInventoryOperations
extends ConnectedVimServiceBase {
    private String datastoreName;

    @Option(name="datastorename", required=true, description="Name of datastore that needs to be reconciled from vslm.")
    public void setDatastoreName(String string) {
        this.datastoreName = string;
    }

    void reconcileDSInventoryOperation() throws Exception {
        FcdVslmHelper fcdVslmHelper = new FcdVslmHelper(this.connection);
        VslmPortType vslmPortType = fcdVslmHelper.getVslmPort();
        ManagedObjectReference managedObjectReference = (ManagedObjectReference)this.getMOREFs.inContainerByType(this.serviceContent.getRootFolder(), "Datastore").get(this.datastoreName);
        System.out.println("Operation: Scheduleing reconcile of the inventory from vslm");
        vslmPortType.vslmScheduleReconcileDatastoreInventory(fcdVslmHelper.getVStorageObjMgr(), managedObjectReference);
        System.out.printf("Scheduled reconcile of the inventory info of virtual storage objects on one of the hosts that is connected with the datastore: [ %s ] from vslm.", managedObjectReference);
        System.out.println("Operation: Reconciling the datastore inventory info of virtual storage objects from vslm.");
        ManagedObjectReference managedObjectReference2 = vslmPortType.vslmReconcileDatastoreInventoryTask(fcdVslmHelper.getVStorageObjMgr(), managedObjectReference);
        Boolean bl = fcdVslmHelper.waitForTask(managedObjectReference2);
        if (!bl.booleanValue()) {
            String string = "Error: Reconciling datastore [ " + managedObjectReference + " ] from vslm.";
            throw new RuntimeException(string);
        }
        System.out.printf("Success: Reconciled datastore : [ %s ] from vslm", managedObjectReference);
    }

    @Action
    public void run() throws Exception {
        System.out.println("Invoking reconcile datastore inventory operations on VStorageObject from VSLM :: ::");
        this.reconcileDSInventoryOperation();
    }
}

