/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.fcd;

import com.vmware.common.annotations.Action;
import com.vmware.common.annotations.Option;
import com.vmware.common.annotations.Sample;
import com.vmware.connection.ConnectedVimServiceBase;
import com.vmware.fcd.helpers.FcdHelper;
import com.vmware.fcd.helpers.FcdVslmHelper;
import com.vmware.vim25.BaseConfigInfoBackingInfo;
import com.vmware.vim25.BaseConfigInfoDiskFileBackingInfo;
import com.vmware.vim25.BaseConfigInfoRawDiskMappingBackingInfo;
import com.vmware.vim25.ManagedObjectReference;
import com.vmware.vim25.VStorageObject;
import com.vmware.vslm.VslmPortType;

@Sample(name="fcd-renameextendinflatedeleteoperations", description="This sample renamnes an FCD,extends capacity of FCD, inflates a sparse or thin-provisioned FCD up to the full size and deletes FCD")
public class FcdRenameExtendInflateDeleteOperations
extends ConnectedVimServiceBase {
    private String vStorageObjectId;
    private String newVStorageObjectName;
    private long newCapacityInMB;

    @Option(name="vstorageobjectid", required=true, description="Uuid of the vstorageobject.")
    public void setVStorageObjectId(String string) {
        this.vStorageObjectId = string;
    }

    @Option(name="newvstorageobjectname", required=true, description="The new name for the virtual storage object.")
    public void setNewVStorageObjectName(String string) {
        this.newVStorageObjectName = string;
    }

    @Option(name="newcapacityinmb", required=true, description="The new capacity of the virtual disk in MB,which should be greater than the original disk size.")
    public void setNewCapacityInMB(long l) {
        this.newCapacityInMB = l;
    }

    void renameExtendInflateDeleteOperations() throws Exception {
        FcdVslmHelper fcdVslmHelper = new FcdVslmHelper(this.connection);
        VslmPortType vslmPortType = fcdVslmHelper.getVslmPort();
        System.out.println("Operation: Retrieve vStorageObject after revertVStorageObject and before renaming from datastore from vslm.");
        VStorageObject vStorageObject = vslmPortType.vslmRetrieveVStorageObject(fcdVslmHelper.getVStorageObjMgr(), FcdHelper.makeId((String)this.vStorageObjectId));
        if (vStorageObject == null) {
            String string = "Error: Retrieving VStorageObject [ " + FcdHelper.makeId((String)this.vStorageObjectId);
            throw new RuntimeException(string);
        }
        System.out.printf("Success: Retrieved vStorageObject :: %n [ UUid = %s ] %n [ name = %s ]%n ", vStorageObject.getConfig().getId().getId(), vStorageObject.getConfig().getName());
        System.out.println("Operation: Renaming the given vStorageObject from vslm.");
        vslmPortType.vslmRenameVStorageObject(fcdVslmHelper.getVStorageObjMgr(), FcdHelper.makeId((String)this.vStorageObjectId), this.newVStorageObjectName);
        System.out.println("Operation: Retrieve the vStorageObject after renaming from datastore from vslm.");
        VStorageObject vStorageObject2 = vslmPortType.vslmRetrieveVStorageObject(fcdVslmHelper.getVStorageObjMgr(), FcdHelper.makeId((String)this.vStorageObjectId));
        if (vStorageObject2 == null) {
            String string = "Error: Retrieving VStorageObject [ " + FcdHelper.makeId((String)this.vStorageObjectId);
            throw new RuntimeException(string);
        }
        System.out.printf("Success: Retrieved vStorageObject :: %n [ UUid = %s ]%n [ name = %s ] %n", vStorageObject2.getConfig().getId().getId(), vStorageObject2.getConfig().getName());
        if (!vStorageObject2.getConfig().getName().equals(this.newVStorageObjectName)) {
            String string = "Error: VStorageObject [ " + vStorageObject2.getConfig().getId().getId() + "] rename to [ " + this.newVStorageObjectName + " ] from vslm";
            throw new RuntimeException(string);
        }
        System.out.printf("Success: Renamed vStorageObject :: [ %s ] from vslm", vStorageObject2.getConfig().getId().getId());
        System.out.println("Operation: Extending capacity of vStorageObject from vslm.");
        ManagedObjectReference managedObjectReference = vslmPortType.vslmExtendDiskTask(fcdVslmHelper.getVStorageObjMgr(), FcdHelper.makeId((String)this.vStorageObjectId), this.newCapacityInMB);
        Boolean bl = fcdVslmHelper.waitForTask(managedObjectReference);
        if (!bl.booleanValue()) {
            String string = "Error: Extending vStorageObject [ " + FcdHelper.makeId((String)this.vStorageObjectId) + "] from vslm.";
            throw new RuntimeException(string);
        }
        System.out.printf("Success: Extended vStorageObject : %n [ Uuid = %s ]%n [ NewCapacity = %s ]%n", this.vStorageObjectId, this.newCapacityInMB);
        System.out.println("Operation: Retrieve the extendedVStorageObject from datastore from vslm.");
        VStorageObject vStorageObject3 = vslmPortType.vslmRetrieveVStorageObject(fcdVslmHelper.getVStorageObjMgr(), FcdHelper.makeId((String)this.vStorageObjectId));
        if (vStorageObject3 == null) {
            String string = "Error: Retrieving VStorageObject [ " + this.vStorageObjectId + " ] from vslm.";
            throw new RuntimeException(string);
        }
        System.out.printf("Success: Retrieved vStorageObject :: [ %s ] from vslm.%n", vStorageObject3.getConfig().getId().getId());
        if (vStorageObject3.getConfig().getCapacityInMB() != this.newCapacityInMB) {
            String string = "Error: VStorageObject [ " + this.vStorageObjectId + " ] capcity extend failed from vslm.";
            throw new RuntimeException(string);
        }
        System.out.println("Success: Extend vStorageObject capacity  :: [ " + vStorageObject3.getConfig().getId().getId() + " ] from vslm.");
        VStorageObject vStorageObject4 = vslmPortType.vslmRetrieveVStorageObject(fcdVslmHelper.getVStorageObjMgr(), FcdHelper.makeId((String)this.vStorageObjectId));
        if (vStorageObject4 == null) {
            String string = "Error: Retrieving VStorageObject [ " + this.vStorageObjectId + " ] before inflate";
            throw new RuntimeException(string);
        }
        System.out.printf("Success: Retrieved vStorageObject before inflate :: %n [ %s ]%n from vslm.%n", this.vStorageObjectId);
        System.out.println("Operation: Inflate a sparse or thin-provisioned virtual disk up to the full size from vslm.");
        ManagedObjectReference managedObjectReference2 = vslmPortType.vslmInflateDiskTask(fcdVslmHelper.getVStorageObjMgr(), FcdHelper.makeId((String)this.vStorageObjectId));
        Boolean bl2 = fcdVslmHelper.waitForTask(managedObjectReference2);
        if (!bl2.booleanValue()) {
            String string = "Error: Inflating vStorageObject [ " + this.vStorageObjectId + " ] from vslm.";
            throw new RuntimeException(string);
        }
        System.out.printf("Success: Inflated vStorageObject : [ Uuid = %s ] from vslm.%n", this.vStorageObjectId);
        VStorageObject vStorageObject5 = vslmPortType.vslmRetrieveVStorageObject(fcdVslmHelper.getVStorageObjMgr(), FcdHelper.makeId((String)this.vStorageObjectId));
        if (vStorageObject5 == null) {
            String string = "Error: Retrieving VStorageObject [ " + this.vStorageObjectId + " ] after inflate from vslm.";
            throw new RuntimeException(string);
        }
        System.out.printf("Success: Retrieved vStorageObject after inflate :: [ %s ] from vslm.%n", this.vStorageObjectId);
        String string = this.getProvisioningType(vStorageObject4);
        String string2 = this.getProvisioningType(vStorageObject5);
        System.out.printf("Provisioning type before inflate is : [ %s ] %n", string);
        System.out.printf("Provisioning type after inflate is : [ %s ] %n", string2);
        String string3 = FcdHelper.getFcdFilePath((VStorageObject)vStorageObject4);
        if (string3 == null) {
            String string4 = "Error: File backing doesn't present for source vStorageObject [ " + this.vStorageObjectId + " ]";
            throw new RuntimeException(string4);
        }
        String string5 = FcdHelper.getFcdFilePath((VStorageObject)vStorageObject5);
        if (string5 == null) {
            String string6 = "Error: File backing doesn't present for vStorageObject [ " + this.vStorageObjectId + " ] after inflate";
            throw new RuntimeException(string6);
        }
        if (!string5.equals(string3)) {
            String string7 = "Error: File path changed for vStorageObject [ " + this.vStorageObjectId + " ] after inflate";
            throw new RuntimeException(string7);
        }
        System.out.println("File Path before and after inflate is same.");
        long l = vStorageObject4.getConfig().getCapacityInMB();
        long l2 = vStorageObject5.getConfig().getCapacityInMB();
        if (l != l2) {
            String string8 = "Error: Disk size changed for vStorageObject [ " + this.vStorageObjectId + " ] after inflate";
            throw new RuntimeException(string8);
        }
        System.out.println("Disk size before and after inflate is same.");
        System.out.println("Operation: Deleting a vStorageObject");
        ManagedObjectReference managedObjectReference3 = vslmPortType.vslmDeleteVStorageObjectTask(fcdVslmHelper.getVStorageObjMgr(), FcdHelper.makeId((String)this.vStorageObjectId));
        Boolean bl3 = fcdVslmHelper.waitForTask(managedObjectReference3);
        if (!bl3.booleanValue()) {
            String string9 = "Error: Deleting [ " + this.vStorageObjectId + "] vStorageObject";
            throw new RuntimeException(string9);
        }
        System.out.println("Delete disk task is succeded");
        System.out.printf("Success: Deleted vStorageObject :  %n [ Uuid = %s ]%n", this.vStorageObjectId);
    }

    private String getProvisioningType(VStorageObject vStorageObject) {
        String string = null;
        BaseConfigInfoBackingInfo baseConfigInfoBackingInfo = vStorageObject.getConfig().getBacking();
        if (baseConfigInfoBackingInfo instanceof BaseConfigInfoDiskFileBackingInfo) {
            BaseConfigInfoDiskFileBackingInfo baseConfigInfoDiskFileBackingInfo = (BaseConfigInfoDiskFileBackingInfo)baseConfigInfoBackingInfo;
            string = baseConfigInfoDiskFileBackingInfo.getProvisioningType().toString();
        } else if (baseConfigInfoBackingInfo instanceof BaseConfigInfoRawDiskMappingBackingInfo) {
            BaseConfigInfoRawDiskMappingBackingInfo baseConfigInfoRawDiskMappingBackingInfo = (BaseConfigInfoRawDiskMappingBackingInfo)baseConfigInfoBackingInfo;
            string = baseConfigInfoRawDiskMappingBackingInfo.getCompatibilityMode();
        }
        return string;
    }

    @Action
    public void run() throws Exception {
        System.out.println("Invoking rename, extend, inflate and delete operations on VStorageObject from VSLM :: ::");
        this.renameExtendInflateDeleteOperations();
    }
}

