/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.fcd;

import com.vmware.common.annotations.Action;
import com.vmware.common.annotations.Option;
import com.vmware.common.annotations.Sample;
import com.vmware.connection.ConnectedVimServiceBase;
import com.vmware.fcd.helpers.FcdHelper;
import com.vmware.fcd.helpers.FcdVslmHelper;
import com.vmware.vim25.VStorageObject;
import com.vmware.vim25.VStorageObjectStateInfo;
import com.vmware.vslm.VslmPortType;
import com.vmware.vslm.VslmVsoVStorageObjectQueryResult;
import com.vmware.vslm.VslmVsoVStorageObjectQuerySpec;
import com.vmware.vslm.VslmVsoVStorageObjectResult;
import java.util.Arrays;
import java.util.List;

@Sample(name="fcd-retrieveoperations", description="This sample retrieves a virtual storage object,  retrieves virtual storage object state and lists all virtual storage object from vslm.")
public class FcdRetrieveOperations
extends ConnectedVimServiceBase {
    private String vStorageObjectId;
    private String maxResult;
    private String queryField;
    private String queryOperator;
    private String queryValue;

    @Option(name="vstorageobjectid", required=true, description="Uuid of the vstorageobject.")
    public void setVStorageObjectId(String string) {
        this.vStorageObjectId = string;
    }

    @Option(name="maxresult", required=true, description="Maximum number of virtual storage object IDs to return.")
    public void setMaxResult(String string) {
        this.maxResult = string;
    }

    @Option(name="queryfield", required=true, description="This indicates the searchable field.")
    public void setQueryField(String string) {
        this.queryField = string;
    }

    @Option(name="queryoperator", required=true, description="This field specifies the operator to compare the searchable field.")
    public void setQueryOperator(String string) {
        this.queryOperator = string;
    }

    @Option(name="queryvalue", required=true, description="This field specifies the operator to compare the searchable field.")
    public void setQueryValue(String string) {
        this.queryValue = string;
    }

    void retrieveOperations() throws Exception {
        FcdVslmHelper fcdVslmHelper = new FcdVslmHelper(this.connection);
        VslmPortType vslmPortType = fcdVslmHelper.getVslmPort();
        System.out.println("Operation: Retrieve the vStorageObject from vslm");
        VStorageObject vStorageObject = vslmPortType.vslmRetrieveVStorageObject(fcdVslmHelper.getVStorageObjMgr(), FcdHelper.makeId((String)this.vStorageObjectId));
        if (vStorageObject == null) {
            String string = "Error: Retrieving VStorageObject [ " + this.vStorageObjectId + " ] from vslm.";
            throw new RuntimeException(string);
        }
        System.out.printf("Success: Retrieved vStorageObject :: %n [ UUid = %s ]%n vStorageObjectName %n [ Name = %s ]%n CapacityInMB %n [ Capacity = %s ]%n", vStorageObject.getConfig().getId().getId(), vStorageObject.getConfig().getName(), vStorageObject.getConfig().getCapacityInMB());
        System.out.println("Operation: Retrieve the vStorageObjects from vslm");
        List list = vslmPortType.vslmRetrieveVStorageObjects(fcdVslmHelper.getVStorageObjMgr(), Arrays.asList(FcdHelper.makeId((String)this.vStorageObjectId)));
        if (list == null) {
            String string = "Error: Retrieving VStorageObjects [ " + this.vStorageObjectId + " ] from vslm.";
            throw new RuntimeException(string);
        }
        System.out.printf("Success: Retrieved vStorageObjects :: %n [ UUid = %s ]%n vStorageObjectName %n [ Name = %s ]%n CapacityInMB %n [ Capacity = %s ]%n", ((VslmVsoVStorageObjectResult)list.get(0)).getId().getId(), ((VslmVsoVStorageObjectResult)list.get(0)).getName(), ((VslmVsoVStorageObjectResult)list.get(0)).getCapacityInMB());
        System.out.println("Operation: Retrieve the vStorageObject state from datastore from vslm.");
        VStorageObjectStateInfo vStorageObjectStateInfo = vslmPortType.vslmRetrieveVStorageObjectState(fcdVslmHelper.getVStorageObjMgr(), FcdHelper.makeId((String)this.vStorageObjectId));
        if (vStorageObjectStateInfo == null) {
            String string = "Error: Retrieving state info for VStorageObject [ " + this.vStorageObjectId + " ] from vslm.";
            throw new RuntimeException(string);
        }
        System.out.printf("Success: Retrieved state info [stateInfo = %s ] of vStorageObject :: [ %s ] from vslm.", vStorageObjectStateInfo.isTentative(), this.vStorageObjectId);
        System.out.println("Operation: lists all virtual storage object from vslm.");
        VslmVsoVStorageObjectQuerySpec vslmVsoVStorageObjectQuerySpec = new VslmVsoVStorageObjectQuerySpec();
        vslmVsoVStorageObjectQuerySpec.setQueryField(this.queryField);
        vslmVsoVStorageObjectQuerySpec.setQueryOperator(this.queryOperator);
        vslmVsoVStorageObjectQuerySpec.getQueryValue().add(this.queryValue);
        VslmVsoVStorageObjectQueryResult vslmVsoVStorageObjectQueryResult = null;
        vslmVsoVStorageObjectQueryResult = this.queryField != null && this.queryOperator != null && this.queryValue != null ? vslmPortType.vslmListVStorageObjectForSpec(fcdVslmHelper.getVStorageObjMgr(), Arrays.asList(vslmVsoVStorageObjectQuerySpec), Integer.parseInt(this.maxResult)) : vslmPortType.vslmListVStorageObjectForSpec(fcdVslmHelper.getVStorageObjMgr(), null, Integer.parseInt(this.maxResult));
        if (vslmVsoVStorageObjectQueryResult == null) {
            String string = "Error: List virtual storage objects : ";
            throw new RuntimeException(string);
        }
        System.out.println("Success:  List virtual storage objects :");
        System.out.println("List all vstorage objects IDs : ");
        for (VslmVsoVStorageObjectResult vslmVsoVStorageObjectResult : vslmVsoVStorageObjectQueryResult.getQueryResults()) {
            System.out.println("vstorage object id :" + vslmVsoVStorageObjectResult.getId().getId());
        }
    }

    @Action
    public void run() throws Exception {
        System.out.println("Invoking retrieve operations on virtual storage object from VSLM ::");
        this.retrieveOperations();
    }
}

