/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.fcd;

import com.vmware.common.annotations.Action;
import com.vmware.common.annotations.Option;
import com.vmware.common.annotations.Sample;
import com.vmware.connection.ConnectedVimServiceBase;
import com.vmware.fcd.helpers.FcdHelper;
import com.vmware.fcd.helpers.FcdVslmHelper;
import com.vmware.vim25.DiskChangeInfo;
import com.vmware.vim25.ID;
import com.vmware.vim25.ManagedObjectReference;
import com.vmware.vim25.VStorageObject;
import com.vmware.vim25.VStorageObjectSnapshotDetails;
import com.vmware.vim25.VStorageObjectSnapshotInfo;
import com.vmware.vim25.VStorageObjectSnapshotInfoVStorageObjectSnapshot;
import com.vmware.vslm.VslmPortType;
import com.vmware.vslm.VslmTaskInfo;
import java.util.ArrayList;
import java.util.List;

@Sample(name="fcd-snapshotoperations", description="This sample executes snapshot related operation on a snapshot of a given VStorageObject.")
public class FcdSnapshotOperations
extends ConnectedVimServiceBase {
    private String vStorageObjectId;
    private String description;
    private String fcdName;
    private String pbmProfileId = null;
    private String deviceGroupId = null;
    private String faultDomainId = null;
    private String datastorePath = null;
    private String controlFlag = "enableChangedBlockTracking";

    @Option(name="vstorageobjectid", required=true, description="Uuid of the vstorageobject.")
    public void setVStorageObjectId(String string) {
        this.vStorageObjectId = string;
    }

    @Option(name="description", required=true, description="A short description to be associated with the snapshot.")
    public void setDescription(String string) {
        this.description = string;
    }

    @Option(name="fcdname", required=true, description="A user friendly name to beassociated with the new disk.")
    public void setVStorageObjectName(String string) {
        this.fcdName = string;
    }

    @Option(name="pbmprofileid", required=false, description="SPBM Profile requirement on thenew virtual storage object.")
    public void setProfileSpec(String string) {
        this.pbmProfileId = string;
    }

    @Option(name="devicegroupid", required=false, description="Id of the replication device group.")
    public void setDeviceGroupId(String string) {
        this.deviceGroupId = string;
    }

    @Option(name="faultdomainid", required=false, description="ID of the fault domain to which the group belongs.")
    public void setFaultDomainId(String string) {
        this.faultDomainId = string;
    }

    @Option(name="datastorepath", required=false, description="Relative location in the specified datastorewhere disk needs to be created.")
    public void setDatastorePath(String string) {
        this.datastorePath = string;
    }

    void snapshotOperations() throws Exception {
        Object object;
        String string;
        FcdVslmHelper fcdVslmHelper = new FcdVslmHelper(this.connection);
        VslmPortType vslmPortType = fcdVslmHelper.getVslmPort();
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(this.controlFlag);
        vslmPortType.vslmSetVStorageObjectControlFlags(fcdVslmHelper.getVStorageObjMgr(), FcdHelper.makeId((String)this.vStorageObjectId), arrayList);
        VStorageObject vStorageObject = vslmPortType.vslmRetrieveVStorageObject(fcdVslmHelper.getVStorageObjMgr(), FcdHelper.makeId((String)this.vStorageObjectId));
        System.out.println("Operation: Creating snapshot of given vStorageObject from vslm.");
        ManagedObjectReference managedObjectReference = vslmPortType.vslmCreateSnapshotTask(fcdVslmHelper.getVStorageObjMgr(), FcdHelper.makeId((String)this.vStorageObjectId), this.description);
        ID iD = null;
        Boolean bl = fcdVslmHelper.waitForTask(managedObjectReference);
        if (!bl.booleanValue()) {
            String string2 = "Error: Creating vStorageObject [ " + this.vStorageObjectId + "] snapshot from vslm.";
            throw new RuntimeException(string2);
        }
        System.out.println("snapshot disk task is succeded");
        VslmTaskInfo vslmTaskInfo = vslmPortType.vslmQueryInfo(managedObjectReference);
        iD = (ID)vslmTaskInfo.getResult();
        System.out.printf("Success: Created snapshot : [ Id = %s ] of vStorageObject : [ UUID = %s ] from vslm.", iD.getId(), this.vStorageObjectId);
        System.out.println("Operation: Retrieve VStorageObject snapshot info from vslm.");
        vslmTaskInfo = vslmPortType.vslmRetrieveSnapshotInfo(fcdVslmHelper.getVStorageObjMgr(), FcdHelper.makeId((String)this.vStorageObjectId));
        if (vslmTaskInfo.getSnapshots().size() <= 0 || !FcdSnapshotOperations.isSnapshotIdInSnapshotList((VStorageObjectSnapshotInfo)vslmTaskInfo, iD)) {
            String string3 = "Error: Retrieving VStorageObject Snapshot [ " + iD.getId() + " ] from vslm.";
            throw new RuntimeException(string3);
        }
        System.out.printf("Success: Retrieved vStorageObject Snapshot :: [ %s ] from vslm.", iD.getId());
        System.out.println("Operation: Retrieve VStorageObject snapshot details from vslm.");
        VStorageObjectSnapshotDetails vStorageObjectSnapshotDetails = vslmPortType.vslmRetrieveSnapshotDetails(fcdVslmHelper.getVStorageObjMgr(), FcdHelper.makeId((String)this.vStorageObjectId), iD);
        if (vStorageObjectSnapshotDetails != null) {
            string = FcdHelper.getFcdFilePath((VStorageObject)vStorageObject);
            if (string.equals(object = vStorageObjectSnapshotDetails.getPath())) {
                System.out.printf("Success: Retrieved vStorageObject Snapshot details of snapshot id :: [ %s ], snapshot path :: [ %s ] from vslm.", iD.getId(), object);
            } else {
                System.out.printf("Error: Retrieved vStorageObject Snapshot details of snapshot id :: [ %s ], actual snapshot path :: [ %s ] doesn't match with expected snapshot path :: [ %s ] from vslm.", iD.getId(), object, string);
            }
        } else {
            String string4 = "Error: Retrieving VStorageObject Snapshot Details [ " + iD.getId() + " ] from vslm.";
            throw new RuntimeException(string4);
        }
        System.out.println("Operation: query disk changed areas from vslm.");
        string = vStorageObjectSnapshotDetails.getChangedBlockTrackingId();
        object = 0L;
        System.out.println("Retrieved change id :" + string);
        DiskChangeInfo diskChangeInfo = vslmPortType.vslmQueryChangedDiskAreas(fcdVslmHelper.getVStorageObjMgr(), FcdHelper.makeId((String)this.vStorageObjectId), iD, ((Long)object).longValue(), string);
        if (diskChangeInfo == null) {
            String string5 = "Error: Query disk change area of vStorageObject [ " + FcdHelper.makeId((String)this.vStorageObjectId) + "] from vslm.";
            throw new RuntimeException(string5);
        }
        System.out.printf("Success: Query disk change area of vStorageObject :: vStorageObjectId %n [ %s ]%n", this.vStorageObjectId);
        List list = null;
        if (this.pbmProfileId != null) {
            list = FcdHelper.generateVirtualMachineProfileSpec((String)this.pbmProfileId, (String)this.deviceGroupId, (String)this.faultDomainId);
        }
        System.out.println("Operation: Creating snapshot of given vStorageObject from vslm.");
        ManagedObjectReference managedObjectReference2 = vslmPortType.vslmCreateDiskFromSnapshotTask(fcdVslmHelper.getVStorageObjMgr(), FcdHelper.makeId((String)this.vStorageObjectId), iD, this.fcdName, list, null, this.datastorePath);
        VStorageObject vStorageObject2 = null;
        Boolean bl2 = fcdVslmHelper.waitForTask(managedObjectReference2);
        if (!bl2.booleanValue()) {
            String string6 = "Error: Creating vStorageObject from snapshot : [ " + iD.getId() + "] of vStorageObject : [ " + this.vStorageObjectId + " ] from vslm.";
            throw new RuntimeException(string6);
        }
        VslmTaskInfo vslmTaskInfo2 = vslmPortType.vslmQueryInfo(managedObjectReference2);
        vStorageObject2 = (VStorageObject)vslmTaskInfo2.getResult();
        System.out.printf("Success: Created vStorageObject from snapshot : %n [ SnapshotId = %s ] of vstorageObject : %n [ UUid = %s ]  with name :  %n [ fcd name = %s ]  %n [ Uuid = %s ] %n from vslm.", iD, this.vStorageObjectId, vStorageObject2.getConfig().getName(), vStorageObject2.getConfig().getId().getId());
        System.out.println("Operation: Retrieve the vStorageObject created from snapshot in datastore from vslm.");
        vslmTaskInfo2 = vslmPortType.vslmRetrieveVStorageObject(fcdVslmHelper.getVStorageObjMgr(), vStorageObject2.getConfig().getId());
        if (!vslmTaskInfo2.getConfig().getId().getId().equals(vStorageObject2.getConfig().getId().getId())) {
            String string7 = "Error: Created VStorageObject [ " + vStorageObject2.getConfig().getId().getId() + "] and retrieved VStorageObject are different from vslm";
            throw new RuntimeException(string7);
        }
        System.out.printf("Success: Retrieved vStorageObject :: %n [ %s ]%n from vslm.", vslmTaskInfo2.getConfig().getId().getId());
        System.out.println("Operation: Reverting to a given snapshot of a VStorageObject from vslm.");
        ManagedObjectReference managedObjectReference3 = vslmPortType.vslmRevertVStorageObjectTask(fcdVslmHelper.getVStorageObjMgr(), FcdHelper.makeId((String)this.vStorageObjectId), iD);
        Boolean bl3 = fcdVslmHelper.waitForTask(managedObjectReference3);
        if (!bl3.booleanValue()) {
            String string8 = "Error: Reverting vStorageObject [ " + this.vStorageObjectId + "] to snapshot [ " + iD.getId() + " ] from vslm.";
            throw new RuntimeException(string8);
        }
        System.out.printf("Success: Reverted vStorageObject : [ UUID = %s ] to snapshot :  [ SnapshotId = %s ] from vslm.%n", this.vStorageObjectId, iD.getId());
        System.out.println("Operation: Deleting snapshot of given vStorageObject from vslm.");
        ManagedObjectReference managedObjectReference4 = vslmPortType.vslmDeleteSnapshotTask(fcdVslmHelper.getVStorageObjMgr(), FcdHelper.makeId((String)this.vStorageObjectId), iD);
        Boolean bl4 = fcdVslmHelper.waitForTask(managedObjectReference4);
        if (!bl4.booleanValue()) {
            String string9 = "Error: Deleting [ " + this.vStorageObjectId + "] vStorageObject snapshot [ " + iD.getId() + " ] from vslm.%n";
            throw new RuntimeException(string9);
        }
        System.out.printf("Success: Deleted snapshot : [ SnapshotId = %s ] of vStorageObject :  [ UUID = %s ] from vslm.", iD.getId(), this.vStorageObjectId);
        System.out.println("Operation: Retrieve VStorageObject snapshot from vslm.");
        VStorageObjectSnapshotInfo vStorageObjectSnapshotInfo = vslmPortType.vslmRetrieveSnapshotInfo(fcdVslmHelper.getVStorageObjMgr(), FcdHelper.makeId((String)this.vStorageObjectId));
        if (FcdSnapshotOperations.isSnapshotIdInSnapshotList(vStorageObjectSnapshotInfo, iD)) {
            String string10 = "Error: Deleted vStorageObject Snapshot [ " + iD.getId() + " ] is included inretrieved snapshot list from vslm.";
            throw new RuntimeException(string10);
        }
        System.out.printf("Success: Deleted vStorageObject Snapshot :: [ %s ] is not included in retrieved snapshot list from vslm.", iD.getId());
    }

    public static boolean isSnapshotIdInSnapshotList(VStorageObjectSnapshotInfo vStorageObjectSnapshotInfo, ID iD) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (VStorageObjectSnapshotInfoVStorageObjectSnapshot vStorageObjectSnapshotInfoVStorageObjectSnapshot : vStorageObjectSnapshotInfo.getSnapshots()) {
            arrayList.add(vStorageObjectSnapshotInfoVStorageObjectSnapshot.getId().getId());
        }
        return arrayList.contains(iD.getId());
    }

    @Action
    public void run() throws Exception {
        System.out.println("Invoking Snapshot related APIs from VSLM ::");
        this.snapshotOperations();
    }
}

