/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.fcd;

import com.vmware.common.annotations.Action;
import com.vmware.common.annotations.Option;
import com.vmware.common.annotations.Sample;
import com.vmware.connection.ConnectedVimServiceBase;
import com.vmware.fcd.helpers.FcdHelper;
import com.vmware.fcd.helpers.FcdVslmHelper;
import com.vmware.vim25.VslmTagEntry;
import com.vmware.vslm.VslmPortType;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

@Sample(name="fcd-tagoperations", description="This sample attaches tag to FCD, lists tags attached to FCD, list FCDs attached to tag and detaches tags from FCD .")
public class FcdTagOperations
extends ConnectedVimServiceBase {
    private String vStorageObjectId;
    private String category;
    private String tag;

    @Option(name="vStorageObjectId", required=true, description="The ID of the virtual storage object.")
    public void setVStorageObjectId(String string) {
        this.vStorageObjectId = string;
    }

    @Option(name="category", required=true, description="The category to which the tag belongs.")
    public void setCategory(String string) {
        this.category = string;
    }

    @Option(name="tag", required=true, description="The tag to be queried.")
    public void setTag(String string) {
        this.tag = string;
    }

    void taggingOperations() throws Exception {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object52;
        FcdVslmHelper fcdVslmHelper = new FcdVslmHelper(this.connection);
        VslmPortType vslmPortType = fcdVslmHelper.getVslmPort();
        System.out.println("Operation: Attach a tag to a virtual storage object from vslm.");
        vslmPortType.vslmAttachTagToVStorageObject(fcdVslmHelper.getVStorageObjMgr(), FcdHelper.makeId((String)this.vStorageObjectId), this.category, this.tag);
        System.out.println("Operation: List all vStorageObjects attached to a tag from vslm.");
        List list = vslmPortType.vslmListVStorageObjectsAttachedToTag(fcdVslmHelper.getVStorageObjMgr(), this.category, this.tag);
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Object object52 : list) {
            arrayList.add(object52.getId());
        }
        if (list.isEmpty() || !arrayList.contains(this.vStorageObjectId)) {
            object4 = "Error: VStorageObject [ " + this.vStorageObjectId + " ] is not present in the list returned by listVStorageObjectsAttachedToTag for category " + this.category + " and tag " + this.tag + " from vslm.";
            throw new RuntimeException((String)object4);
        }
        System.out.printf("vStorageObject list returned by listVStorageObjectsAttachedToTag contains vstorageObject :: [ %s ] from vslm.%n", list.size(), this.vStorageObjectId);
        System.out.println("Operation: List all tags attached to a vStorageObject from vslm.");
        object4 = vslmPortType.vslmListTagsAttachedToVStorageObject(fcdVslmHelper.getVStorageObjMgr(), FcdHelper.makeId((String)this.vStorageObjectId));
        if (!object4.isEmpty()) {
            object52 = new ArrayList();
            object3 = new ArrayList<String>();
            object2 = object4.iterator();
            while (object2.hasNext()) {
                object = (VslmTagEntry)object2.next();
                object52.add(object.getParentCategoryName());
                object3.add(object.getTagName());
            }
            if (object52.contains(this.category) && object3.contains(this.tag)) {
                System.out.printf("Tag list of size [ %s ] returned by listTagsAttachedToVStorageObject for vstorageObject :: [ %s ] contains category :: [ %s ] and tag :: [ %s ]%n", list.size(), this.vStorageObjectId, this.category, this.tag);
            }
        } else {
            object52 = "Error: Category [ " + this.category + " ] and tag [ " + this.tag + " ] is not present in the list returned by listTagsAttachedToVStorageObject for vStorageObject [ " + this.vStorageObjectId + " ] from vslm.";
            throw new RuntimeException((String)object52);
        }
        System.out.println("Operation: Detach a tag from a virtual storage object.");
        vslmPortType.vslmDetachTagFromVStorageObject(fcdVslmHelper.getVStorageObjMgr(), FcdHelper.makeId((String)this.vStorageObjectId), this.category, this.tag);
        System.out.println("Operation: List all vStorageObject attached to tag from vslm.");
        object52 = vslmPortType.vslmListVStorageObjectsAttachedToTag(fcdVslmHelper.getVStorageObjMgr(), this.category, this.tag);
        if (object52.contains(FcdHelper.makeId((String)this.vStorageObjectId))) {
            object3 = "Error: VStorageObject [ " + this.vStorageObjectId + " ] is still present in the list returned by listVStorageObjectsAttachedToTag for category " + this.category + " and tag " + this.tag + " from vslm.";
            throw new RuntimeException((String)object3);
        }
        System.out.printf("vStorageObject list returned by listVStorageObjectsAttachedToTag  doesn't contain vstorageObject :: [ %s ].%n", this.vStorageObjectId);
        System.out.println("Operation: List all tags attached to vStorageObject from vslm.");
        object3 = vslmPortType.vslmListTagsAttachedToVStorageObject(fcdVslmHelper.getVStorageObjMgr(), FcdHelper.makeId((String)this.vStorageObjectId));
        object2 = new ArrayList();
        object = new ArrayList();
        if (!object3.isEmpty()) {
            Iterator iterator = object3.iterator();
            while (iterator.hasNext()) {
                VslmTagEntry vslmTagEntry = (VslmTagEntry)iterator.next();
                object2.add(vslmTagEntry.getParentCategoryName());
                object.add(vslmTagEntry.getTagName());
            }
        }
        if (object3.isEmpty() || !object2.contains(this.category) || !object.contains(this.tag)) {
            System.out.printf("Tag list returned by listTagsAttachedToVStorageObject for vstorageObject :: [ %s ] doesn't contain category :: [ %s ] and tag :: [ %s ].%n", this.vStorageObjectId, this.category, this.tag);
        }
    }

    @Action
    public void run() throws Exception {
        System.out.println("Invoking Tagging related APIs from VSLM ::");
        this.taggingOperations();
    }
}

