/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.fcd;

import com.vmware.common.annotations.Action;
import com.vmware.common.annotations.Option;
import com.vmware.common.annotations.Sample;
import com.vmware.connection.ConnectedVimServiceBase;
import com.vmware.fcd.helpers.FcdHelper;
import com.vmware.fcd.helpers.FcdVslmHelper;
import com.vmware.vim25.ManagedObjectReference;
import com.vmware.vim25.VslmInfrastructureObjectPolicy;
import com.vmware.vim25.VslmInfrastructureObjectPolicySpec;
import com.vmware.vslm.VslmPortType;
import java.util.List;

@Sample(name="fcd-updateandretrieveinfrastructurepolicyoperations", description="This sample updates vStorageObject policy, updates and retrieves virtual storage infrastructure object SBPM policy on given datastore.")
public class FcdUpdateAndRetrieveInfrastructurePolicyOperations
extends ConnectedVimServiceBase {
    private String vStorageObjectId;
    private String pbmProfileId;
    private String datastoreName;
    private String deviceGroupId = null;
    private String faultDomainId = null;

    @Option(name="vstorageobjectid", required=true, description="Uuid of the vstorageobject.")
    public void setVStorageObjectId(String string) {
        this.vStorageObjectId = string;
    }

    @Option(name="pbmprofileid", required=true, description="SPBM Profile requirement on the new virtual storage object.")
    public void setProfileSpec(String string) {
        this.pbmProfileId = string;
    }

    @Option(name="datastorename", required=true, description="Name of datastore on which datastore policy needs to be assigned.It only supports VSAN datastore.")
    public void setDatastoreName(String string) {
        this.datastoreName = string;
    }

    @Option(name="devicegroupid", required=false, description="Id of the replication device group.")
    public void setDeviceGroupId(String string) {
        this.deviceGroupId = string;
    }

    @Option(name="faultdomainid", required=false, description="ID of the fault domain to which the group belongs.")
    public void setFaultDomainId(String string) {
        this.faultDomainId = string;
    }

    void infraObjectPolicyOperations() throws Exception {
        FcdVslmHelper fcdVslmHelper = new FcdVslmHelper(this.connection);
        VslmPortType vslmPortType = fcdVslmHelper.getVslmPort();
        List list = null;
        if (this.pbmProfileId != null) {
            list = FcdHelper.generateVirtualMachineProfileSpec((String)this.pbmProfileId, (String)this.deviceGroupId, (String)this.faultDomainId);
        }
        System.out.println("Operation: Updating virtual storage object policy from vslm : ");
        ManagedObjectReference managedObjectReference = vslmPortType.vslmUpdateVstorageObjectPolicyTask(fcdVslmHelper.getVStorageObjMgr(), FcdHelper.makeId((String)this.vStorageObjectId), list);
        Boolean bl = fcdVslmHelper.waitForTask(managedObjectReference);
        if (bl.booleanValue()) {
            System.out.printf("Success : Vstorage object : [ Name = %s ] updated with profile : [ ProfileId = %s ].%n", this.vStorageObjectId, this.pbmProfileId);
        } else {
            System.out.printf("Error : Failed to update Vstorage object : [ Name = %s ] with profile : [ ProfileId = %s ].%n", this.vStorageObjectId, this.pbmProfileId);
        }
        System.out.println("Operation: Updating virtual storage infrastructure object SBPM policy on given from vslm.");
        ManagedObjectReference managedObjectReference2 = (ManagedObjectReference)this.getMOREFs.inContainerByType(this.serviceContent.getRootFolder(), "Datastore").get(this.datastoreName);
        VslmInfrastructureObjectPolicySpec vslmInfrastructureObjectPolicySpec = new VslmInfrastructureObjectPolicySpec();
        vslmInfrastructureObjectPolicySpec.setDatastore(managedObjectReference2);
        vslmInfrastructureObjectPolicySpec.getProfile().addAll(list);
        vslmPortType.vslmUpdateVStorageInfrastructureObjectPolicyTask(fcdVslmHelper.getVStorageObjMgr(), vslmInfrastructureObjectPolicySpec);
        System.out.printf("Success: Updated infrastructure policy for datastore : [ datastore = %s ] from vslm.%n", managedObjectReference2.getValue());
        System.out.println("Operation: Retrieving virtual storage infrastructure object SBPM policy on given from vslm.");
        List list2 = vslmPortType.vslmRetrieveVStorageInfrastructureObjectPolicy(fcdVslmHelper.getVStorageObjMgr(), managedObjectReference2);
        System.out.printf("Success: Retrieved infrastructure policy for datastore : [ datastore = %s ] from vslm.%n", managedObjectReference2.getValue());
        for (VslmInfrastructureObjectPolicy vslmInfrastructureObjectPolicy : list2) {
            System.out.printf("Infrastructure object : [ Name = %s ] associated with profile : [ ProfileId = %s ].%n", vslmInfrastructureObjectPolicy.getName(), vslmInfrastructureObjectPolicy.getProfileId());
        }
    }

    @Action
    public void run() throws Exception {
        System.out.println("Invoking infrastructure object SBPM policy related APIs from VSLM ::");
        this.infraObjectPolicyOperations();
    }
}

