/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.fcd.helpers;

import com.vmware.vim25.BaseConfigInfoBackingInfo;
import com.vmware.vim25.BaseConfigInfoDiskFileBackingInfoProvisioningType;
import com.vmware.vim25.BaseConfigInfoFileBackingInfo;
import com.vmware.vim25.ID;
import com.vmware.vim25.ManagedObjectReference;
import com.vmware.vim25.VStorageObject;
import com.vmware.vim25.VirtualDiskCompatibilityMode;
import com.vmware.vim25.VslmCreateSpec;
import com.vmware.vim25.VslmCreateSpecBackingSpec;
import com.vmware.vim25.VslmCreateSpecDiskFileBackingSpec;
import com.vmware.vim25.VslmCreateSpecRawDiskMappingBackingSpec;
import java.util.ArrayList;
import java.util.List;

public class FcdUtil {
    public static VslmCreateSpec generateVslmCreateSpec(ManagedObjectReference managedObjectReference, DiskProvisioningTypes diskProvisioningTypes, String string, String string2, long l) throws IllegalArgumentException {
        VslmCreateSpecDiskFileBackingSpec vslmCreateSpecDiskFileBackingSpec;
        VslmCreateSpecDiskFileBackingSpec vslmCreateSpecDiskFileBackingSpec2;
        System.out.println("Info :: Creating VslmCreateSpec with dsMor: " + managedObjectReference.getValue() + " provisioningType:" + diskProvisioningTypes.toString());
        if (diskProvisioningTypes != DiskProvisioningTypes.VIRTUAL_MODE && diskProvisioningTypes != DiskProvisioningTypes.PHYSICAL_MODE) {
            vslmCreateSpecDiskFileBackingSpec2 = new VslmCreateSpecDiskFileBackingSpec();
            vslmCreateSpecDiskFileBackingSpec2.setDatastore(managedObjectReference);
            vslmCreateSpecDiskFileBackingSpec2.setProvisioningType(BaseConfigInfoDiskFileBackingInfoProvisioningType.valueOf((String)diskProvisioningTypes.toString()).value());
            vslmCreateSpecDiskFileBackingSpec = vslmCreateSpecDiskFileBackingSpec2;
        } else {
            if (string == null || string.isEmpty()) {
                throw new IllegalArgumentException("The devicename is mandatory for specified disktype [ " + diskProvisioningTypes.value() + " ]");
            }
            vslmCreateSpecDiskFileBackingSpec2 = new VslmCreateSpecRawDiskMappingBackingSpec();
            vslmCreateSpecDiskFileBackingSpec2.setDatastore(managedObjectReference);
            vslmCreateSpecDiskFileBackingSpec2.setCompatibilityMode(VirtualDiskCompatibilityMode.valueOf((String)diskProvisioningTypes.toString()).value());
            vslmCreateSpecDiskFileBackingSpec2.setLunUuid(string);
            vslmCreateSpecDiskFileBackingSpec = vslmCreateSpecDiskFileBackingSpec2;
        }
        vslmCreateSpecDiskFileBackingSpec2 = new VslmCreateSpec();
        vslmCreateSpecDiskFileBackingSpec2.setBackingSpec((VslmCreateSpecBackingSpec)vslmCreateSpecDiskFileBackingSpec);
        vslmCreateSpecDiskFileBackingSpec2.setName(string2);
        vslmCreateSpecDiskFileBackingSpec2.setCapacityInMB(l);
        return vslmCreateSpecDiskFileBackingSpec2;
    }

    public static boolean isFcdIdInFcdList(List<String> list, List<ID> list2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (ID iD : list2) {
            arrayList.add(iD.getId());
        }
        return arrayList.containsAll(list);
    }

    public static String getFcdFilePath(VStorageObject vStorageObject) {
        BaseConfigInfoBackingInfo baseConfigInfoBackingInfo = vStorageObject.getConfig().getBacking();
        if (baseConfigInfoBackingInfo instanceof BaseConfigInfoFileBackingInfo) {
            BaseConfigInfoFileBackingInfo baseConfigInfoFileBackingInfo = (BaseConfigInfoFileBackingInfo)baseConfigInfoBackingInfo;
            return baseConfigInfoFileBackingInfo.getFilePath();
        }
        return null;
    }

    public static enum DiskProvisioningTypes {
        THIN("thin"),
        EAGER_ZEROED_THICK("eagerZeroedThick"),
        LAZY_ZEROED_THICK("lazyZeroedThick"),
        VIRTUAL_MODE("virtualMode"),
        PHYSICAL_MODE("physicalMode");

        private final String value;

        private DiskProvisioningTypes(String string2) {
            this.value = string2;
        }

        public String value() {
            return this.value;
        }
    }
}

