/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.fcd.helpers;

import com.vmware.connection.Connection;
import com.vmware.fcd.helpers.VslmConnection;
import com.vmware.vim25.ManagedObjectReference;
import com.vmware.vslm.RuntimeFaultFaultMsg;
import com.vmware.vslm.VslmPortType;
import com.vmware.vslm.VslmServiceInstanceContent;
import com.vmware.vslm.VslmTaskInfo;
import com.vmware.vslm.VslmTaskInfoState;

public class FcdVslmHelper {
    private Connection connection;
    private VslmServiceInstanceContent vslmServiceInstanceContent;
    private VslmPortType vslmPort;
    private ManagedObjectReference vStorageObjMgrMor;
    private VslmConnection vslmConnection;
    public static final int VSLM_TASK_SLEEP_INTERVAL = 5000;

    public FcdVslmHelper(Connection connection) throws Exception {
        this.connection = connection;
        this.vslmConnection = new VslmConnection(connection.getUrl(), connection.getUsername(), connection.getPassword());
        this.vslmPort = this.vslmConnection.getVslmPort();
        this.vslmServiceInstanceContent = this.getVslmServiceInstance();
        this.vStorageObjMgrMor = this.getVslmServiceInstance().getVStorageObjectManager();
    }

    public ManagedObjectReference getVStorageObjMgr() {
        return this.vStorageObjMgrMor;
    }

    public VslmPortType getVslmPort() {
        return this.vslmPort;
    }

    public static ManagedObjectReference getVslmMor() {
        ManagedObjectReference managedObjectReference = new ManagedObjectReference();
        managedObjectReference.setType("VslmServiceInstance");
        managedObjectReference.setValue("ServiceInstance");
        return managedObjectReference;
    }

    public VslmServiceInstanceContent getVslmServiceInstance() throws RuntimeFaultFaultMsg {
        return this.vslmPort.retrieveContent(FcdVslmHelper.getVslmMor());
    }

    public boolean waitForTask(ManagedObjectReference managedObjectReference) throws Exception {
        int n;
        boolean bl = false;
        int n2 = 12;
        VslmTaskInfo vslmTaskInfo = this.vslmPort.vslmQueryInfo(managedObjectReference);
        System.out.println("Task " + vslmTaskInfo.getKey() + " started at time " + vslmTaskInfo.getStartTime());
        for (n = 0; n < n2; ++n) {
            vslmTaskInfo = this.vslmPort.vslmQueryInfo(managedObjectReference);
            if (vslmTaskInfo.getState().value().equals(VslmTaskInfoState.SUCCESS.value())) {
                bl = true;
                break;
            }
            if (vslmTaskInfo.getState().value().equals(VslmTaskInfoState.ERROR.value())) break;
            System.out.println("Vslm task status is: " + vslmTaskInfo.getState() + ", Waiting for " + 5000 + " mili secs for task to complete...");
            Thread.sleep(5000L);
        }
        if (!bl && (vslmTaskInfo.getState().value().equals(VslmTaskInfoState.RUNNING.value()) || vslmTaskInfo.getState().value().equals(VslmTaskInfoState.QUEUED.value()))) {
            int n3 = 5000 * n / 1000;
            System.out.println("VslmTaskInfo is still in " + vslmTaskInfo.getState() + " state even after waiting for " + n3 + " secs");
        }
        return bl;
    }
}

