/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.fcd.helpers;

import com.sun.xml.ws.api.message.Header;
import com.sun.xml.ws.api.message.Headers;
import com.sun.xml.ws.developer.WSBindingProvider;
import com.vmware.vim25.ManagedObjectReference;
import com.vmware.vim25.ServiceContent;
import com.vmware.vim25.VimPortType;
import com.vmware.vim25.VimService;
import com.vmware.vslm.VslmPortType;
import com.vmware.vslm.VslmService;
import jakarta.xml.ws.BindingProvider;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSessionContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.xml.namespace.QName;

public class VslmConnection {
    private final ManagedObjectReference VIM_SVC_INST_REF = new ManagedObjectReference();
    private final ManagedObjectReference VSLM_SVC_INST_REF = new ManagedObjectReference();
    private final String VIM_SVC_INST_NAME = "ServiceInstance";
    private final String VSLM_SVC_INST_NAME = "ServiceInstance";
    private final String VSLM_SVC_INST_TYPE = "VslmServiceInstance";
    private VimService vimService;
    private VimPortType vimPort;
    private VslmService vslmService;
    private VslmPortType vslmPort;
    private ServiceContent vimServiceContent;
    private String vimHost;
    private String userName;
    private String password;
    private String sessionCookie;

    private void initSvcInstRef() {
        this.VIM_SVC_INST_REF.setType("ServiceInstance");
        this.VIM_SVC_INST_REF.setValue("ServiceInstance");
        this.VSLM_SVC_INST_REF.setType("VslmServiceInstance");
        this.VSLM_SVC_INST_REF.setValue("ServiceInstance");
    }

    private void initVimPort(String string) throws Exception {
        this.vimService = new VimService();
        this.vimPort = this.vimService.getVimPort();
        Map map = ((BindingProvider)this.vimPort).getRequestContext();
        map.put("jakarta.xml.ws.service.endpoint.address", string);
        map.put("jakarta.xml.ws.session.maintain", true);
    }

    private void initVslmPort(String string) throws Exception {
        String string2 = string.replace("/sdk/vimService", "/vslm/sdk");
        this.vslmService = new VslmService();
        this.vslmPort = this.vslmService.getVslmPort();
        Map map = ((BindingProvider)this.vslmPort).getRequestContext();
        map.put("jakarta.xml.ws.service.endpoint.address", string2);
        map.put("jakarta.xml.ws.session.maintain", true);
        WSBindingProvider wSBindingProvider = (WSBindingProvider)this.vslmPort;
        wSBindingProvider.setOutboundHeaders(new Header[]{Headers.create((QName)new QName("vcSessionCookie"), (String)this.sessionCookie)});
    }

    private void initAll() throws Exception {
        this.initSvcInstRef();
        this.initVimPort(this.vimHost);
        this.initVimServiceContent();
        this.connect(this.vimHost, this.userName, this.password);
        this.readSessionCookieFromHeaders();
        this.initVslmPort(this.vimHost);
    }

    private void initVimServiceContent() throws Exception {
        if (this.vimServiceContent == null) {
            this.vimServiceContent = this.vimPort.retrieveServiceContent(this.VIM_SVC_INST_REF);
            if (this.vimServiceContent == null) {
                throw new Exception("Could not get Service Content");
            }
        }
    }

    private void readSessionCookieFromHeaders() {
        Map map = ((BindingProvider)this.vimPort).getResponseContext();
        Map map2 = (Map)map.get("jakarta.xml.ws.http.response.headers");
        if (map2 == null) {
            System.out.println("WARNING: Failed to read HTTP headers for connection");
            return;
        }
        List list = (List)map2.get("Set-cookie");
        if (list == null) {
            System.out.println("WARNING: Failed to read cookie header for connection");
            return;
        }
        String string = (String)list.get(0);
        String[] stringArray = string.split(";");
        stringArray = stringArray[0].split("=");
        this.sessionCookie = stringArray[1];
    }

    private void connect(String string, String string2, String string3) throws Exception {
        this.vimPort.login(this.vimServiceContent.getSessionManager(), string2, string3, null);
    }

    private void disconnect() throws Exception {
        this.vimPort.logout(this.vimServiceContent.getSessionManager());
    }

    private void trustAllHttpsCertificates() throws Exception {
        TrustManager[] trustManagerArray = new TrustManager[1];
        TrustAllTrustManager trustAllTrustManager = new TrustAllTrustManager();
        trustManagerArray[0] = trustAllTrustManager;
        SSLContext sSLContext = SSLContext.getInstance("SSL");
        SSLSessionContext sSLSessionContext = sSLContext.getServerSessionContext();
        sSLSessionContext.setSessionTimeout(0);
        sSLContext.init(null, trustManagerArray, null);
        HttpsURLConnection.setDefaultSSLSocketFactory(sSLContext.getSocketFactory());
    }

    public VslmConnection(String string, String string2, String string3) throws Exception {
        this.vimHost = string;
        this.userName = string2;
        this.password = string3;
        HostnameVerifier hostnameVerifier = new HostnameVerifier(){

            @Override
            public boolean verify(String string, SSLSession sSLSession) {
                return true;
            }
        };
        this.trustAllHttpsCertificates();
        HttpsURLConnection.setDefaultHostnameVerifier(hostnameVerifier);
        this.initAll();
    }

    public VimPortType getVimPort() {
        return this.vimPort;
    }

    public VslmPortType getVslmPort() {
        return this.vslmPort;
    }

    public ServiceContent getVimServiceContent() {
        return this.vimServiceContent;
    }

    private static class TrustAllTrustManager
    implements TrustManager,
    X509TrustManager {
        private TrustAllTrustManager() {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }

        public boolean isServerTrusted(X509Certificate[] x509CertificateArray) {
            return true;
        }

        public boolean isClientTrusted(X509Certificate[] x509CertificateArray) {
            return true;
        }

        @Override
        public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
        }
    }
}

