/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.spbm.connection;

import com.vmware.common.annotations.Option;
import com.vmware.common.ssl.TrustAll;
import com.vmware.pbm.PbmPortType;
import com.vmware.pbm.PbmService;
import com.vmware.pbm.PbmServiceInstanceContent;
import com.vmware.spbm.connection.Connection;
import com.vmware.spbm.connection.ConnectionException;
import com.vmware.spbm.connection.ConnectionMalformedUrlException;
import com.vmware.spbm.connection.HeaderHandlerResolver;
import com.vmware.spbm.connection.VcSessionHandler;
import com.vmware.sso.client.samples.AcquireHoKTokenByUserCredentialSample;
import com.vmware.sso.client.utils.SecurityUtil;
import com.vmware.vim25.DynamicProperty;
import com.vmware.vim25.InvalidLocaleFaultMsg;
import com.vmware.vim25.InvalidLoginFaultMsg;
import com.vmware.vim25.InvalidPropertyFaultMsg;
import com.vmware.vim25.ManagedObjectReference;
import com.vmware.vim25.ObjectContent;
import com.vmware.vim25.ObjectSpec;
import com.vmware.vim25.PropertyFilterSpec;
import com.vmware.vim25.PropertySpec;
import com.vmware.vim25.RetrieveOptions;
import com.vmware.vim25.RuntimeFaultFaultMsg;
import com.vmware.vim25.ServiceContent;
import com.vmware.vim25.UserSession;
import com.vmware.vim25.VimPortType;
import com.vmware.vim25.VimService;
import com.vmware.vsphere.samples.LoginByTokenSample;
import jakarta.xml.ws.BindingProvider;
import jakarta.xml.ws.handler.HandlerResolver;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Element;

public class BasicConnection
implements Connection {
    private static final String VIMSERVICEINSTANCETYPE = "ServiceInstance";
    private static final String VIMSERVICEINSTANCEVALUE = "ServiceInstance";
    private static final String PBMSERVICEINSTANCETYPE = "PbmServiceInstance";
    private static final String PBMSERVICEINSTANCEVALUE = "ServiceInstance";
    private static final String SSO_URL = "sso.url";
    private VimService vimService = new VimService();
    private VimPortType vimPort = this.vimService.getVimPort();
    private ServiceContent vimServiceContent;
    private UserSession userSession;
    private ManagedObjectReference vimSvcInstRef;
    private ManagedObjectReference pbmSvcInstRef;
    private URL spbmurl;
    private URL vcurl;
    private String username;
    private String password = "";
    private PbmService pbmService = new PbmService();
    private PbmPortType pbmPort = this.pbmService.getPbmPort();
    private PbmServiceInstanceContent pbmServiceContent;
    private URL ssoUrl;

    private void _connect() throws RuntimeFaultFaultMsg, InvalidLocaleFaultMsg, InvalidLoginFaultMsg, com.vmware.pbm.RuntimeFaultFaultMsg, InvalidPropertyFaultMsg {
        System.out.println("Initiating connection...");
        System.out.println("========================");
        String string = this.ssoConnect(this.getSsoURL().toString(), this.username, this.password, this.vcurl.toString());
        this.vimService = new VimService();
        this.vimPort = this.vimService.getVimPort();
        Map map = ((BindingProvider)this.vimPort).getRequestContext();
        map.put("jakarta.xml.ws.service.endpoint.address", this.vcurl.toString());
        map.put("jakarta.xml.ws.session.maintain", true);
        HashMap<String, List<String>> hashMap = (HashMap<String, List<String>>)map.get("jakarta.xml.ws.http.request.headers");
        if (hashMap == null) {
            hashMap = new HashMap<String, List<String>>();
        }
        hashMap.put("Cookie", Arrays.asList(string));
        map.put("jakarta.xml.ws.http.request.headers", hashMap);
        this.vimServiceContent = this.vimPort.retrieveServiceContent(this.getVimServiceInstanceReference());
        this.userSession = (UserSession)this.entityProps(this.vimServiceContent.getSessionManager(), new String[]{"currentSession"}).get("currentSession");
        String[] stringArray = string.split(";");
        stringArray = stringArray[0].split("=");
        String string2 = stringArray[1];
        this.pbmService = new PbmService();
        HeaderHandlerResolver headerHandlerResolver = new HeaderHandlerResolver();
        headerHandlerResolver.addHandler(new VcSessionHandler(string2));
        this.pbmService.setHandlerResolver((HandlerResolver)headerHandlerResolver);
        this.pbmPort = this.pbmService.getPbmPort();
        Map map2 = ((BindingProvider)this.pbmPort).getRequestContext();
        map2.put("jakarta.xml.ws.session.maintain", true);
        map2.put("jakarta.xml.ws.service.endpoint.address", this.spbmurl.toString());
        this.pbmServiceContent = this.pbmPort.pbmRetrieveServiceContent(this.getPbmServiceInstanceReference());
        System.out.println("Connection established...");
        System.out.println("=========================\n");
    }

    private Map<String, Object> entityProps(ManagedObjectReference managedObjectReference, String[] stringArray) throws InvalidPropertyFaultMsg, RuntimeFaultFaultMsg {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        PropertySpec propertySpec = new PropertySpec();
        propertySpec.setAll(Boolean.FALSE);
        propertySpec.setType(managedObjectReference.getType());
        propertySpec.getPathSet().addAll(Arrays.asList(stringArray));
        ObjectSpec objectSpec = new ObjectSpec();
        objectSpec.setObj(managedObjectReference);
        PropertyFilterSpec propertyFilterSpec = new PropertyFilterSpec();
        propertyFilterSpec.getPropSet().add(propertySpec);
        propertyFilterSpec.getObjectSet().add(objectSpec);
        List list = this.vimPort.retrievePropertiesEx(this.vimServiceContent.getPropertyCollector(), Arrays.asList(propertyFilterSpec), new RetrieveOptions()).getObjects();
        if (list != null) {
            for (ObjectContent objectContent : list) {
                List list2 = objectContent.getPropSet();
                for (DynamicProperty dynamicProperty : list2) {
                    hashMap.put(dynamicProperty.getName(), dynamicProperty.getVal());
                }
            }
        }
        return hashMap;
    }

    private String ssoConnect(String ... stringArray) {
        try {
            SecurityUtil securityUtil = SecurityUtil.loadFromDefaultFiles();
            Element element = AcquireHoKTokenByUserCredentialSample.getToken((String[])stringArray, (PrivateKey)securityUtil.getPrivateKey(), (X509Certificate)securityUtil.getUserCert());
            return LoginByTokenSample.loginUsingSAMLToken((Element)element, (String)stringArray[3], (PrivateKey)securityUtil.getPrivateKey(), (X509Certificate)securityUtil.getUserCert());
        }
        catch (Exception exception) {
            throw new ConnectionException("Error connecting to the vCenter Server", exception);
        }
    }

    @Override
    public Connection connect() {
        if (!this.isConnected()) {
            try {
                this._connect();
            }
            catch (Exception exception) {
                Throwable throwable = exception.getCause() != null ? exception.getCause() : exception;
                throw new ConnectionException("failed to connect: " + exception.getMessage() + " : " + throwable.getMessage(), throwable);
            }
        }
        return this;
    }

    @Override
    public Connection disconnect() {
        if (this.isConnected()) {
            try {
                this.vimPort.logout(this.vimServiceContent.getSessionManager());
            }
            catch (Exception exception) {
                Throwable throwable = exception.getCause();
                throw new ConnectionException("failed to disconnect properly: " + exception.getMessage() + " : " + throwable.getMessage(), throwable);
            }
            finally {
                this.userSession = null;
                this.vimServiceContent = null;
                this.vimPort = null;
                this.vimService = null;
                this.pbmPort = null;
                this.pbmService = null;
            }
        }
        return this;
    }

    protected String getDefaultSsoUrl() {
        String string = System.getProperty("sso.host", this.vcurl.getHost());
        String string2 = System.getProperty("sso.port", "");
        String string3 = System.getProperty("sso.path", "/sts/STSService");
        return String.format("https://%s:%s%s", string, string2, string3);
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    @Override
    public PbmPortType getPbmPort() {
        return this.pbmPort;
    }

    @Override
    public PbmService getPbmService() {
        return this.pbmService;
    }

    @Override
    public PbmServiceInstanceContent getPbmServiceContent() {
        return this.pbmServiceContent;
    }

    @Override
    public ManagedObjectReference getPbmServiceInstanceReference() {
        if (this.pbmSvcInstRef == null) {
            ManagedObjectReference managedObjectReference = new ManagedObjectReference();
            managedObjectReference.setType(PBMSERVICEINSTANCETYPE);
            managedObjectReference.setValue("ServiceInstance");
            this.pbmSvcInstRef = managedObjectReference;
        }
        return this.pbmSvcInstRef;
    }

    @Override
    public URL getSpbmURL() {
        if (this.spbmurl == null) {
            try {
                this.spbmurl = new URL(this.getVcURL().toString().replace("/sdk", "/pbm"));
            }
            catch (MalformedURLException malformedURLException) {
                throw new ConnectionMalformedUrlException("malformed URL argument: '" + this.spbmurl + "'", malformedURLException);
            }
        }
        return this.spbmurl;
    }

    @Override
    public URL getSsoURL() {
        if (this.ssoUrl != null) {
            return this.ssoUrl;
        }
        String string = System.getProperty(SSO_URL, this.getDefaultSsoUrl());
        try {
            this.ssoUrl = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            throw new ConnectionMalformedUrlException("malformed URL argument: '" + this.spbmurl + "'", malformedURLException);
        }
        return this.ssoUrl;
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    @Override
    public UserSession getUserSession() {
        return this.userSession;
    }

    @Override
    public URL getVcURL() {
        return this.vcurl;
    }

    @Override
    public VimPortType getVimPort() {
        return this.vimPort;
    }

    @Override
    public VimService getVimService() {
        return this.vimService;
    }

    @Override
    public ServiceContent getVimServiceContent() {
        return this.vimServiceContent;
    }

    @Override
    public ManagedObjectReference getVimServiceInstanceReference() {
        if (this.vimSvcInstRef == null) {
            ManagedObjectReference managedObjectReference = new ManagedObjectReference();
            managedObjectReference.setType("ServiceInstance");
            managedObjectReference.setValue("ServiceInstance");
            this.vimSvcInstRef = managedObjectReference;
        }
        return this.vimSvcInstRef;
    }

    @Override
    public boolean isConnected() {
        if (this.userSession == null) {
            return false;
        }
        long l = this.userSession.getLastActiveTime().toGregorianCalendar().getTime().getTime();
        return new Date().getTime() < l + 1800000L;
    }

    @Override
    public void setIgnoreCert(Boolean bl) {
        System.setProperty("ssl.trustAll.enabled", bl.toString());
        try {
            TrustAll.trust();
        }
        catch (KeyManagementException keyManagementException) {
            keyManagementException.printStackTrace();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            noSuchAlgorithmException.printStackTrace();
        }
    }

    @Override
    public void setPassword(String string) {
        this.password = string;
    }

    @Override
    public void setSpbmUrl(String string) {
        try {
            this.spbmurl = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            throw new ConnectionMalformedUrlException("malformed URL argument: '" + string + "'", malformedURLException);
        }
    }

    @Override
    public void setSsoUrl(String string) {
        try {
            this.ssoUrl = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            throw new ConnectionMalformedUrlException("malformed URL argument: '" + this.spbmurl + "'", malformedURLException);
        }
    }

    @Override
    public void setUsername(String string) {
        this.username = string;
    }

    @Override
    @Option(name="vcurl", systemProperty="vimService.url", description="full url to the vSphere WS SDK service on vCenter")
    public void setVcUrl(String string) {
        try {
            this.vcurl = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            throw new ConnectionMalformedUrlException("malformed URL argument: '" + string + "'", malformedURLException);
        }
    }
}

