/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.spbm.samples;

import com.vmware.common.annotations.Action;
import com.vmware.common.annotations.Option;
import com.vmware.common.annotations.Sample;
import com.vmware.pbm.InvalidArgumentFaultMsg;
import com.vmware.pbm.PbmCapabilityProfile;
import com.vmware.pbm.PbmProfileId;
import com.vmware.spbm.connection.ConnectedServiceBase;
import com.vmware.spbm.connection.helpers.PbmUtil;
import com.vmware.spbm.connection.helpers.VCUtil;
import com.vmware.vim25.ArrayOfVirtualDevice;
import com.vmware.vim25.BaseConfigInfoBackingInfo;
import com.vmware.vim25.BaseConfigInfoDiskFileBackingInfo;
import com.vmware.vim25.BaseConfigInfoFileBackingInfo;
import com.vmware.vim25.ConcurrentAccessFaultMsg;
import com.vmware.vim25.DuplicateNameFaultMsg;
import com.vmware.vim25.DynamicProperty;
import com.vmware.vim25.FileFaultFaultMsg;
import com.vmware.vim25.ID;
import com.vmware.vim25.InsufficientResourcesFaultFaultMsg;
import com.vmware.vim25.InvalidCollectorVersionFaultMsg;
import com.vmware.vim25.InvalidControllerFaultMsg;
import com.vmware.vim25.InvalidDatastoreFaultMsg;
import com.vmware.vim25.InvalidNameFaultMsg;
import com.vmware.vim25.InvalidPropertyFaultMsg;
import com.vmware.vim25.InvalidStateFaultMsg;
import com.vmware.vim25.LocalizedMethodFault;
import com.vmware.vim25.ManagedObjectReference;
import com.vmware.vim25.MissingControllerFaultMsg;
import com.vmware.vim25.NotFoundFaultMsg;
import com.vmware.vim25.ObjectContent;
import com.vmware.vim25.ObjectSpec;
import com.vmware.vim25.PropertyFilterSpec;
import com.vmware.vim25.PropertySpec;
import com.vmware.vim25.RetrieveOptions;
import com.vmware.vim25.RetrieveResult;
import com.vmware.vim25.RuntimeFaultFaultMsg;
import com.vmware.vim25.TaskInProgressFaultMsg;
import com.vmware.vim25.TaskInfoState;
import com.vmware.vim25.TraversalSpec;
import com.vmware.vim25.VStorageObject;
import com.vmware.vim25.VirtualDevice;
import com.vmware.vim25.VirtualDeviceBackingInfo;
import com.vmware.vim25.VirtualDeviceConfigSpec;
import com.vmware.vim25.VirtualDeviceConfigSpecOperation;
import com.vmware.vim25.VirtualDeviceFileBackingInfo;
import com.vmware.vim25.VirtualDisk;
import com.vmware.vim25.VirtualMachineConfigSpec;
import com.vmware.vim25.VirtualMachineDefinedProfileSpec;
import com.vmware.vim25.VirtualSCSIController;
import com.vmware.vim25.VmConfigFaultFaultMsg;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Sample(name="fcd-associateprofile", description="This sample attaches a given virtual storage object(FCD) to the given virtual machine.")
public class FcdAssociateProfile
extends ConnectedServiceBase {
    private String vStorageObjectId;
    private String vmPath;
    private String datastoreName;
    private String profileName;

    @Option(name="vstorageobjectid", required=true, description="Uuid of the disk.")
    public void setVStorageObjectId(String string) {
        this.vStorageObjectId = string;
    }

    @Option(name="vmpath", required=true, description="Path of virtual machine.")
    public void setVmPath(String string) {
        this.vmPath = string;
    }

    @Option(name="datastorename", required=true, description="Name of datastore containing the  vstorageobject.")
    public void setDatastoreName(String string) {
        this.datastoreName = string;
    }

    @Option(name="profilename", required=true, description="Name of the storage profile")
    public void setProfileName(String string) {
        this.profileName = string;
    }

    boolean getTaskResultAfterDone(ManagedObjectReference managedObjectReference) throws InvalidPropertyFaultMsg, RuntimeFaultFaultMsg, InvalidCollectorVersionFaultMsg {
        boolean bl = false;
        Object[] objectArray = VCUtil.waitForTask(this.connection, managedObjectReference, new String[]{"info.state", "info.error"}, new String[]{"state"}, new Object[][]{{TaskInfoState.SUCCESS, TaskInfoState.ERROR}});
        if (objectArray[0].equals(TaskInfoState.SUCCESS)) {
            bl = true;
        }
        if (objectArray[1] instanceof LocalizedMethodFault) {
            throw new RuntimeException(((LocalizedMethodFault)objectArray[1]).getLocalizedMessage());
        }
        return bl;
    }

    void associateProfileWithFcdByAttachingToVm() throws InvalidPropertyFaultMsg, RuntimeFaultFaultMsg, InvalidArgumentFaultMsg, com.vmware.pbm.RuntimeFaultFaultMsg, FileFaultFaultMsg, InvalidDatastoreFaultMsg, NotFoundFaultMsg, InvalidControllerFaultMsg, InvalidStateFaultMsg, MissingControllerFaultMsg, VmConfigFaultFaultMsg, InvalidCollectorVersionFaultMsg, ConcurrentAccessFaultMsg, DuplicateNameFaultMsg, InsufficientResourcesFaultFaultMsg, InvalidNameFaultMsg, TaskInProgressFaultMsg {
        ManagedObjectReference managedObjectReference = this.connection.getVimServiceContent().getVStorageObjectManager();
        System.out.println("Info: vmPath is :: " + this.vmPath);
        ManagedObjectReference managedObjectReference2 = this.connection.getVimPort().findByInventoryPath(this.connection.getVimServiceContent().getSearchIndex(), this.vmPath);
        if (managedObjectReference2 == null) {
            throw new RuntimeException("Error: morVm Obtained is null");
        }
        ManagedObjectReference managedObjectReference3 = this.getMOREFsInContainerByType(this.connection.getVimServiceContent().getRootFolder(), "Datastore").get(this.datastoreName);
        PbmCapabilityProfile pbmCapabilityProfile = PbmUtil.getPbmProfile(this.connection, this.profileName);
        PbmProfileId pbmProfileId = pbmCapabilityProfile.getProfileId();
        System.out.println("Operation: Retrieve the vStorageObjects in datastore.");
        VStorageObject vStorageObject = this.connection.getVimPort().retrieveVStorageObject(managedObjectReference, FcdAssociateProfile.makeId(this.vStorageObjectId), managedObjectReference3, null);
        if (!vStorageObject.getConfig().getId().getId().equals(this.vStorageObjectId)) {
            String string = "Error: Given vStorageObject [ " + this.vStorageObjectId + "] and retrieved VStorageObject are different.";
            throw new RuntimeException(string);
        }
        System.out.printf("Success: Retrieved vStorageObject :: %n [ %s ]%n", vStorageObject.getConfig().getId().getId());
        if (!this.reconfigVMToAddFcdAndUpdateProfile(managedObjectReference2, vStorageObject, pbmProfileId)) {
            String string = "Error: Associating profile [ " + this.profileName + " ] to the vStorageObject [ " + this.vStorageObjectId + " ].";
            throw new RuntimeException(string);
        }
        System.out.printf("Success: Associated profile :: [ Name = %s ] to vStorageObject [ Name = %s , Uuid = %s ]%n", this.profileName, vStorageObject.getConfig().getName(), vStorageObject.getConfig().getId().getId());
        System.out.println("Operation: Retrieve the vStorageObjects in datastore.");
        VStorageObject vStorageObject2 = this.connection.getVimPort().retrieveVStorageObject(managedObjectReference, FcdAssociateProfile.makeId(this.vStorageObjectId), managedObjectReference3, null);
        if (vStorageObject2.getConfig().getId().getId().equals(this.vStorageObjectId)) {
            if (vStorageObject2.getConfig().getConsumerId().get(0) == null) {
                String string = "Error: Given vStorageObject [ " + this.vStorageObjectId + "] does not have a consumer attached to it.";
                throw new RuntimeException(string);
            }
        } else {
            String string = "Error: Given vStorageObject [ " + this.vStorageObjectId + "] and retrieved VStorageObject are different.";
            throw new RuntimeException(string);
        }
        System.out.printf("Success: Retrieved vStorageObject :: %n [ Uuid = %s ] is associated with consumer [ ConsumerId = %s ]%n", vStorageObject2.getConfig().getId().getId(), ((ID)vStorageObject2.getConfig().getConsumerId().get(0)).getId());
    }

    protected boolean reconfigVMToAddFcdAndUpdateProfile(ManagedObjectReference managedObjectReference, VStorageObject vStorageObject, PbmProfileId pbmProfileId) throws RuntimeFaultFaultMsg, InvalidPropertyFaultMsg, ConcurrentAccessFaultMsg, DuplicateNameFaultMsg, FileFaultFaultMsg, InsufficientResourcesFaultFaultMsg, InvalidDatastoreFaultMsg, InvalidNameFaultMsg, InvalidStateFaultMsg, TaskInProgressFaultMsg, VmConfigFaultFaultMsg, InvalidCollectorVersionFaultMsg {
        System.out.printf("Info: Reconfig VM To Add Fcd [ %s ]%n", vStorageObject.getConfig().getId().getId());
        if (pbmProfileId != null) {
            System.out.printf("Info: Associating profile with Profile Id [ %s ] to vStorageObject [ Uuid = %s ].", pbmProfileId.getUniqueId(), vStorageObject.getConfig().getId().getId());
        }
        boolean bl = false;
        VirtualMachineConfigSpec virtualMachineConfigSpec = new VirtualMachineConfigSpec();
        VirtualDeviceConfigSpec virtualDeviceConfigSpec = this.getDiskDeviceConfigSpec(managedObjectReference, vStorageObject, pbmProfileId);
        ArrayList<VirtualDeviceConfigSpec> arrayList = new ArrayList<VirtualDeviceConfigSpec>();
        arrayList.add(virtualDeviceConfigSpec);
        virtualMachineConfigSpec.getDeviceChange().addAll(arrayList);
        ManagedObjectReference managedObjectReference2 = this.connection.getVimPort().reconfigVMTask(managedObjectReference, virtualMachineConfigSpec);
        bl = this.getTaskResultAfterDone(managedObjectReference2);
        return bl;
    }

    private VirtualDeviceConfigSpec getDiskDeviceConfigSpec(ManagedObjectReference managedObjectReference, VStorageObject vStorageObject, PbmProfileId pbmProfileId) throws InvalidPropertyFaultMsg, RuntimeFaultFaultMsg {
        Object object;
        VirtualDeviceConfigSpec virtualDeviceConfigSpec = new VirtualDeviceConfigSpec();
        VirtualDisk virtualDisk = new VirtualDisk();
        String string = null;
        BaseConfigInfoBackingInfo baseConfigInfoBackingInfo = vStorageObject.getConfig().getBacking();
        if (baseConfigInfoBackingInfo instanceof BaseConfigInfoFileBackingInfo) {
            object = (BaseConfigInfoDiskFileBackingInfo)baseConfigInfoBackingInfo;
            string = object.getFilePath();
        }
        if (string == null) {
            object = "Error: No FileName/FilePath obtained for the vStorageObject [ " + vStorageObject.getConfig().getId().getId() + " ].";
            throw new RuntimeException((String)object);
        }
        object = new VirtualDeviceFileBackingInfo();
        object.setFileName(string);
        virtualDisk.setBacking((VirtualDeviceBackingInfo)object);
        int n = 0;
        int n2 = 0;
        List<Integer> list = this.getControllerKey(managedObjectReference);
        if (!list.isEmpty()) {
            n = list.get(0);
            n2 = list.get(1);
        }
        virtualDisk.setControllerKey(Integer.valueOf(n));
        virtualDisk.setUnitNumber(Integer.valueOf(n2));
        long l = 1024L * vStorageObject.getConfig().getCapacityInMB();
        virtualDisk.setCapacityInKB(l);
        virtualDisk.setKey(-1);
        VirtualMachineDefinedProfileSpec virtualMachineDefinedProfileSpec = new VirtualMachineDefinedProfileSpec();
        virtualMachineDefinedProfileSpec.setProfileId(pbmProfileId.getUniqueId());
        System.out.printf("Info: Associating disk with profileId : %s%n", pbmProfileId.getUniqueId());
        virtualDeviceConfigSpec.getProfile().add(virtualMachineDefinedProfileSpec);
        virtualDeviceConfigSpec.setOperation(VirtualDeviceConfigSpecOperation.ADD);
        virtualDeviceConfigSpec.setFileOperation(null);
        virtualDeviceConfigSpec.setDevice((VirtualDevice)virtualDisk);
        return virtualDeviceConfigSpec;
    }

    List<Integer> getControllerKey(ManagedObjectReference managedObjectReference) throws InvalidPropertyFaultMsg, RuntimeFaultFaultMsg {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        List list = ((ArrayOfVirtualDevice)VCUtil.getEntityProps(this.connection, managedObjectReference, new String[]{"config.hardware.device"}).get("config.hardware.device")).getVirtualDevice();
        HashMap<Integer, Object> hashMap = new HashMap<Integer, Object>();
        for (Object object : list) {
            hashMap.put(object.getKey(), object);
        }
        boolean bl = false;
        for (VirtualDevice virtualDevice : list) {
            if (!(virtualDevice instanceof VirtualSCSIController)) continue;
            VirtualSCSIController virtualSCSIController = (VirtualSCSIController)virtualDevice;
            int[] nArray = new int[16];
            nArray[7] = 1;
            List list2 = virtualSCSIController.getDevice();
            for (Integer n : list2) {
                if (((VirtualDevice)hashMap.get(n)).getUnitNumber() == null) continue;
                nArray[((VirtualDevice)hashMap.get((Object)n)).getUnitNumber().intValue()] = 1;
            }
            for (int i = 0; i < nArray.length; ++i) {
                if (nArray[i] == 1) continue;
                arrayList.add(virtualSCSIController.getKey());
                arrayList.add(i);
                bl = true;
                break;
            }
            if (!bl) continue;
            break;
        }
        if (!bl) {
            throw new RuntimeException("The SCSI controller on the vm has maxed out its capacity. Please add an additional SCSI controller");
        }
        return arrayList;
    }

    Map<String, ManagedObjectReference> getMOREFsInContainerByType(ManagedObjectReference managedObjectReference, String string) throws InvalidPropertyFaultMsg, RuntimeFaultFaultMsg {
        String string2 = "name";
        ManagedObjectReference managedObjectReference2 = this.connection.getVimServiceContent().getViewManager();
        ManagedObjectReference managedObjectReference3 = this.connection.getVimPort().createContainerView(managedObjectReference2, managedObjectReference, Arrays.asList(string), true);
        HashMap<String, ManagedObjectReference> hashMap = new HashMap<String, ManagedObjectReference>();
        PropertySpec propertySpec = new PropertySpec();
        propertySpec.setAll(Boolean.FALSE);
        propertySpec.setType(string);
        propertySpec.getPathSet().add(string2);
        TraversalSpec traversalSpec = new TraversalSpec();
        traversalSpec.setName("view");
        traversalSpec.setPath("view");
        traversalSpec.setSkip(Boolean.valueOf(false));
        traversalSpec.setType("ContainerView");
        ObjectSpec objectSpec = new ObjectSpec();
        objectSpec.setObj(managedObjectReference3);
        objectSpec.setSkip(Boolean.TRUE);
        objectSpec.getSelectSet().add(traversalSpec);
        PropertyFilterSpec propertyFilterSpec = new PropertyFilterSpec();
        propertyFilterSpec.getPropSet().add(propertySpec);
        propertyFilterSpec.getObjectSet().add(objectSpec);
        ArrayList<PropertyFilterSpec> arrayList = new ArrayList<PropertyFilterSpec>();
        arrayList.add(propertyFilterSpec);
        RetrieveResult retrieveResult = this.connection.getVimPort().retrievePropertiesEx(this.connection.getVimServiceContent().getPropertyCollector(), arrayList, new RetrieveOptions());
        ArrayList arrayList2 = new ArrayList();
        if (retrieveResult != null && retrieveResult.getObjects() != null && !retrieveResult.getObjects().isEmpty()) {
            arrayList2.addAll(retrieveResult.getObjects());
        }
        String string3 = null;
        if (retrieveResult != null && retrieveResult.getToken() != null) {
            string3 = retrieveResult.getToken();
        }
        while (string3 != null && !string3.isEmpty()) {
            retrieveResult = this.connection.getVimPort().continueRetrievePropertiesEx(this.connection.getVimServiceContent().getPropertyCollector(), string3);
            string3 = null;
            if (retrieveResult == null) continue;
            string3 = retrieveResult.getToken();
            if (retrieveResult.getObjects() == null || retrieveResult.getObjects().isEmpty()) continue;
            arrayList2.addAll(retrieveResult.getObjects());
        }
        for (ObjectContent objectContent : arrayList2) {
            ManagedObjectReference managedObjectReference4 = objectContent.getObj();
            String string4 = null;
            List list = objectContent.getPropSet();
            if (list != null) {
                for (DynamicProperty dynamicProperty : list) {
                    string4 = (String)dynamicProperty.getVal();
                }
            }
            hashMap.put(string4, managedObjectReference4);
        }
        return hashMap;
    }

    private static ID makeId(String string) {
        ID iD = new ID();
        iD.setId(string);
        return iD;
    }

    @Action
    public void run() throws InvalidPropertyFaultMsg, RuntimeFaultFaultMsg, FileFaultFaultMsg, InvalidDatastoreFaultMsg, NotFoundFaultMsg, InvalidControllerFaultMsg, InvalidStateFaultMsg, MissingControllerFaultMsg, VmConfigFaultFaultMsg, InvalidCollectorVersionFaultMsg, InvalidArgumentFaultMsg, com.vmware.pbm.RuntimeFaultFaultMsg, ConcurrentAccessFaultMsg, DuplicateNameFaultMsg, InsufficientResourcesFaultFaultMsg, InvalidNameFaultMsg, TaskInProgressFaultMsg {
        this.associateProfileWithFcdByAttachingToVm();
    }
}

