/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.common;

import com.vmware.common.samples.SampleException;
import com.vmware.common.samples.SampleRegistry;
import com.vmware.common.samples.SystemParameters;
import com.vmware.common.samples.reflection.SampleReflectionException;
import com.vmware.common.samples.reflection.UnregisteredSampleHandler;
import com.vmware.common.samples.registry.SampleExecutionRecord;
import com.vmware.common.samples.registry.SampleNotFoundException;
import com.vmware.common.samples.registry.SampleReference;
import com.vmware.common.ssl.TrustAll;
import jakarta.xml.ws.soap.SOAPFaultException;
import java.io.File;
import java.io.FilenameFilter;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;

public class Main {
    static final String HELP = "--help";
    private static SystemParameters systemParameters;

    public static void trustAll() throws NoSuchAlgorithmException, KeyManagementException {
        TrustAll.trust();
    }

    public static void main(String[] args) throws Throwable {
        systemParameters = SystemParameters.parse(Main.findConfigurationFiles());
        for (String propName : systemParameters.parameterNames()) {
            String value = systemParameters.get(propName);
            System.setProperty(propName, value);
        }
        Main.trustAll();
        System.out.printf("%s%n", System.getProperty("sample.header", "-- VMware samples in Java --"));
        if (args.length > 0 && UnregisteredSampleHandler.isStandalone(args[0])) {
            String[] subargs = new String[args.length - 1];
            if (args.length > 1) {
                System.arraycopy(args, 1, subargs, 0, subargs.length);
            }
            UnregisteredSampleHandler.handle(args[0], subargs);
        } else {
            SampleExecutionRecord record = Main.registeredSample(args);
            if (!record.isGood()) {
                System.out.println(System.getProperty("sample.footer", ""));
            }
        }
        System.out.println();
    }

    private static File[] findConfigurationFiles() {
        LinkedList<File> files = new LinkedList<File>();
        for (String fileName : Main.propertyFileNames()) {
            try {
                List<File> found = Main.findPropertiesFile(fileName.replaceAll("(^\\s+|\\s+$)", ""));
                files.addAll(found);
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
            }
        }
        return files.toArray(new File[files.size()]);
    }

    public static String[] propertyFileNames() {
        String specified = System.getProperty("sample.properties.files");
        return specified != null && !"".equals(specified) ? specified.split("\\s*,\\s*") : Main.scanForPropertyFiles();
    }

    public static String[] scanForPropertyFiles() {
        File[] files = new File(".").listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File file, String s) {
                return s.endsWith(".properties");
            }
        });
        String[] names = new String[files.length];
        for (int i = 0; i < names.length; ++i) {
            names[i] = files[i].getName();
        }
        return names;
    }

    private static SampleExecutionRecord registeredSample(String[] args) {
        SampleExecutionRecord record;
        block8: {
            record = SampleExecutionRecord.NULL_RECORD;
            SampleRegistry registry = new SampleRegistry(systemParameters, HELP).init();
            String name = args.length > 0 ? registry.getSampleName(args[0]) : "help";
            try {
                record = Main.sampleSwitching(registry, name, args);
                if (record.hasFault()) {
                    Throwable fault = record.getFault();
                    Main.printError(fault.getMessage(), fault);
                    if (Main.showStackTrace()) {
                        fault.printStackTrace(System.out);
                    }
                }
            }
            catch (SampleNotFoundException snfe) {
                System.out.println();
                System.out.println("\tERROR: " + snfe.getMessage());
                System.out.println();
                registry.usage(System.out);
            }
            catch (SampleReflectionException sre) {
                Main.printError(sre.getCause().getMessage(), sre.getCause());
            }
            catch (SampleException se) {
                Main.printError(se.getMessage(), se.getCause());
                registry.help(name, System.out);
            }
            catch (SOAPFaultException sfe) {
                System.out.println("SOAP Fault -");
                if (sfe.getFault().hasDetail()) {
                    System.out.println(sfe.getFault().getDetail().getFirstChild().getLocalName());
                }
                if (sfe.getFault().getFaultString() == null) break block8;
                System.out.println("\n Message: " + sfe.getFault().getFaultString());
            }
        }
        return record;
    }

    public static boolean showStackTrace() {
        return Boolean.valueOf(System.getProperty("samples.show.stack.trace", Defaults.SAMPLES_SHOW_STACK_TRACE));
    }

    private static void printError(String message, Throwable cause) {
        System.out.println();
        System.out.println("\tERROR: " + message);
        System.out.println();
        if (cause != null) {
            cause.printStackTrace();
        }
    }

    public static List<File> findPropertiesFile(String fileName) throws URISyntaxException {
        if (null == fileName || fileName.length() == 0) {
            return new LinkedList<File>();
        }
        LinkedList<File> files = new LinkedList<File>();
        URL resourceUrl = Main.class.getResource(fileName);
        if (resourceUrl != null) {
            URI resourceUri = resourceUrl.toURI();
            files.add(new File(resourceUri));
        }
        File workingDir = new File(".");
        Main.checkForProperties(workingDir, fileName, files);
        File homeDir = new File(System.getProperty("user.home"));
        Main.checkForProperties(homeDir, fileName, files);
        return files;
    }

    private static void checkForProperties(File dir, String fileName, List<File> files) {
        File file = new File(dir, fileName);
        if (file.exists() && file.canRead()) {
            files.add(file);
        }
    }

    private static SampleExecutionRecord sampleSwitching(SampleRegistry registry, String name, String[] args) throws SampleNotFoundException {
        if (!(Main.contains(args, HELP) || HELP.equals(name) || HELP.contains(name))) {
            String[] subargs = args;
            if (args.length > 0) {
                subargs = Arrays.copyOfRange(args, 1, args.length);
            }
            return Main.run(registry.describe(name), subargs);
        }
        registry.help(name, System.out);
        return SampleExecutionRecord.NULL_RECORD;
    }

    private static boolean contains(String[] args, String string) {
        boolean found = false;
        for (String arg : args) {
            found |= arg.equalsIgnoreCase(string);
        }
        return found;
    }

    private static SampleExecutionRecord run(SampleReference ref, String[] params) {
        SampleExecutionRecord record = null;
        try {
            record = ref.run(params);
        }
        catch (InvocationTargetException e) {
            throw new SampleReflectionException(e);
        }
        catch (InstantiationException e) {
            throw new SampleReflectionException(e);
        }
        catch (IllegalAccessException e) {
            throw new SampleReflectionException(e);
        }
        return record;
    }

    public static class Defaults {
        public static final String TRUST_ALL = Boolean.FALSE.toString();
        public static final String TRUST_ALL_MESSAGE = "WARNING: Java is now set to trust all SSL certificates.";
        public static final String SAMPLE_HEADER = "-- VMware samples in Java --";
        public static final String SAMPLE_FOOTER = "";
        public static final String SAMPLE_HELP_FOOTER = "to invoke a command, type its class name. For help type --help at the end of any command.";
        public static final String SAMPLE_PACKAGE_NAME = "com.vmware";
        public static final String SAMPLES_SHOW_STACK_TRACE = Boolean.TRUE.toString();
        public static final String SAMPLES_USE_NAME = Boolean.FALSE.toString();
    }

    public static class Properties {
        public static final String SAMPLE_PROPERTIES_FILES = "sample.properties.files";
        public static final String TRUST_ALL = "ssl.trustAll.enabled";
        public static final String TRUST_ALL_MESSAGE = "ssl.trustAll.message";
        public static final String SAMPLE_HEADER = "sample.header";
        public static final String SAMPLE_FOOTER = "sample.footer";
        public static final String SAMPLE_HELP_FOOTER = "sample.help.footer";
        public static final String SAMPLE_PACKAGE_NAME = "sample.package.name";
        public static final String SAMPLES_SHOW_STACK_TRACE = "samples.show.stack.trace";
        public static final String SAMPLES_USE_NAME = "samples.use.name";
    }

    public static class SampleInputValidationException
    extends SampleIllegalArgumentException {
        private static final long serialVersionUID = -2181593283163266846L;

        public SampleInputValidationException(String message) {
            super(message);
        }
    }

    public static class SampleIllegalArgumentException
    extends SampleException {
        private static final long serialVersionUID = -6434091576608075485L;

        public SampleIllegalArgumentException(String message) {
            super(message);
        }

        public SampleIllegalArgumentException(Throwable throwable) {
            super(throwable);
        }
    }

    public static class SampleMissingConfigurationsException
    extends SampleIllegalArgumentException {
        private static final long serialVersionUID = 1L;

        private static String configurationErrorMessage() {
            String message = "Missing configuration files! Requires one of these configuration files to be present ";
            for (String fileName : Main.propertyFileNames()) {
                message = message + " '" + fileName + "' ";
            }
            message = message + " in ";
            message = message + System.getProperty("user.home") + " or ";
            message = message + new File(".").getAbsolutePath();
            return message;
        }

        public SampleMissingConfigurationsException() {
            super(SampleMissingConfigurationsException.configurationErrorMessage());
        }
    }
}

