/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.common.samples.reflection;

import com.vmware.common.samples.reflection.ClassFinder;
import com.vmware.common.samples.reflection.ClassScanner;
import com.vmware.common.samples.reflection.DirectoryClassScanner;
import com.vmware.common.samples.reflection.JarFileClassScanner;
import java.lang.annotation.Annotation;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class SmartClassFinder
implements ClassFinder {
    public static final String JAR_URL_SUFFIX = ".jar";
    public static final String CLASS_FILE_SUFFIX = ".class";
    URLClassLoader urlClassLoader;
    final ClassScanner jar;
    final ClassScanner dir;
    final String rootPackage;

    public SmartClassFinder(URLClassLoader classLoader, String rootPackage) {
        this.urlClassLoader = classLoader;
        this.jar = new JarFileClassScanner(CLASS_FILE_SUFFIX);
        this.dir = new DirectoryClassScanner(CLASS_FILE_SUFFIX);
        this.rootPackage = rootPackage != null ? rootPackage : "";
    }

    @Override
    public Collection<String> getClassNames() {
        URL[] urls;
        HashSet<String> classNames = new HashSet<String>();
        for (URL url : urls = this.urlClassLoader.getURLs()) {
            if (url.toString().endsWith(JAR_URL_SUFFIX)) {
                classNames.addAll(this.jar.scan(url));
                continue;
            }
            if (!DirectoryClassScanner.file(url).isDirectory()) continue;
            classNames.addAll(this.dir.scan(url));
        }
        return this.filter(classNames);
    }

    public Collection<String> filter(Set<String> classNames) {
        if ("".equals(this.rootPackage)) {
            return classNames;
        }
        HashSet<String> out = new HashSet<String>();
        for (String name : classNames) {
            if (!name.startsWith(this.rootPackage)) continue;
            out.add(name);
        }
        return out;
    }

    @Override
    public Class<?>[] find(Collection<String> classNames, Class<? extends Annotation> annotation) {
        HashSet classes = new HashSet();
        for (String name : classNames) {
            try {
                Class<?> clazz = Class.forName(name, false, this.urlClassLoader);
                if (!clazz.isAnnotationPresent(annotation)) continue;
                classes.add(clazz);
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
            }
            catch (ClassNotFoundException classNotFoundException) {}
        }
        return classes.toArray(new Class[classes.size()]);
    }
}

