/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.sso.client.samples;

import com.rsa.names._2009._12.product.riat.wsdl.STSService;
import com.rsa.names._2009._12.product.riat.wsdl.STSServicePortType;
import com.vmware.sso.client.soaphandlers.HeaderHandlerResolver;
import com.vmware.sso.client.soaphandlers.SamlTokenExtractionHandler;
import com.vmware.sso.client.soaphandlers.TimeStampHandler;
import com.vmware.sso.client.soaphandlers.WsSecurityUserCertificateSignatureHandler;
import com.vmware.sso.client.utils.SecurityUtil;
import com.vmware.sso.client.utils.Utils;
import jakarta.xml.ws.BindingProvider;
import jakarta.xml.ws.handler.HandlerResolver;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.GregorianCalendar;
import java.util.Map;
import java.util.TimeZone;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSession;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.oasis_open.docs.ws_sx.ws_trust._200512.LifetimeType;
import org.oasis_open.docs.ws_sx.ws_trust._200512.RenewingType;
import org.oasis_open.docs.ws_sx.ws_trust._200512.RequestSecurityTokenType;
import org.oasis_open.docs.wss._2004._01.oasis_200401_wss_wssecurity_utility_1_0.AttributedDateTime;
import org.w3c.dom.Element;

public class AcquireHoKTokenBySolutionCertificateSample {
    public static Element getToken(String string, PrivateKey privateKey, X509Certificate x509Certificate) throws DatatypeConfigurationException {
        STSService sTSService = new STSService();
        HeaderHandlerResolver headerHandlerResolver = new HeaderHandlerResolver();
        headerHandlerResolver.addHandler(new TimeStampHandler());
        WsSecurityUserCertificateSignatureHandler wsSecurityUserCertificateSignatureHandler = new WsSecurityUserCertificateSignatureHandler(privateKey, x509Certificate);
        headerHandlerResolver.addHandler(wsSecurityUserCertificateSignatureHandler);
        SamlTokenExtractionHandler samlTokenExtractionHandler = new SamlTokenExtractionHandler();
        headerHandlerResolver.addHandler(samlTokenExtractionHandler);
        sTSService.setHandlerResolver((HandlerResolver)headerHandlerResolver);
        STSServicePortType sTSServicePortType = sTSService.getSTSServicePort();
        RequestSecurityTokenType requestSecurityTokenType = new RequestSecurityTokenType();
        LifetimeType lifetimeType = new LifetimeType();
        DatatypeFactory datatypeFactory = DatatypeFactory.newInstance();
        GregorianCalendar gregorianCalendar = new GregorianCalendar(TimeZone.getTimeZone("GMT"));
        XMLGregorianCalendar xMLGregorianCalendar = datatypeFactory.newXMLGregorianCalendar(gregorianCalendar);
        AttributedDateTime attributedDateTime = new AttributedDateTime();
        attributedDateTime.setValue(xMLGregorianCalendar.toXMLFormat());
        AttributedDateTime attributedDateTime2 = new AttributedDateTime();
        xMLGregorianCalendar.add(datatypeFactory.newDuration(1800000L));
        attributedDateTime2.setValue(xMLGregorianCalendar.toXMLFormat());
        lifetimeType.setCreated(attributedDateTime);
        lifetimeType.setExpires(attributedDateTime2);
        requestSecurityTokenType.setTokenType("urn:oasis:names:tc:SAML:2.0:assertion");
        requestSecurityTokenType.setRequestType("http://docs.oasis-open.org/ws-sx/ws-trust/200512/Issue");
        requestSecurityTokenType.setLifetime(lifetimeType);
        requestSecurityTokenType.setKeyType("http://docs.oasis-open.org/ws-sx/ws-trust/200512/PublicKey");
        requestSecurityTokenType.setSignatureAlgorithm("http://www.w3.org/2001/04/xmldsig-more#rsa-sha256");
        RenewingType renewingType = new RenewingType();
        renewingType.setAllow(Boolean.TRUE);
        renewingType.setOK(Boolean.FALSE);
        requestSecurityTokenType.setRenewing(renewingType);
        requestSecurityTokenType.setDelegatable(Boolean.valueOf(true));
        Map map = ((BindingProvider)sTSServicePortType).getRequestContext();
        map.put("jakarta.xml.ws.service.endpoint.address", string);
        sTSServicePortType.issue(requestSecurityTokenType);
        return samlTokenExtractionHandler.getToken();
    }

    private static void printUsage() {
        System.out.println("To load the key/certificate pair from individual files use:");
        System.out.println("  run.bat com.vmware.sso.client.samples.AcquireHoKTokenBySolutionCertificateSample [sso url] [path to key file] [path to certificate file]");
        System.out.println("*****OR*****");
        System.out.println("To load the key/certificate pair from a keystore use:");
        System.out.println("  run.bat com.vmware.sso.client.samples.AcquireHoKTokenBySolutionCertificateSample [sso url] [path to keystore file] [keystore password] [alias used in keystore]");
    }

    public static void main(String[] stringArray) throws DatatypeConfigurationException {
        if (stringArray.length < 3) {
            AcquireHoKTokenBySolutionCertificateSample.printUsage();
            return;
        }
        HostnameVerifier hostnameVerifier = new HostnameVerifier(){

            @Override
            public boolean verify(String string, SSLSession sSLSession) {
                return true;
            }
        };
        HttpsURLConnection.setDefaultHostnameVerifier(hostnameVerifier);
        Utils.trustAllHttpsCertificates();
        System.out.println("Aquiring a HoK token by using solution's private key and certificate");
        if (stringArray.length == 3) {
            SecurityUtil securityUtil = SecurityUtil.loadFromFiles(stringArray[1], stringArray[2]);
            Utils.printToken(AcquireHoKTokenBySolutionCertificateSample.getToken(stringArray[0], securityUtil.getPrivateKey(), securityUtil.getUserCert()));
        } else {
            SecurityUtil securityUtil = SecurityUtil.loadFromKeystore(stringArray[1], stringArray[2], stringArray[3]);
            Utils.printToken(AcquireHoKTokenBySolutionCertificateSample.getToken(stringArray[0], securityUtil.getPrivateKey(), securityUtil.getUserCert()));
        }
    }
}

