/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.sso.client.soaphandlers;

import com.vmware.sso.client.soaphandlers.SSOHeaderHandler;
import com.vmware.sso.client.utils.Utils;
import jakarta.xml.soap.SOAPException;
import jakarta.xml.ws.handler.soap.SOAPMessageContext;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;

public class SamlTokenHandler
extends SSOHeaderHandler {
    private final Node token;

    public SamlTokenHandler(Node node) {
        if (!Utils.isSamlToken(node)) {
            throw new IllegalArgumentException("Token provided is not a SAML token");
        }
        this.token = node;
    }

    public boolean handleMessage(SOAPMessageContext sOAPMessageContext) {
        if (Utils.isOutgoingMessage(sOAPMessageContext)) {
            try {
                Node node = Utils.getSecurityElement(Utils.getSOAPHeader(sOAPMessageContext));
                node.appendChild(node.getOwnerDocument().importNode(this.token, true));
            }
            catch (DOMException dOMException) {
                dOMException.printStackTrace();
                throw new RuntimeException(dOMException);
            }
            catch (SOAPException sOAPException) {
                sOAPException.printStackTrace();
                throw new RuntimeException(sOAPException);
            }
        }
        return true;
    }
}

