/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.connection;

import com.vmware.connection.Connection;
import com.vmware.connection.ConnectionException;
import com.vmware.connection.ConnectionMalformedUrlException;
import com.vmware.vim25.InvalidLocaleFaultMsg;
import com.vmware.vim25.InvalidLoginFaultMsg;
import com.vmware.vim25.ManagedObjectReference;
import com.vmware.vim25.RuntimeFaultFaultMsg;
import com.vmware.vim25.ServiceContent;
import com.vmware.vim25.UserSession;
import com.vmware.vim25.VimPortType;
import com.vmware.vim25.VimService;
import jakarta.xml.ws.BindingProvider;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;
import java.util.Map;

public class BasicConnection
implements Connection {
    private VimService vimService;
    private VimPortType vimPort;
    private ServiceContent serviceContent;
    private UserSession userSession;
    private ManagedObjectReference svcInstRef;
    private URL url;
    private String username;
    private String password = "";
    private Map headers;

    @Override
    public void setUrl(String string) {
        try {
            this.url = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            throw new ConnectionMalformedUrlException("malformed URL argument: '" + string + "'", malformedURLException);
        }
    }

    @Override
    public String getUrl() {
        return this.url.toString();
    }

    @Override
    public String getHost() {
        return this.url.getHost();
    }

    @Override
    public Integer getPort() {
        int n = this.url.getPort();
        return n;
    }

    @Override
    public void setUsername(String string) {
        this.username = string;
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    @Override
    public void setPassword(String string) {
        this.password = string;
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    @Override
    public VimService getVimService() {
        return this.vimService;
    }

    @Override
    public VimPortType getVimPort() {
        return this.vimPort;
    }

    @Override
    public ServiceContent getServiceContent() {
        return this.serviceContent;
    }

    @Override
    public UserSession getUserSession() {
        return this.userSession;
    }

    @Override
    public String getServiceInstanceName() {
        return "ServiceInstance";
    }

    @Override
    public Map getHeaders() {
        return this.headers;
    }

    @Override
    public ManagedObjectReference getServiceInstanceReference() {
        if (this.svcInstRef == null) {
            ManagedObjectReference managedObjectReference = new ManagedObjectReference();
            managedObjectReference.setType(this.getServiceInstanceName());
            managedObjectReference.setValue(this.getServiceInstanceName());
            this.svcInstRef = managedObjectReference;
        }
        return this.svcInstRef;
    }

    @Override
    public Connection connect() {
        if (!this.isConnected()) {
            try {
                this._connect();
            }
            catch (Exception exception) {
                Throwable throwable = exception.getCause() != null ? exception.getCause() : exception;
                throw new BasicConnectionException("failed to connect: " + exception.getMessage() + " : " + throwable.getMessage(), throwable);
            }
        }
        return this;
    }

    private void _connect() throws RuntimeFaultFaultMsg, InvalidLocaleFaultMsg, InvalidLoginFaultMsg {
        this.vimService = new VimService();
        this.vimPort = this.vimService.getVimPort();
        Map map = ((BindingProvider)this.vimPort).getRequestContext();
        map.put("jakarta.xml.ws.service.endpoint.address", this.url.toString());
        map.put("jakarta.xml.ws.session.maintain", true);
        this.serviceContent = this.vimPort.retrieveServiceContent(this.getServiceInstanceReference());
        this.userSession = this.vimPort.login(this.serviceContent.getSessionManager(), this.username, this.password, null);
        this.headers = (Map)((BindingProvider)this.vimPort).getResponseContext().get("jakarta.xml.ws.http.response.headers");
    }

    @Override
    public boolean isConnected() {
        if (this.userSession == null) {
            return false;
        }
        long l = this.userSession.getLastActiveTime().toGregorianCalendar().getTime().getTime();
        return new Date().getTime() < l + 1800000L;
    }

    @Override
    public Connection disconnect() {
        if (this.isConnected()) {
            try {
                this.vimPort.logout(this.serviceContent.getSessionManager());
            }
            catch (Exception exception) {
                Throwable throwable = exception.getCause();
                throw new BasicConnectionException("failed to disconnect properly: " + exception.getMessage() + " : " + throwable.getMessage(), throwable);
            }
            finally {
                this.userSession = null;
                this.serviceContent = null;
                this.vimPort = null;
                this.vimService = null;
            }
        }
        return this;
    }

    @Override
    public URL getURL() {
        return this.url;
    }

    private class BasicConnectionException
    extends ConnectionException {
        private static final long serialVersionUID = 1L;

        public BasicConnectionException(String string, Throwable throwable) {
            super(string, throwable);
        }
    }
}

