/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.fcd;

import com.vmware.common.annotations.Action;
import com.vmware.common.annotations.Option;
import com.vmware.common.annotations.Sample;
import com.vmware.connection.ConnectedVimServiceBase;
import com.vmware.fcd.helpers.FcdHelper;
import com.vmware.vim25.DeviceUnsupportedForVmVersionFaultMsg;
import com.vmware.vim25.FileFaultFaultMsg;
import com.vmware.vim25.ID;
import com.vmware.vim25.InvalidCollectorVersionFaultMsg;
import com.vmware.vim25.InvalidControllerFaultMsg;
import com.vmware.vim25.InvalidDatastoreFaultMsg;
import com.vmware.vim25.InvalidPropertyFaultMsg;
import com.vmware.vim25.InvalidStateFaultMsg;
import com.vmware.vim25.LocalizedMethodFault;
import com.vmware.vim25.ManagedObjectReference;
import com.vmware.vim25.MissingControllerFaultMsg;
import com.vmware.vim25.NotFoundFaultMsg;
import com.vmware.vim25.RuntimeFaultFaultMsg;
import com.vmware.vim25.TaskInfoState;
import com.vmware.vim25.VStorageObject;
import com.vmware.vim25.VmConfigFaultFaultMsg;

@Sample(name="fcd-attachtovm", description="This sample attaches a given virtual storage object(FCD) to the given virtual machine.")
public class FcdAttachToVM
extends ConnectedVimServiceBase {
    private String vStorageObjectId;
    private String datastoreName;
    private String vmName;
    private Integer controllerKey;
    private Integer unitNumber;

    @Option(name="vstorageobjectid", required=true, description="Uuid of the disk.")
    public void setVStorageObjectId(String string) {
        this.vStorageObjectId = string;
    }

    @Option(name="datastorename", required=true, description="Name of datastore containing the vstorageobject.")
    public void setDatastoreName(String string) {
        this.datastoreName = string;
    }

    @Option(name="vmname", required=true, description="Name of virtual machine.")
    public void setVmName(String string) {
        this.vmName = string;
    }

    @Option(name="controllerkey", required=false, description="Device Key of the controller.")
    public void setControllerKey(String string) {
        this.controllerKey = Integer.parseInt(string);
    }

    @Option(name="unitnumber", required=false, description="Unit number of the virtual machine.")
    public void setUnitNumber(String string) {
        this.unitNumber = Integer.parseInt(string);
    }

    boolean getTaskResultAfterDone(ManagedObjectReference managedObjectReference) throws InvalidPropertyFaultMsg, RuntimeFaultFaultMsg, InvalidCollectorVersionFaultMsg {
        boolean bl = false;
        Object[] objectArray = this.waitForValues.wait(managedObjectReference, new String[]{"info.state", "info.error"}, new String[]{"state"}, new Object[][]{{TaskInfoState.SUCCESS, TaskInfoState.ERROR}});
        if (objectArray[0].equals(TaskInfoState.SUCCESS)) {
            bl = true;
        }
        if (objectArray[1] instanceof LocalizedMethodFault) {
            throw new RuntimeException(((LocalizedMethodFault)objectArray[1]).getLocalizedMessage());
        }
        return bl;
    }

    void attachDiskToVM() throws InvalidPropertyFaultMsg, RuntimeFaultFaultMsg, FileFaultFaultMsg, InvalidDatastoreFaultMsg, NotFoundFaultMsg, InvalidControllerFaultMsg, InvalidStateFaultMsg, MissingControllerFaultMsg, VmConfigFaultFaultMsg, InvalidCollectorVersionFaultMsg, DeviceUnsupportedForVmVersionFaultMsg {
        ManagedObjectReference managedObjectReference = this.connection.getServiceContent().getVStorageObjectManager();
        ManagedObjectReference managedObjectReference2 = this.connection.getServiceContent().getPropertyCollector();
        ManagedObjectReference managedObjectReference3 = this.getMOREFs.vmByVMname(this.vmName, managedObjectReference2);
        ManagedObjectReference managedObjectReference4 = this.getMOREFs.inContainerByType(this.serviceContent.getRootFolder(), "Datastore").get(this.datastoreName);
        System.out.println("Operation: Retrieving a vStorageObject");
        VStorageObject vStorageObject = this.vimPort.retrieveVStorageObject(managedObjectReference, FcdHelper.makeId(this.vStorageObjectId), managedObjectReference4, null);
        System.out.println("Success: Retrieved vStorageObject ::" + this.vStorageObjectId);
        System.out.println("Operation:  Attaching a given vStorageObject to the given virtualMachine.");
        ManagedObjectReference managedObjectReference5 = this.vimPort.attachDiskTask(managedObjectReference3, FcdHelper.makeId(this.vStorageObjectId), managedObjectReference4, this.controllerKey, this.unitNumber);
        if (!this.getTaskResultAfterDone(managedObjectReference5)) {
            String string = "Error: Attaching [ " + this.vStorageObjectId + " ] to the VM [ " + this.vmName + " ] failed.";
            throw new RuntimeException(string);
        }
        System.out.printf("Success: Attached vStorageObjectId : [ Name = %s , Id = %s ] to VM [ Name = %s ]%n", vStorageObject.getConfig().getName(), vStorageObject.getConfig().getId().getId(), this.vmName);
        System.out.println("Operation: Retrieve the vStorageObjects in datastore.");
        VStorageObject vStorageObject2 = this.connection.getVimPort().retrieveVStorageObject(managedObjectReference, FcdHelper.makeId(this.vStorageObjectId), managedObjectReference4, null);
        if (vStorageObject2.getConfig().getId().getId().equals(this.vStorageObjectId)) {
            if (vStorageObject2.getConfig().getConsumerId().get(0) == null) {
                String string = "Error: Given vStorageObject [ " + this.vStorageObjectId + "] does not have a consumer attached to it.";
                throw new RuntimeException(string);
            }
        } else {
            String string = "Error: Given vStorageObject [ " + this.vStorageObjectId + "] and retrieved VStorageObject are different.";
            throw new RuntimeException(string);
        }
        System.out.printf("Success: Retrieved vStorageObject :: %n [ Uuid = %s ] is associated with consumer [ ConsumerId = %s ]%n", vStorageObject2.getConfig().getId().getId(), ((ID)vStorageObject2.getConfig().getConsumerId().get(0)).getId());
    }

    @Action
    public void run() throws InvalidPropertyFaultMsg, RuntimeFaultFaultMsg, FileFaultFaultMsg, InvalidDatastoreFaultMsg, NotFoundFaultMsg, InvalidControllerFaultMsg, InvalidStateFaultMsg, MissingControllerFaultMsg, VmConfigFaultFaultMsg, InvalidCollectorVersionFaultMsg, DeviceUnsupportedForVmVersionFaultMsg {
        this.attachDiskToVM();
    }
}

