/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.fcd;

import com.vmware.common.annotations.Action;
import com.vmware.common.annotations.Before;
import com.vmware.common.annotations.Option;
import com.vmware.common.annotations.Sample;
import com.vmware.connection.ConnectedVimServiceBase;
import com.vmware.fcd.helpers.FcdHelper;
import com.vmware.vim25.BaseConfigInfoDiskFileBackingInfoProvisioningType;
import com.vmware.vim25.FileFaultFaultMsg;
import com.vmware.vim25.HostScsiDisk;
import com.vmware.vim25.InvalidCollectorVersionFaultMsg;
import com.vmware.vim25.InvalidDatastoreFaultMsg;
import com.vmware.vim25.InvalidPropertyFaultMsg;
import com.vmware.vim25.LocalizedMethodFault;
import com.vmware.vim25.ManagedObjectReference;
import com.vmware.vim25.NotFoundFaultMsg;
import com.vmware.vim25.RuntimeFaultFaultMsg;
import com.vmware.vim25.TaskInfoState;
import com.vmware.vim25.VStorageObject;
import com.vmware.vim25.VirtualDiskCompatibilityMode;
import com.vmware.vim25.VslmCloneSpec;
import com.vmware.vim25.VslmCreateSpecBackingSpec;
import com.vmware.vim25.VslmCreateSpecDiskFileBackingSpec;
import com.vmware.vim25.VslmCreateSpecRawDiskMappingBackingSpec;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Sample(name="fcd-clone", description="This sample clones a virtual storage object.")
public class FcdClone
extends ConnectedVimServiceBase {
    private String vStorageObjectId;
    private String datastoreName;
    private String destDatastoreName;
    private String clonedDiskName;
    private String provisioningType = "thin";
    private HostScsiDisk hostScsiDisk = null;
    private final Map<String, DiskProvisioningTypes> provisioningTypeHashMap = new HashMap<String, DiskProvisioningTypes>();

    @Before
    public void init() {
        this.provisioningTypeHashMap.put("thin", DiskProvisioningTypes.THIN);
        this.provisioningTypeHashMap.put("eagerzeroedthick", DiskProvisioningTypes.EAGER_ZEROED_THICK);
        this.provisioningTypeHashMap.put("lazyzeroedthick", DiskProvisioningTypes.LAZY_ZEROED_THICK);
        this.provisioningTypeHashMap.put("virtualmode", DiskProvisioningTypes.VIRTUAL_MODE);
        this.provisioningTypeHashMap.put("physicalmode", DiskProvisioningTypes.PHYSICAL_MODE);
    }

    @Option(name="vstorageobjectid", required=true, description="Uuid of the vstorageobject.")
    public void setVStorageObjectId(String string) {
        this.vStorageObjectId = string;
    }

    @Option(name="datastorename", required=true, description="Name of datastore containing the vstorageobject.")
    public void setDatastoreName(String string) {
        this.datastoreName = string;
    }

    @Option(name="destdatastoredame", required=true, description="Name of destination datastore.")
    public void setDestDatastoreName(String string) {
        this.destDatastoreName = string;
    }

    @Option(name="cloneddiskname", required=true, description="Name of the cloned Disk.")
    public void setVStorageObjectName(String string) {
        this.clonedDiskName = string;
    }

    @Option(name="provisioningtype", required=false, description="Provisioning Type of the Disk.\n [thin | eagerZeroedThick | lazyZeroedThick | virtualMode | physicalMode]")
    public void setProvisioningType(String string) {
        this.provisioningType = string;
    }

    @Option(name="hostscsidisk", required=false, description="Uuid of the vstorageobject.")
    public void setHostScsiDisk(HostScsiDisk hostScsiDisk) {
        this.hostScsiDisk = hostScsiDisk;
    }

    boolean getTaskResultAfterDone(ManagedObjectReference managedObjectReference) throws InvalidPropertyFaultMsg, RuntimeFaultFaultMsg, InvalidCollectorVersionFaultMsg {
        boolean bl = false;
        Object[] objectArray = this.waitForValues.wait(managedObjectReference, new String[]{"info.state", "info.error"}, new String[]{"state"}, new Object[][]{{TaskInfoState.SUCCESS, TaskInfoState.ERROR}});
        if (objectArray[0].equals(TaskInfoState.SUCCESS)) {
            bl = true;
        }
        if (objectArray[1] instanceof LocalizedMethodFault) {
            throw new RuntimeException(((LocalizedMethodFault)objectArray[1]).getLocalizedMessage());
        }
        return bl;
    }

    void cloneVStorageObject() throws InvalidPropertyFaultMsg, RuntimeFaultFaultMsg, FileFaultFaultMsg, InvalidDatastoreFaultMsg, NotFoundFaultMsg, InvalidCollectorVersionFaultMsg {
        ManagedObjectReference managedObjectReference = this.connection.getServiceContent().getVStorageObjectManager();
        DiskProvisioningTypes diskProvisioningTypes = this.provisioningTypeHashMap.get(this.provisioningType.trim().toLowerCase());
        if (diskProvisioningTypes == null) {
            throw new RuntimeException("The input provisioning Type is not valid.");
        }
        ManagedObjectReference managedObjectReference2 = this.getMOREFs.inContainerByType(this.serviceContent.getRootFolder(), "Datastore").get(this.datastoreName);
        if (managedObjectReference2 == null) {
            throw new RuntimeException("The datastore name is not valid.");
        }
        ManagedObjectReference managedObjectReference3 = this.getMOREFs.inContainerByType(this.serviceContent.getRootFolder(), "Datastore").get(this.destDatastoreName);
        if (managedObjectReference3 == null) {
            throw new RuntimeException("The datastore name is not valid.");
        }
        VslmCloneSpec vslmCloneSpec = this.generateVslmCloneSpec(managedObjectReference3, diskProvisioningTypes);
        System.out.println("Operation: Cloning a vStorageObject from vc.");
        ManagedObjectReference managedObjectReference4 = this.vimPort.cloneVStorageObjectTask(managedObjectReference, FcdHelper.makeId(this.vStorageObjectId), managedObjectReference2, vslmCloneSpec);
        VStorageObject vStorageObject = null;
        if (!this.getTaskResultAfterDone(managedObjectReference4)) {
            String string = "Error: Cloning [ " + FcdHelper.makeId(this.vStorageObjectId) + "] vStorageObject from vc.";
            throw new RuntimeException(string);
        }
        vStorageObject = (VStorageObject)this.getMOREFs.entityProps(managedObjectReference4, new String[]{"info.result"}).get("info.result");
        System.out.printf("Success: vStorageObject : [ Uuid = %s ] from datastore [ datastore = %s ]  cloned : [ Uuid = %s ] to [ datastore = %s ] from vc.%n", this.vStorageObjectId, managedObjectReference2, vStorageObject.getConfig().getId().getId(), managedObjectReference3);
        System.out.println("Operation: List all vStorageObjects in datastore from vc.");
        List list = this.vimPort.listVStorageObject(managedObjectReference, managedObjectReference3);
        if (!FcdHelper.isFcdIdInFcdList(Arrays.asList(vStorageObject.getConfig().getId().getId()), list)) {
            String string = "Error: Cloned VStorageObject [ " + vStorageObject.getConfig().getId().getId() + " ] is not present in the returned list from vc.";
            throw new RuntimeException(string);
        }
        System.out.printf("Success: listVStorageObject contains the cloned vStorageObjectId : [ %s ]%n", vStorageObject.getConfig().getId().getId());
        System.out.println("Operation: Retrieve the clonedVStorageObject in datastore from vc.");
        VStorageObject vStorageObject2 = this.vimPort.retrieveVStorageObject(managedObjectReference, vStorageObject.getConfig().getId(), managedObjectReference3, null);
        if (!vStorageObject2.getConfig().getId().getId().equals(vStorageObject.getConfig().getId().getId())) {
            String string = "Error: Cloned VStorageObject [ " + vStorageObject.getConfig().getId().getId() + " ] and retrieved VStorageObject are different from vc.";
            throw new RuntimeException(string);
        }
        System.out.printf("Success: Retrieved vStorageObject :: [ %s ] from vc.", vStorageObject2.getConfig().getId().getId());
    }

    public VslmCloneSpec generateVslmCloneSpec(ManagedObjectReference managedObjectReference, DiskProvisioningTypes diskProvisioningTypes) throws IllegalArgumentException {
        VslmCreateSpecRawDiskMappingBackingSpec vslmCreateSpecRawDiskMappingBackingSpec;
        VslmCreateSpecRawDiskMappingBackingSpec vslmCreateSpecRawDiskMappingBackingSpec2;
        System.out.println("Info :: Creating VslmCloneSpec with dsMor: " + managedObjectReference.getValue() + " provisioningType: " + diskProvisioningTypes.toString());
        if (diskProvisioningTypes != DiskProvisioningTypes.VIRTUAL_MODE && diskProvisioningTypes != DiskProvisioningTypes.PHYSICAL_MODE) {
            vslmCreateSpecRawDiskMappingBackingSpec2 = new VslmCreateSpecDiskFileBackingSpec();
            vslmCreateSpecRawDiskMappingBackingSpec2.setDatastore(managedObjectReference);
            vslmCreateSpecRawDiskMappingBackingSpec2.setProvisioningType(BaseConfigInfoDiskFileBackingInfoProvisioningType.valueOf((String)diskProvisioningTypes.toString()).value());
            vslmCreateSpecRawDiskMappingBackingSpec = vslmCreateSpecRawDiskMappingBackingSpec2;
        } else {
            vslmCreateSpecRawDiskMappingBackingSpec2 = new VslmCreateSpecRawDiskMappingBackingSpec();
            vslmCreateSpecRawDiskMappingBackingSpec2.setDatastore(managedObjectReference);
            vslmCreateSpecRawDiskMappingBackingSpec2.setCompatibilityMode(VirtualDiskCompatibilityMode.valueOf((String)diskProvisioningTypes.toString()).value());
            vslmCreateSpecRawDiskMappingBackingSpec2.setLunUuid(this.hostScsiDisk.getUuid());
            vslmCreateSpecRawDiskMappingBackingSpec = vslmCreateSpecRawDiskMappingBackingSpec2;
        }
        vslmCreateSpecRawDiskMappingBackingSpec2 = new VslmCloneSpec();
        vslmCreateSpecRawDiskMappingBackingSpec2.setBackingSpec((VslmCreateSpecBackingSpec)vslmCreateSpecRawDiskMappingBackingSpec);
        vslmCreateSpecRawDiskMappingBackingSpec2.setName(this.clonedDiskName);
        return vslmCreateSpecRawDiskMappingBackingSpec2;
    }

    @Action
    public void run() throws InvalidPropertyFaultMsg, RuntimeFaultFaultMsg, FileFaultFaultMsg, InvalidDatastoreFaultMsg, NotFoundFaultMsg, InvalidCollectorVersionFaultMsg {
        this.init();
        this.cloneVStorageObject();
    }

    private static enum DiskProvisioningTypes {
        THIN("thin"),
        EAGER_ZEROED_THICK("eagerZeroedThick"),
        LAZY_ZEROED_THICK("lazyZeroedThick"),
        VIRTUAL_MODE("virtualMode"),
        PHYSICAL_MODE("physicalMode");

        private final String value;

        private DiskProvisioningTypes(String string2) {
            this.value = string2;
        }

        public String value() {
            return this.value;
        }
    }
}

