/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.fcd;

import com.vmware.common.annotations.Action;
import com.vmware.common.annotations.Before;
import com.vmware.common.annotations.Option;
import com.vmware.common.annotations.Sample;
import com.vmware.connection.ConnectedVimServiceBase;
import com.vmware.vim25.BaseConfigInfoBackingInfo;
import com.vmware.vim25.BaseConfigInfoDiskFileBackingInfoProvisioningType;
import com.vmware.vim25.BaseConfigInfoFileBackingInfo;
import com.vmware.vim25.FileFaultFaultMsg;
import com.vmware.vim25.ID;
import com.vmware.vim25.InvalidCollectorVersionFaultMsg;
import com.vmware.vim25.InvalidDatastoreFaultMsg;
import com.vmware.vim25.InvalidPropertyFaultMsg;
import com.vmware.vim25.LocalizedMethodFault;
import com.vmware.vim25.ManagedObjectReference;
import com.vmware.vim25.NotFoundFaultMsg;
import com.vmware.vim25.RuntimeFaultFaultMsg;
import com.vmware.vim25.TaskInfoState;
import com.vmware.vim25.VStorageObject;
import com.vmware.vim25.VirtualDiskCompatibilityMode;
import com.vmware.vim25.VslmCreateSpec;
import com.vmware.vim25.VslmCreateSpecBackingSpec;
import com.vmware.vim25.VslmCreateSpecDiskFileBackingSpec;
import com.vmware.vim25.VslmCreateSpecRawDiskMappingBackingSpec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Sample(name="fcd-create", description="This sample creates a virtual storage object(FCD).")
public class FcdCreate
extends ConnectedVimServiceBase {
    private String vStorageObjectName;
    private String datastoreName;
    private long vStorageObjectSizeInMB;
    private String provisioningType = "thin";
    private String deviceName;
    private final Map<String, DiskProvisioningTypes> provisioningTypeHashMap = new HashMap<String, DiskProvisioningTypes>();

    @Option(name="vstorageobjectname", required=true, description="Name of the Disk.")
    public void setVStorageObjectName(String string) {
        this.vStorageObjectName = string;
    }

    @Option(name="datastorename", required=true, description="Name of datastore.")
    public void setDatastoreName(String string) {
        this.datastoreName = string;
    }

    @Option(name="vstorageobjectsizeinMB", required=true, description="Size of the Disk (in MB)")
    public void setVStorageObjectSize(long l) {
        this.vStorageObjectSizeInMB = l;
    }

    @Option(name="provisioningtype", required=false, description="Provisioning Type of the Disk.\n [thin | eagerZeroedThick | lazyZeroedThick | virtualMode | physicalMode]")
    public void setProvisioningType(String string) {
        this.provisioningType = string;
    }

    @Option(name="devicename", required=false, description="Canonical name of the LUN to use for RDM provisioning type.")
    public void setDeviceName(String string) {
        this.deviceName = string;
    }

    @Before
    public void init() {
        this.provisioningTypeHashMap.put("thin", DiskProvisioningTypes.THIN);
        this.provisioningTypeHashMap.put("eagerzeroedthick", DiskProvisioningTypes.EAGER_ZEROED_THICK);
        this.provisioningTypeHashMap.put("lazyzeroedthick", DiskProvisioningTypes.LAZY_ZEROED_THICK);
        this.provisioningTypeHashMap.put("virtualmode", DiskProvisioningTypes.VIRTUAL_MODE);
        this.provisioningTypeHashMap.put("physicalmode", DiskProvisioningTypes.PHYSICAL_MODE);
    }

    boolean getTaskResultAfterDone(ManagedObjectReference managedObjectReference) throws InvalidPropertyFaultMsg, RuntimeFaultFaultMsg, InvalidCollectorVersionFaultMsg {
        boolean bl = false;
        Object[] objectArray = this.waitForValues.wait(managedObjectReference, new String[]{"info.state", "info.error"}, new String[]{"state"}, new Object[][]{{TaskInfoState.SUCCESS, TaskInfoState.ERROR}});
        if (objectArray[0].equals(TaskInfoState.SUCCESS)) {
            bl = true;
        }
        if (objectArray[1] instanceof LocalizedMethodFault) {
            throw new RuntimeException(((LocalizedMethodFault)objectArray[1]).getLocalizedMessage());
        }
        return bl;
    }

    void createVStorageObject() throws IllegalArgumentException, FileFaultFaultMsg, InvalidDatastoreFaultMsg, RuntimeFaultFaultMsg, InvalidPropertyFaultMsg, InvalidCollectorVersionFaultMsg, NotFoundFaultMsg {
        ManagedObjectReference managedObjectReference = this.connection.getServiceContent().getVStorageObjectManager();
        DiskProvisioningTypes diskProvisioningTypes = this.provisioningTypeHashMap.get(this.provisioningType.trim().toLowerCase());
        if (diskProvisioningTypes == null) {
            throw new RuntimeException("The input provisioning Type is not valid.");
        }
        ManagedObjectReference managedObjectReference2 = this.getMOREFs.inContainerByType(this.serviceContent.getRootFolder(), "Datastore").get(this.datastoreName);
        if (managedObjectReference2 == null) {
            throw new RuntimeException("The datastore name is not valid.");
        }
        VslmCreateSpec vslmCreateSpec = this.generateVslmCreateSpec(managedObjectReference2, diskProvisioningTypes);
        System.out.println("Operation: Creating a vStorageObject");
        ManagedObjectReference managedObjectReference3 = this.vimPort.createDiskTask(managedObjectReference, vslmCreateSpec);
        VStorageObject vStorageObject = null;
        if (!this.getTaskResultAfterDone(managedObjectReference3)) {
            String string = "Error: Creating [ " + this.vStorageObjectName + "] vStorageObject";
            throw new RuntimeException(string);
        }
        vStorageObject = (VStorageObject)this.getMOREFs.entityProps(managedObjectReference3, new String[]{"info.result"}).get("info.result");
        System.out.printf("Success: Created vStorageObject :  %n [ Name = %s ] %n [ Uuid = %s ] %n [ DatastorePath = %s ]%n", vStorageObject.getConfig().getName(), vStorageObject.getConfig().getId().getId(), FcdCreate.getFcdFilePath(vStorageObject));
        System.out.println("Operation: List all vStorageObjects in datastore.");
        List list = this.vimPort.listVStorageObject(managedObjectReference, managedObjectReference2);
        if (!FcdCreate.isFcdIdInFcdList(Arrays.asList(vStorageObject.getConfig().getId().getId()), list)) {
            String string = "Error: Created VStorageObject [ " + vStorageObject.getConfig().getId().getId() + "] is not present in the returned list from vc.";
            throw new RuntimeException(string);
        }
        System.out.printf("Success: listVStorageObject contains the created vStorageObjectId : %n [ %s ]%n", vStorageObject.getConfig().getId().getId());
        System.out.println("Operation: Retrieve the  createdVStorageObjects in datastore.");
        VStorageObject vStorageObject2 = this.vimPort.retrieveVStorageObject(managedObjectReference, vStorageObject.getConfig().getId(), managedObjectReference2, null);
        if (!vStorageObject2.getConfig().getId().getId().equals(vStorageObject.getConfig().getId().getId())) {
            String string = "Error: Created VStorageObject [ " + vStorageObject.getConfig().getId().getId() + "] and retrieved VStorageObject are different.";
            throw new RuntimeException(string);
        }
        System.out.printf("Success: Retrieved vStorageObject :: %n [ %s ]%n", vStorageObject2.getConfig().getId().getId());
    }

    public static boolean isFcdIdInFcdList(List<String> list, List<ID> list2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (ID iD : list2) {
            arrayList.add(iD.getId());
        }
        return arrayList.containsAll(list);
    }

    public VslmCreateSpec generateVslmCreateSpec(ManagedObjectReference managedObjectReference, DiskProvisioningTypes diskProvisioningTypes) throws IllegalArgumentException {
        VslmCreateSpecDiskFileBackingSpec vslmCreateSpecDiskFileBackingSpec;
        VslmCreateSpecDiskFileBackingSpec vslmCreateSpecDiskFileBackingSpec2;
        System.out.println("Info :: Creating VslmCreateSpec with dsMor: " + managedObjectReference.getValue() + " provisioningType:" + diskProvisioningTypes.toString());
        if (diskProvisioningTypes != DiskProvisioningTypes.VIRTUAL_MODE && diskProvisioningTypes != DiskProvisioningTypes.PHYSICAL_MODE) {
            vslmCreateSpecDiskFileBackingSpec2 = new VslmCreateSpecDiskFileBackingSpec();
            vslmCreateSpecDiskFileBackingSpec2.setDatastore(managedObjectReference);
            vslmCreateSpecDiskFileBackingSpec2.setProvisioningType(BaseConfigInfoDiskFileBackingInfoProvisioningType.valueOf((String)diskProvisioningTypes.toString()).value());
            vslmCreateSpecDiskFileBackingSpec = vslmCreateSpecDiskFileBackingSpec2;
        } else {
            if (this.deviceName == null || this.deviceName.isEmpty()) {
                throw new IllegalArgumentException("The devicename is mandatory for specified disktype [ " + diskProvisioningTypes.value() + " ]");
            }
            vslmCreateSpecDiskFileBackingSpec2 = new VslmCreateSpecRawDiskMappingBackingSpec();
            vslmCreateSpecDiskFileBackingSpec2.setDatastore(managedObjectReference);
            vslmCreateSpecDiskFileBackingSpec2.setCompatibilityMode(VirtualDiskCompatibilityMode.valueOf((String)diskProvisioningTypes.toString()).value());
            vslmCreateSpecDiskFileBackingSpec2.setLunUuid(this.deviceName);
            vslmCreateSpecDiskFileBackingSpec = vslmCreateSpecDiskFileBackingSpec2;
        }
        vslmCreateSpecDiskFileBackingSpec2 = new VslmCreateSpec();
        vslmCreateSpecDiskFileBackingSpec2.setBackingSpec((VslmCreateSpecBackingSpec)vslmCreateSpecDiskFileBackingSpec);
        vslmCreateSpecDiskFileBackingSpec2.setName(this.vStorageObjectName);
        vslmCreateSpecDiskFileBackingSpec2.setCapacityInMB(this.vStorageObjectSizeInMB);
        return vslmCreateSpecDiskFileBackingSpec2;
    }

    public static String getFcdFilePath(VStorageObject vStorageObject) {
        BaseConfigInfoBackingInfo baseConfigInfoBackingInfo = vStorageObject.getConfig().getBacking();
        if (baseConfigInfoBackingInfo instanceof BaseConfigInfoFileBackingInfo) {
            BaseConfigInfoFileBackingInfo baseConfigInfoFileBackingInfo = (BaseConfigInfoFileBackingInfo)baseConfigInfoBackingInfo;
            return baseConfigInfoFileBackingInfo.getFilePath();
        }
        return null;
    }

    @Action
    public void run() throws IllegalArgumentException, RuntimeException, FileFaultFaultMsg, InvalidDatastoreFaultMsg, RuntimeFaultFaultMsg, InvalidPropertyFaultMsg, InvalidCollectorVersionFaultMsg, NotFoundFaultMsg {
        this.init();
        this.createVStorageObject();
    }

    private static enum DiskProvisioningTypes {
        THIN("thin"),
        EAGER_ZEROED_THICK("eagerZeroedThick"),
        LAZY_ZEROED_THICK("lazyZeroedThick"),
        VIRTUAL_MODE("virtualMode"),
        PHYSICAL_MODE("physicalMode");

        private final String value;

        private DiskProvisioningTypes(String string2) {
            this.value = string2;
        }

        public String value() {
            return this.value;
        }
    }
}

