/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.fcd;

import com.vmware.common.annotations.Action;
import com.vmware.common.annotations.Option;
import com.vmware.common.annotations.Sample;
import com.vmware.connection.ConnectedVimServiceBase;
import com.vmware.fcd.helpers.FcdHelper;
import com.vmware.vim25.FileFaultFaultMsg;
import com.vmware.vim25.InvalidCollectorVersionFaultMsg;
import com.vmware.vim25.InvalidDatastoreFaultMsg;
import com.vmware.vim25.InvalidPropertyFaultMsg;
import com.vmware.vim25.InvalidStateFaultMsg;
import com.vmware.vim25.LocalizedMethodFault;
import com.vmware.vim25.ManagedObjectReference;
import com.vmware.vim25.NotFoundFaultMsg;
import com.vmware.vim25.RuntimeFaultFaultMsg;
import com.vmware.vim25.TaskInProgressFaultMsg;
import com.vmware.vim25.TaskInfoState;
import com.vmware.vim25.VStorageObject;

@Sample(name="fcd-extend", description="This sample extends a virtual storage object(FCD).")
public class FcdExtend
extends ConnectedVimServiceBase {
    private String vStorageObjectId;
    private String datastoreName;
    private long newCapacityInMB;

    @Option(name="vstorageobjectid", required=true, description="Uuid of the vstorageobject.")
    public void setVStorageObjectId(String string) {
        this.vStorageObjectId = string;
    }

    @Option(name="datastorename", required=true, description="Name of datastore.")
    public void setDatastoreName(String string) {
        this.datastoreName = string;
    }

    @Option(name="newcapacityinmb", required=true, description="The new capacity of the virtual disk in MB.")
    public void setNewCapacityInMB(long l) {
        this.newCapacityInMB = l;
    }

    boolean getTaskResultAfterDone(ManagedObjectReference managedObjectReference) throws InvalidPropertyFaultMsg, RuntimeFaultFaultMsg, InvalidCollectorVersionFaultMsg {
        boolean bl = false;
        Object[] objectArray = this.waitForValues.wait(managedObjectReference, new String[]{"info.state", "info.error"}, new String[]{"state"}, new Object[][]{{TaskInfoState.SUCCESS, TaskInfoState.ERROR}});
        if (objectArray[0].equals(TaskInfoState.SUCCESS)) {
            bl = true;
        }
        if (objectArray[1] instanceof LocalizedMethodFault) {
            throw new RuntimeException(((LocalizedMethodFault)objectArray[1]).getLocalizedMessage());
        }
        return bl;
    }

    void extendvStorageObjectCapacity() throws InvalidDatastoreFaultMsg, RuntimeFaultFaultMsg, InvalidPropertyFaultMsg, InvalidCollectorVersionFaultMsg, NotFoundFaultMsg, FileFaultFaultMsg, InvalidStateFaultMsg, TaskInProgressFaultMsg {
        ManagedObjectReference managedObjectReference = this.connection.getServiceContent().getVStorageObjectManager();
        ManagedObjectReference managedObjectReference2 = this.getMOREFs.inContainerByType(this.serviceContent.getRootFolder(), "Datastore").get(this.datastoreName);
        if (managedObjectReference2 == null) {
            throw new RuntimeException("The datastore name is not valid.");
        }
        System.out.println("Operation: Extending capacity of vStorageObject from vc.");
        ManagedObjectReference managedObjectReference3 = this.vimPort.extendDiskTask(managedObjectReference, FcdHelper.makeId(this.vStorageObjectId), managedObjectReference2, this.newCapacityInMB);
        if (!this.getTaskResultAfterDone(managedObjectReference3)) {
            String string = "Error: Extending vStorageObject [ " + FcdHelper.makeId(this.vStorageObjectId) + "] from vc.";
            throw new RuntimeException(string);
        }
        System.out.printf("Success: Extended vStorageObject : %n [ Uuid = %s ]%n [ NewCapacity = %s ]%n", this.vStorageObjectId, this.newCapacityInMB);
        System.out.println("Operation: Retrieve the extendedVStorageObject from datastore from vc.");
        VStorageObject vStorageObject = this.vimPort.retrieveVStorageObject(managedObjectReference, FcdHelper.makeId(this.vStorageObjectId), managedObjectReference2, null);
        if (vStorageObject == null) {
            String string = "Error: Retrieving VStorageObject [ " + this.vStorageObjectId + " ] from vc.";
            throw new RuntimeException(string);
        }
        System.out.printf("Success: Retrieved vStorageObject :: [ %s ] from vc.%n", vStorageObject.getConfig().getId().getId());
        if (vStorageObject.getConfig().getCapacityInMB() != this.newCapacityInMB) {
            String string = "Error: VStorageObject [ " + this.vStorageObjectId + " ] capcity extend failed from vc.";
            throw new RuntimeException(string);
        }
        System.out.println("Success: Extend vStorageObject capacity  :: [ " + vStorageObject.getConfig().getId().getId() + " ] from vc.");
    }

    @Action
    public void run() throws InvalidDatastoreFaultMsg, RuntimeFaultFaultMsg, InvalidPropertyFaultMsg, InvalidCollectorVersionFaultMsg, NotFoundFaultMsg, FileFaultFaultMsg, InvalidStateFaultMsg, TaskInProgressFaultMsg {
        this.extendvStorageObjectCapacity();
    }
}

