/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.fcd;

import com.vmware.common.annotations.Action;
import com.vmware.common.annotations.Before;
import com.vmware.common.annotations.Option;
import com.vmware.common.annotations.Sample;
import com.vmware.connection.ConnectedVimServiceBase;
import com.vmware.fcd.helpers.FcdHelper;
import com.vmware.vim25.BaseConfigInfoDiskFileBackingInfoProvisioningType;
import com.vmware.vim25.FileFaultFaultMsg;
import com.vmware.vim25.HostScsiDisk;
import com.vmware.vim25.InvalidCollectorVersionFaultMsg;
import com.vmware.vim25.InvalidDatastoreFaultMsg;
import com.vmware.vim25.InvalidPropertyFaultMsg;
import com.vmware.vim25.InvalidStateFaultMsg;
import com.vmware.vim25.LocalizedMethodFault;
import com.vmware.vim25.ManagedObjectReference;
import com.vmware.vim25.NotFoundFaultMsg;
import com.vmware.vim25.RuntimeFaultFaultMsg;
import com.vmware.vim25.TaskInfoState;
import com.vmware.vim25.VStorageObject;
import com.vmware.vim25.VirtualDiskCompatibilityMode;
import com.vmware.vim25.VslmCreateSpecBackingSpec;
import com.vmware.vim25.VslmCreateSpecDiskFileBackingSpec;
import com.vmware.vim25.VslmCreateSpecRawDiskMappingBackingSpec;
import com.vmware.vim25.VslmRelocateSpec;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Sample(name="fcd-relocate", description="This sample relocates a virtual storage object.")
public class FcdRelocate
extends ConnectedVimServiceBase {
    private String vStorageObjectId;
    private String datastoreName;
    private String destDatastoreName;
    private String provisioningType = "thin";
    private HostScsiDisk hostScsiDisk = null;
    private final Map<String, DiskProvisioningTypes> provisioningTypeHashMap = new HashMap<String, DiskProvisioningTypes>();

    @Before
    public void init() {
        this.provisioningTypeHashMap.put("thin", DiskProvisioningTypes.THIN);
        this.provisioningTypeHashMap.put("eagerzeroedthick", DiskProvisioningTypes.EAGER_ZEROED_THICK);
        this.provisioningTypeHashMap.put("lazyzeroedthick", DiskProvisioningTypes.LAZY_ZEROED_THICK);
        this.provisioningTypeHashMap.put("virtualmode", DiskProvisioningTypes.VIRTUAL_MODE);
        this.provisioningTypeHashMap.put("physicalmode", DiskProvisioningTypes.PHYSICAL_MODE);
    }

    @Option(name="vstorageobjectid", required=true, description="Uuid of the vstorageobject.")
    public void setVStorageObjectId(String string) {
        this.vStorageObjectId = string;
    }

    @Option(name="datastorename", required=true, description="Name of destination datastore for relocation.")
    public void setDatastoreName(String string) {
        this.datastoreName = string;
    }

    @Option(name="destdatastoredame", required=true, description="Name of destination datastore.")
    public void setDestDatastoreName(String string) {
        this.destDatastoreName = string;
    }

    @Option(name="provisioningtype", required=false, description="Provisioning Type of the Disk.\n [thin | eagerZeroedThick | lazyZeroedThick | virtualMode | physicalMode]")
    public void setProvisioningType(String string) {
        this.provisioningType = string;
    }

    @Option(name="hostScsiDisk", required=false, description="Uuid of the vstorageobject.")
    public void setHostScsiDisk(HostScsiDisk hostScsiDisk) {
        this.hostScsiDisk = hostScsiDisk;
    }

    boolean getTaskResultAfterDone(ManagedObjectReference managedObjectReference) throws InvalidPropertyFaultMsg, RuntimeFaultFaultMsg, InvalidCollectorVersionFaultMsg {
        boolean bl = false;
        Object[] objectArray = this.waitForValues.wait(managedObjectReference, new String[]{"info.state", "info.error"}, new String[]{"state"}, new Object[][]{{TaskInfoState.SUCCESS, TaskInfoState.ERROR}});
        if (objectArray[0].equals(TaskInfoState.SUCCESS)) {
            bl = true;
        }
        if (objectArray[1] instanceof LocalizedMethodFault) {
            throw new RuntimeException(((LocalizedMethodFault)objectArray[1]).getLocalizedMessage());
        }
        return bl;
    }

    void relocateVStorageObject() throws InvalidPropertyFaultMsg, RuntimeFaultFaultMsg, FileFaultFaultMsg, InvalidDatastoreFaultMsg, InvalidStateFaultMsg, NotFoundFaultMsg, InvalidCollectorVersionFaultMsg {
        ManagedObjectReference managedObjectReference = this.connection.getServiceContent().getVStorageObjectManager();
        DiskProvisioningTypes diskProvisioningTypes = this.provisioningTypeHashMap.get(this.provisioningType.trim().toLowerCase());
        if (diskProvisioningTypes == null) {
            throw new RuntimeException("The input provisioning Type is not valid.");
        }
        ManagedObjectReference managedObjectReference2 = this.getMOREFs.inContainerByType(this.serviceContent.getRootFolder(), "Datastore").get(this.datastoreName);
        if (managedObjectReference2 == null) {
            throw new RuntimeException("The datastore name is not valid.");
        }
        ManagedObjectReference managedObjectReference3 = this.getMOREFs.inContainerByType(this.serviceContent.getRootFolder(), "Datastore").get(this.destDatastoreName);
        if (managedObjectReference3 == null) {
            throw new RuntimeException("The datastore name is not valid.");
        }
        VslmRelocateSpec vslmRelocateSpec = this.generateVslmRelocateSpec(managedObjectReference3, diskProvisioningTypes);
        System.out.println("Operation: Relocating a vStorageObject from vc.");
        ManagedObjectReference managedObjectReference4 = this.vimPort.relocateVStorageObjectTask(managedObjectReference, FcdHelper.makeId(this.vStorageObjectId), managedObjectReference2, vslmRelocateSpec);
        VStorageObject vStorageObject = null;
        if (!this.getTaskResultAfterDone(managedObjectReference4)) {
            String string = "Error: Relocating [ " + FcdHelper.makeId(this.vStorageObjectId) + "] vStorageObject to [ datastore = %s ] from vc." + managedObjectReference2;
            throw new RuntimeException(string);
        }
        vStorageObject = (VStorageObject)this.getMOREFs.entityProps(managedObjectReference4, new String[]{"info.result"}).get("info.result");
        System.out.printf("Success: Relocated vStorageObject :  %n [ Name = %s ] %n [ Uuid = %s ] from source datastore %n [ datastore = %s ] %n to destination datastore [ datastore = %s ].%n", vStorageObject.getConfig().getName(), vStorageObject.getConfig().getId().getId(), managedObjectReference2.getValue(), managedObjectReference3.getValue());
        System.out.println("Operation: List all vStorageObjects in datastore from vc.");
        List list = this.vimPort.listVStorageObject(managedObjectReference, managedObjectReference3);
        if (!FcdHelper.isFcdIdInFcdList(Arrays.asList(vStorageObject.getConfig().getId().getId()), list)) {
            String string = "Error: Created VStorageObject [ " + vStorageObject.getConfig().getId().getId() + "] is not present in the returned list from vc.";
            throw new RuntimeException(string);
        }
        System.out.printf("Success: listVStorageObject contains the created vStorageObjectId : [ %s ] from vc.%n", vStorageObject.getConfig().getId().getId());
        System.out.println("Operation: Retrieve the  createdVStorageObjects in datastore from vc.");
        VStorageObject vStorageObject2 = this.vimPort.retrieveVStorageObject(managedObjectReference, vStorageObject.getConfig().getId(), managedObjectReference3, null);
        if (!vStorageObject2.getConfig().getId().getId().equals(vStorageObject.getConfig().getId().getId())) {
            String string = "Error: Created VStorageObject [ " + vStorageObject.getConfig().getId().getId() + " ] and retrieved VStorageObject are different from vc.";
            throw new RuntimeException(string);
        }
        System.out.printf("Success: Retrieved vStorageObject :: [ %s ] from vc.", vStorageObject2.getConfig().getId().getId());
    }

    public VslmRelocateSpec generateVslmRelocateSpec(ManagedObjectReference managedObjectReference, DiskProvisioningTypes diskProvisioningTypes) throws IllegalArgumentException {
        VslmCreateSpecRawDiskMappingBackingSpec vslmCreateSpecRawDiskMappingBackingSpec;
        VslmCreateSpecRawDiskMappingBackingSpec vslmCreateSpecRawDiskMappingBackingSpec2;
        System.out.println("Info :: Creating VslmCloneSpec with dsMor: " + managedObjectReference.getValue() + " provisioningType:" + diskProvisioningTypes.toString());
        if (diskProvisioningTypes != DiskProvisioningTypes.VIRTUAL_MODE && diskProvisioningTypes != DiskProvisioningTypes.PHYSICAL_MODE) {
            vslmCreateSpecRawDiskMappingBackingSpec2 = new VslmCreateSpecDiskFileBackingSpec();
            vslmCreateSpecRawDiskMappingBackingSpec2.setDatastore(managedObjectReference);
            vslmCreateSpecRawDiskMappingBackingSpec2.setProvisioningType(BaseConfigInfoDiskFileBackingInfoProvisioningType.valueOf((String)diskProvisioningTypes.toString()).value());
            vslmCreateSpecRawDiskMappingBackingSpec = vslmCreateSpecRawDiskMappingBackingSpec2;
        } else {
            vslmCreateSpecRawDiskMappingBackingSpec2 = new VslmCreateSpecRawDiskMappingBackingSpec();
            vslmCreateSpecRawDiskMappingBackingSpec2.setDatastore(managedObjectReference);
            vslmCreateSpecRawDiskMappingBackingSpec2.setCompatibilityMode(VirtualDiskCompatibilityMode.valueOf((String)diskProvisioningTypes.toString()).value());
            vslmCreateSpecRawDiskMappingBackingSpec2.setLunUuid(this.hostScsiDisk.getUuid());
            vslmCreateSpecRawDiskMappingBackingSpec = vslmCreateSpecRawDiskMappingBackingSpec2;
        }
        vslmCreateSpecRawDiskMappingBackingSpec2 = new VslmRelocateSpec();
        vslmCreateSpecRawDiskMappingBackingSpec2.setBackingSpec((VslmCreateSpecBackingSpec)vslmCreateSpecRawDiskMappingBackingSpec);
        return vslmCreateSpecRawDiskMappingBackingSpec2;
    }

    @Action
    public void run() throws InvalidPropertyFaultMsg, RuntimeFaultFaultMsg, FileFaultFaultMsg, InvalidDatastoreFaultMsg, InvalidStateFaultMsg, NotFoundFaultMsg, InvalidCollectorVersionFaultMsg {
        this.init();
        this.relocateVStorageObject();
    }

    private static enum DiskProvisioningTypes {
        THIN("thin"),
        EAGER_ZEROED_THICK("eagerZeroedThick"),
        LAZY_ZEROED_THICK("lazyZeroedThick"),
        VIRTUAL_MODE("virtualMode"),
        PHYSICAL_MODE("physicalMode");

        private final String value;

        private DiskProvisioningTypes(String string2) {
            this.value = string2;
        }

        public String value() {
            return this.value;
        }
    }
}

