/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.fcd;

import com.vmware.common.annotations.Action;
import com.vmware.common.annotations.Option;
import com.vmware.common.annotations.Sample;
import com.vmware.connection.ConnectedVimServiceBase;
import com.vmware.fcd.helpers.FcdHelper;
import com.vmware.vim25.FileFaultFaultMsg;
import com.vmware.vim25.InvalidDatastoreFaultMsg;
import com.vmware.vim25.InvalidPropertyFaultMsg;
import com.vmware.vim25.ManagedObjectReference;
import com.vmware.vim25.NotFoundFaultMsg;
import com.vmware.vim25.RuntimeFaultFaultMsg;
import com.vmware.vim25.VStorageObject;

@Sample(name="fcd-rename", description="This sample renames a virtual storage object.")
public class FcdRename
extends ConnectedVimServiceBase {
    private String vStorageObjectId;
    private String datastoreName;
    private String newVStorageObjectName;

    @Option(name="vstorageobjectid", required=true, description="Uuid of the vstorageobject.")
    public void setVStorageObjectId(String string) {
        this.vStorageObjectId = string;
    }

    @Option(name="datastorename", required=true, description="Name of datastore containing the  vstorageobject.")
    public void setDatastoreName(String string) {
        this.datastoreName = string;
    }

    @Option(name="newvstorageobjectname", required=true, description="The new name for the virtual storage object.")
    public void setNewVStorageObjectName(String string) {
        this.newVStorageObjectName = string;
    }

    void renameVStorageObject() throws InvalidPropertyFaultMsg, RuntimeFaultFaultMsg, FileFaultFaultMsg, InvalidDatastoreFaultMsg, NotFoundFaultMsg {
        ManagedObjectReference managedObjectReference = this.connection.getServiceContent().getVStorageObjectManager();
        ManagedObjectReference managedObjectReference2 = this.getMOREFs.inContainerByType(this.serviceContent.getRootFolder(), "Datastore").get(this.datastoreName);
        if (managedObjectReference2 == null) {
            throw new RuntimeException("The datastore name is not valid.");
        }
        System.out.println("Operation: Retrieve vStorageObject before renaming from datastore from vc.");
        VStorageObject vStorageObject = this.vimPort.retrieveVStorageObject(managedObjectReference, FcdHelper.makeId(this.vStorageObjectId), managedObjectReference2, null);
        if (vStorageObject == null) {
            String string = "Error: Retrieving VStorageObject [ " + FcdHelper.makeId(this.vStorageObjectId);
            throw new RuntimeException(string);
        }
        System.out.printf("Success: Retrieved vStorageObject :: %n [ UUid = %s ] %n [ name = %s ]%n ", vStorageObject.getConfig().getId().getId(), vStorageObject.getConfig().getName());
        System.out.println("Operation: Renaming the given vStorageObject from vc.");
        this.vimPort.renameVStorageObject(managedObjectReference, FcdHelper.makeId(this.vStorageObjectId), managedObjectReference2, this.newVStorageObjectName);
        System.out.println("Operation: Retrieve the vStorageObject after renaming from datastore from vc.");
        VStorageObject vStorageObject2 = this.vimPort.retrieveVStorageObject(managedObjectReference, FcdHelper.makeId(this.vStorageObjectId), managedObjectReference2, null);
        if (vStorageObject2 == null) {
            String string = "Error: Retrieving VStorageObject [ " + FcdHelper.makeId(this.vStorageObjectId);
            throw new RuntimeException(string);
        }
        System.out.printf("Success: Retrieved vStorageObject :: %n [ UUid = %s ]%n [ name = %s ] %n", vStorageObject2.getConfig().getId().getId(), vStorageObject2.getConfig().getName());
        if (!vStorageObject2.getConfig().getName().equals(this.newVStorageObjectName)) {
            String string = "Error: VStorageObject [ " + vStorageObject2.getConfig().getId().getId() + "] rename to [ " + this.newVStorageObjectName + " ] from vc";
            throw new RuntimeException(string);
        }
        System.out.printf("Success: Renamed vStorageObject :: [ %s ] from vc", vStorageObject2.getConfig().getId().getId());
    }

    @Action
    public void run() throws InvalidPropertyFaultMsg, RuntimeFaultFaultMsg, FileFaultFaultMsg, InvalidDatastoreFaultMsg, NotFoundFaultMsg {
        this.renameVStorageObject();
    }
}

