/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.fcd.helpers;

import com.vmware.vim25.BaseConfigInfoBackingInfo;
import com.vmware.vim25.BaseConfigInfoFileBackingInfo;
import com.vmware.vim25.DeviceGroupId;
import com.vmware.vim25.FaultDomainId;
import com.vmware.vim25.ID;
import com.vmware.vim25.ReplicationGroupId;
import com.vmware.vim25.ReplicationSpec;
import com.vmware.vim25.VStorageObject;
import com.vmware.vim25.VirtualMachineDefinedProfileSpec;
import com.vmware.vim25.VirtualMachineEmptyProfileSpec;
import com.vmware.vim25.VirtualMachineProfileSpec;
import java.util.ArrayList;
import java.util.List;

public class FcdHelper {
    public static ID makeId(String string) {
        ID iD = new ID();
        iD.setId(string);
        return iD;
    }

    public static List<VirtualMachineProfileSpec> generateVirtualMachineProfileSpec(String string, String string2, String string3) {
        ArrayList<VirtualMachineProfileSpec> arrayList = new ArrayList<VirtualMachineProfileSpec>();
        if (string == null && string2 == null && string3 == null) {
            arrayList.add((VirtualMachineProfileSpec)new VirtualMachineEmptyProfileSpec());
        } else {
            VirtualMachineDefinedProfileSpec virtualMachineDefinedProfileSpec = new VirtualMachineDefinedProfileSpec();
            if (string != null) {
                virtualMachineDefinedProfileSpec.setProfileId(string);
            }
            if (string2 != null && string3 == null) {
                DeviceGroupId deviceGroupId = new DeviceGroupId();
                deviceGroupId.setId(string2);
                FaultDomainId faultDomainId = new FaultDomainId();
                faultDomainId.setId(string3);
                ReplicationGroupId replicationGroupId = new ReplicationGroupId();
                replicationGroupId.setDeviceGroupId(deviceGroupId);
                replicationGroupId.setFaultDomainId(faultDomainId);
                ReplicationSpec replicationSpec = new ReplicationSpec();
                replicationSpec.setReplicationGroupId(replicationGroupId);
                virtualMachineDefinedProfileSpec.setReplicationSpec(replicationSpec);
                System.out.printf("Setting replicationSpec withreplication group Id :: %n [ Uuid = %s ]%n and Fault domain Id ::  %n [ Uuid = %s ]%n ", string2, string3);
            }
            arrayList.add((VirtualMachineProfileSpec)virtualMachineDefinedProfileSpec);
        }
        return arrayList;
    }

    public static boolean isFcdIdInFcdList(List<String> list, List<ID> list2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (ID iD : list2) {
            arrayList.add(iD.getId());
        }
        return arrayList.containsAll(list);
    }

    public static String getFcdFilePath(VStorageObject vStorageObject) {
        BaseConfigInfoBackingInfo baseConfigInfoBackingInfo = vStorageObject.getConfig().getBacking();
        if (baseConfigInfoBackingInfo instanceof BaseConfigInfoFileBackingInfo) {
            BaseConfigInfoFileBackingInfo baseConfigInfoFileBackingInfo = (BaseConfigInfoFileBackingInfo)baseConfigInfoBackingInfo;
            return baseConfigInfoFileBackingInfo.getFilePath();
        }
        return null;
    }
}

