/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.general;

import com.vmware.common.annotations.Action;
import com.vmware.common.annotations.Option;
import com.vmware.common.annotations.Sample;
import com.vmware.connection.ConnectedVimServiceBase;
import com.vmware.vim25.InvalidCollectorVersionFaultMsg;
import com.vmware.vim25.InvalidPowerStateFaultMsg;
import com.vmware.vim25.InvalidPropertyFaultMsg;
import com.vmware.vim25.ManagedObjectReference;
import com.vmware.vim25.RetrieveOptions;
import com.vmware.vim25.RuntimeFaultFaultMsg;
import com.vmware.vim25.TaskInProgressFaultMsg;
import com.vmware.vim25.TaskInfoState;
import com.vmware.vim25.VimFaultFaultMsg;
import java.util.Map;

@Sample(name="remove-managed-object", description="demonstrates Destroy or Unregister Managed Inventory Object like a Host, VM, Folder, etc")
public class RemoveManagedObject
extends ConnectedVimServiceBase {
    public final String SVC_INST_NAME = "ServiceInstance";
    public static final String[] OBJECT_TYPES = new String[]{"HostSystem", "VirtualMachine", "Folder", "ResourcePool", "Datacenter"};
    String objectname;
    String objecttype;
    String operation;

    @Option(name="objtype", description="type of managedobject to remove or unregister  e.g. HostSystem, VirtualMachine, Folder, ResourcePool, Datacenter")
    public void setObjecttype(String string) {
        this.objecttype = string;
    }

    @Option(name="objname", description="Name of the object")
    public void setObjectname(String string) {
        this.objectname = string;
    }

    @Option(name="operation", required=false, description="Name of the operation - [remove | unregister]")
    public void setOperation(String string) {
        this.operation = string;
    }

    public boolean validateObjectType(String string) {
        boolean bl = false;
        for (String string2 : OBJECT_TYPES) {
            bl |= string2.equalsIgnoreCase(string);
        }
        return bl;
    }

    public boolean validateTheInput() {
        if (this.operation != null && !this.operation.equalsIgnoreCase("remove") && !this.operation.equalsIgnoreCase("unregister")) {
            throw new IllegalArgumentException("Invalid Operation type");
        }
        if (!this.validateObjectType(this.objecttype)) {
            StringBuilder stringBuilder = new StringBuilder();
            for (String string : OBJECT_TYPES) {
                stringBuilder.append("'");
                stringBuilder.append(string);
                stringBuilder.append("' ");
            }
            throw new IllegalArgumentException(String.format("Invalid --objtype %s! Object Type should be one of: %s", this.objecttype, stringBuilder.toString()));
        }
        return true;
    }

    public void deleteManagedObjectReference() throws RuntimeFaultFaultMsg, InvalidPropertyFaultMsg, VimFaultFaultMsg, InvalidCollectorVersionFaultMsg, TaskInProgressFaultMsg, InvalidPowerStateFaultMsg {
        Map<String, ManagedObjectReference> map = this.getMOREFs.inContainerByType(this.serviceContent.getRootFolder(), this.objecttype, new RetrieveOptions());
        ManagedObjectReference managedObjectReference = map.get(this.objectname);
        if (managedObjectReference != null) {
            if ("remove".equals(this.operation)) {
                ManagedObjectReference managedObjectReference2 = this.vimPort.destroyTask(managedObjectReference);
                String[] stringArray = new String[]{"info.state", "info.error"};
                String[] stringArray2 = new String[]{"state"};
                Object[] objectArray = this.waitForValues.wait(managedObjectReference2, stringArray, stringArray2, new Object[][]{{TaskInfoState.SUCCESS, TaskInfoState.ERROR}});
                if (objectArray[0].equals(TaskInfoState.SUCCESS)) {
                    System.out.printf("Success Managed Entity - [ %s ] deleted %n", this.objectname);
                } else {
                    System.out.printf("Failure Deletion of Managed Entity - [ %s ] %n", this.objectname);
                }
            } else if ("VirtualMachine".equalsIgnoreCase(this.objecttype)) {
                this.vimPort.unregisterVM(managedObjectReference);
            } else {
                throw new IllegalArgumentException("Invalid Operation specified.");
            }
            System.out.println("Successfully completed " + this.operation + " for " + this.objecttype + " : " + this.objectname);
        } else {
            System.out.println("Unable to find object of type  " + this.objecttype + " with name  " + this.objectname);
            System.out.println(" : Failed " + this.operation + " of " + this.objecttype + " : " + this.objectname);
        }
    }

    @Action
    public void run() throws RuntimeFaultFaultMsg, TaskInProgressFaultMsg, InvalidPropertyFaultMsg, VimFaultFaultMsg, InvalidCollectorVersionFaultMsg, InvalidPowerStateFaultMsg {
        this.validateTheInput();
        if ((this.operation == null || this.operation.length() == 0) && this.objecttype.equalsIgnoreCase("VirtualMachine")) {
            this.operation = "unregisterVM";
        } else if (!(this.operation != null && this.operation.length() != 0 || this.objecttype.equalsIgnoreCase("VirtualMachine"))) {
            this.operation = "remove";
        } else if (!"remove".equals(this.operation) && !"unregisterVM".equals(this.operation)) {
            this.operation = "unregisterVM";
        }
        this.deleteManagedObjectReference();
    }
}

