/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.guest;

import com.vmware.common.annotations.Action;
import com.vmware.common.annotations.Option;
import com.vmware.common.annotations.Sample;
import com.vmware.connection.ConnectedVimServiceBase;
import com.vmware.guest.GuestConnection;
import com.vmware.vim25.FileFaultFaultMsg;
import com.vmware.vim25.GuestAuthentication;
import com.vmware.vim25.GuestOperationsFaultFaultMsg;
import com.vmware.vim25.InvalidCollectorVersionFaultMsg;
import com.vmware.vim25.InvalidPropertyFaultMsg;
import com.vmware.vim25.InvalidStateFaultMsg;
import com.vmware.vim25.ManagedObjectReference;
import com.vmware.vim25.NamePasswordAuthentication;
import com.vmware.vim25.RuntimeFaultFaultMsg;
import com.vmware.vim25.TaskInProgressFaultMsg;
import com.vmware.vim25.VirtualMachinePowerState;
import java.util.Map;

@Sample(name="create-temp-file", description="creates a temporary file inside a virtual machine. Since vSphere API 5.0")
public class CreateTemporaryFile
extends ConnectedVimServiceBase {
    private VirtualMachinePowerState powerState;
    private GuestConnection guestConnection;
    private String prefix = "";
    private String suffix = "";
    private String directoryPath = "";

    @Option(name="guestConnection", type=GuestConnection.class)
    public void setGuestConnection(GuestConnection guestConnection) {
        this.guestConnection = guestConnection;
    }

    @Option(name="prefix", required=false, description="prefix to be added to the file name")
    public void setPrefix(String string) {
        this.prefix = string;
    }

    @Option(name="suffix", required=false, description="suffix to be added to the file name")
    public void setSuffix(String string) {
        this.suffix = string;
    }

    @Option(name="directorypath", required=false, description="path to the directory inside the guest")
    public void setDirectoryPath(String string) {
        this.directoryPath = string;
    }

    @Action
    public void run() throws RuntimeFaultFaultMsg, InvalidPropertyFaultMsg, InvalidCollectorVersionFaultMsg, TaskInProgressFaultMsg, FileFaultFaultMsg, InvalidStateFaultMsg, GuestOperationsFaultFaultMsg {
        this.serviceContent.getPropertyCollector();
        Map<String, ManagedObjectReference> map = this.getMOREFs.inFolderByType(this.serviceContent.getRootFolder(), "VirtualMachine");
        ManagedObjectReference managedObjectReference = map.get(this.guestConnection.vmname);
        if (managedObjectReference != null) {
            System.out.println("Virtual Machine " + this.guestConnection.vmname + " found");
            this.powerState = (VirtualMachinePowerState)this.getMOREFs.entityProps(managedObjectReference, new String[]{"runtime.powerState"}).get("runtime.powerState");
            if (!this.powerState.equals((Object)VirtualMachinePowerState.POWERED_ON)) {
                System.out.println("VirtualMachine: " + this.guestConnection.vmname + " needs to be powered on");
                return;
            }
        } else {
            System.out.println("Virtual Machine " + this.guestConnection.vmname + " not found.");
            return;
        }
        String[] stringArray = new String[]{"guest.guestOperationsReady"};
        String[] stringArray2 = new String[]{"guest.guestOperationsReady"};
        this.waitForValues.wait(managedObjectReference, stringArray, stringArray2, new Object[][]{{true}});
        System.out.println("Guest Operations are ready for the VM");
        ManagedObjectReference managedObjectReference2 = this.serviceContent.getGuestOperationsManager();
        ManagedObjectReference managedObjectReference3 = (ManagedObjectReference)this.getMOREFs.entityProps(managedObjectReference2, new String[]{"fileManager"}).get("fileManager");
        NamePasswordAuthentication namePasswordAuthentication = new NamePasswordAuthentication();
        namePasswordAuthentication.setUsername(this.guestConnection.username);
        namePasswordAuthentication.setPassword(this.guestConnection.password);
        namePasswordAuthentication.setInteractiveSession(false);
        System.out.println("Executing CreateTemporaryFile guest operation");
        String string = this.vimPort.createTemporaryFileInGuest(managedObjectReference3, managedObjectReference, (GuestAuthentication)namePasswordAuthentication, this.prefix, this.suffix, this.directoryPath);
        System.out.println("Temporary file was successfully created at: " + string + " inside the guest");
    }
}

