/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.guest;

import com.vmware.common.annotations.Action;
import com.vmware.common.annotations.Option;
import com.vmware.common.annotations.Sample;
import com.vmware.connection.ConnectedVimServiceBase;
import com.vmware.guest.GuestConnection;
import com.vmware.vim25.ArrayOfByte;
import com.vmware.vim25.FileFaultFaultMsg;
import com.vmware.vim25.GuestAuthentication;
import com.vmware.vim25.GuestFileAttributes;
import com.vmware.vim25.GuestOperationsFaultFaultMsg;
import com.vmware.vim25.GuestPosixFileAttributes;
import com.vmware.vim25.GuestWindowsFileAttributes;
import com.vmware.vim25.InvalidCollectorVersionFaultMsg;
import com.vmware.vim25.InvalidPropertyFaultMsg;
import com.vmware.vim25.InvalidStateFaultMsg;
import com.vmware.vim25.ManagedObjectReference;
import com.vmware.vim25.NamePasswordAuthentication;
import com.vmware.vim25.RuntimeFaultFaultMsg;
import com.vmware.vim25.TaskInProgressFaultMsg;
import com.vmware.vim25.VirtualMachinePowerState;
import jakarta.xml.ws.soap.SOAPFaultException;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Map;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;

@Sample(name="upload-guest-file", description="This sample uploads a file from the client machine to a\nspecified location inside the guest. Since vSphere API 5.0")
public class UploadGuestFile
extends ConnectedVimServiceBase {
    private GuestConnection guestConnection;
    private Boolean overwrite = Boolean.FALSE;
    String guestFilePath;
    String localFilePath;
    String guestType;
    VirtualMachinePowerState powerState;
    ManagedObjectReference hostMOR;
    long fileSize;
    X509Certificate x509CertificateToTrust = null;

    @Option(name="guestConnection", type=GuestConnection.class)
    public void setGuestConnection(GuestConnection guestConnection) {
        this.guestConnection = guestConnection;
    }

    @Option(name="guestfilepath", description="path of the file in the guest")
    public void setGuestFilePath(String string) {
        this.guestFilePath = string;
    }

    @Option(name="localfilepath", description="local file path to upload")
    public void setLocalFilePath(String string) {
        this.localFilePath = string;
    }

    @Option(name="guesttype", description="Type of the guest. (windows or posix)")
    public void setGuestType(String string) {
        this.guestType = string;
    }

    @Option(name="overwrite", required=false, description="whether to overwrite the file in the guest", parameter=false)
    public void setOverwrite(Boolean bl) {
        this.overwrite = bl;
    }

    void uploadData(String string, String string2) throws IOException {
        HttpURLConnection httpURLConnection = null;
        URL uRL = new URL(string);
        httpURLConnection = (HttpURLConnection)uRL.openConnection();
        httpURLConnection.setDoInput(true);
        httpURLConnection.setDoOutput(true);
        httpURLConnection.setRequestProperty("Content-Type", "application/octet-stream");
        httpURLConnection.setRequestMethod("PUT");
        httpURLConnection.setRequestProperty("Content-Length", Long.toString(this.fileSize));
        OutputStream outputStream = httpURLConnection.getOutputStream();
        FileInputStream fileInputStream = new FileInputStream(string2);
        byte[] byArray = new byte[102400];
        int n = 0;
        while ((n = ((InputStream)fileInputStream).read(byArray)) > 0) {
            outputStream.write(byArray, 0, n);
        }
        ((InputStream)fileInputStream).close();
        outputStream.close();
        int n2 = httpURLConnection.getResponseCode();
        httpURLConnection.disconnect();
        if (200 != n2) {
            throw new UploadException("File Upload is unsuccessful");
        }
    }

    @Action
    public void run() throws InvalidPropertyFaultMsg, InvalidCollectorVersionFaultMsg, TaskInProgressFaultMsg, FileFaultFaultMsg, InvalidStateFaultMsg, GuestOperationsFaultFaultMsg, IOException, CertificateException, RuntimeFaultFaultMsg, DatatypeConfigurationException {
        String string;
        this.serviceContent.getPropertyCollector();
        String string2 = this.guestConnection.vmname;
        Map<String, ManagedObjectReference> map = this.getMOREFs.inFolderByType(this.serviceContent.getRootFolder(), "VirtualMachine");
        ManagedObjectReference managedObjectReference = map.get(string2);
        if (managedObjectReference != null) {
            System.out.println("Virtual Machine " + string2 + " found");
            this.powerState = (VirtualMachinePowerState)this.getMOREFs.entityProps(managedObjectReference, new String[]{"runtime.powerState"}).get("runtime.powerState");
            if (!this.powerState.equals((Object)VirtualMachinePowerState.POWERED_ON)) {
                System.out.println("VirtualMachine: " + string2 + " needs to be powered on");
                return;
            }
        } else {
            System.out.println("Virtual Machine " + string2 + " not found.");
            return;
        }
        String[] stringArray = new String[]{"guest.guestOperationsReady"};
        String[] stringArray2 = new String[]{"guest.guestOperationsReady"};
        Object[] objectArray = this.waitForValues.wait(managedObjectReference, stringArray, stringArray2, new Object[][]{{true}});
        System.out.println("Guest Operations are ready for the VM");
        ManagedObjectReference managedObjectReference2 = this.serviceContent.getGuestOperationsManager();
        ManagedObjectReference managedObjectReference3 = (ManagedObjectReference)this.getMOREFs.entityProps(managedObjectReference2, new String[]{"fileManager"}).get("fileManager");
        NamePasswordAuthentication namePasswordAuthentication = new NamePasswordAuthentication();
        namePasswordAuthentication.setUsername(this.guestConnection.username);
        namePasswordAuthentication.setPassword(this.guestConnection.password);
        namePasswordAuthentication.setInteractiveSession(false);
        Object object = null;
        object = this.guestType.equalsIgnoreCase("windows") ? new GuestWindowsFileAttributes() : new GuestPosixFileAttributes();
        object.setAccessTime(DatatypeFactory.newInstance().newXMLGregorianCalendar(new GregorianCalendar()));
        object.setModificationTime(DatatypeFactory.newInstance().newXMLGregorianCalendar(new GregorianCalendar()));
        System.out.println("Executing UploadGuestFile guest operation");
        File file = new File(this.localFilePath);
        if (!file.exists()) {
            System.out.println("Error finding the file: " + this.localFilePath);
            return;
        }
        if (file.isDirectory()) {
            System.out.println("Local file path points to a directory");
            return;
        }
        this.fileSize = file.length();
        System.out.println("Size of the file is :" + this.fileSize + "");
        System.out.println("Executing UploadFile guest operation");
        try {
            string = this.vimPort.initiateFileTransferToGuest(managedObjectReference3, managedObjectReference, (GuestAuthentication)namePasswordAuthentication, this.guestFilePath, (GuestFileAttributes)object, this.fileSize, this.overwrite.booleanValue());
        }
        catch (SOAPFaultException sOAPFaultException) {
            System.out.println(sOAPFaultException.getMessage());
            if (sOAPFaultException.getMessage().contains(this.guestFilePath.replaceAll("//", "/") + " already exists")) {
                System.out.println("To overwrite the File use --overwrite option");
            }
            return;
        }
        URL uRL = new URL(this.connection.getUrl());
        string = string.replaceAll("\\*", uRL.getHost());
        System.out.println("Uploading the file to :" + string + "");
        if (this.hostMOR != null) {
            stringArray = new String[]{"config.certificate"};
            stringArray2 = new String[]{"config.certificate"};
            objectArray = this.waitForValues.wait(this.hostMOR, stringArray, stringArray2, null);
            List list = ((ArrayOfByte)objectArray[0]).getByte();
            byte[] byArray = new byte[list.size()];
            int n = 0;
            for (Byte by : list) {
                byArray[n++] = by;
            }
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            this.x509CertificateToTrust = (X509Certificate)certificateFactory.generateCertificate(new ByteArrayInputStream(byArray));
            System.out.println("Certificate of the host is successfully retrieved");
        }
        this.uploadData(string, this.localFilePath);
        System.out.println("Successfully uploaded the file");
    }

    private class UploadException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public UploadException(String string) {
            super(string);
        }
    }
}

