/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.hci;

import com.vmware.common.annotations.Action;
import com.vmware.common.annotations.Option;
import com.vmware.common.annotations.Sample;
import com.vmware.connection.ConnectedVimServiceBase;
import com.vmware.vim25.AboutInfo;
import com.vmware.vim25.ArrayOfManagedObjectReference;
import com.vmware.vim25.ClusterComputeResourceHCIConfigSpec;
import com.vmware.vim25.ClusterComputeResourceHostConfigurationInput;
import com.vmware.vim25.ClusterComputeResourceHostConfigurationProfile;
import com.vmware.vim25.ClusterConfigSpecEx;
import com.vmware.vim25.DesiredSoftwareSpec;
import com.vmware.vim25.DesiredSoftwareSpecBaseImageSpec;
import com.vmware.vim25.DesiredSoftwareSpecComponentSpec;
import com.vmware.vim25.DesiredSoftwareSpecVendorAddOnSpec;
import com.vmware.vim25.DuplicateNameFaultMsg;
import com.vmware.vim25.FolderNewHostSpec;
import com.vmware.vim25.HostConnectFaultFaultMsg;
import com.vmware.vim25.HostConnectSpec;
import com.vmware.vim25.HostDateTimeConfig;
import com.vmware.vim25.HostLockdownMode;
import com.vmware.vim25.HostNtpConfig;
import com.vmware.vim25.InvalidCollectorVersionFaultMsg;
import com.vmware.vim25.InvalidLoginFaultMsg;
import com.vmware.vim25.InvalidNameFaultMsg;
import com.vmware.vim25.InvalidPropertyFaultMsg;
import com.vmware.vim25.LocalizedMethodFault;
import com.vmware.vim25.ManagedObjectReference;
import com.vmware.vim25.NotFoundFaultMsg;
import com.vmware.vim25.NotSupportedFaultMsg;
import com.vmware.vim25.RuntimeFaultFaultMsg;
import com.vmware.vim25.ServiceContent;
import com.vmware.vim25.TaskInfoState;
import com.vmware.vim25.VsanClusterConfigInfo;
import com.vmware.vim25.VsanFaultFaultMsg;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

@Sample(name="HCIBatchAddHostAndExtendCluster", description="This sample code demonstrates how to call vSphere HCI API")
public class HCIBatchAddHostAndExtendCluster
extends ConnectedVimServiceBase {
    private final String datacenterName = "Datacenter";
    private final String clusterName = "HCI-Cluster";
    private String[] hostIps;
    private String hostUsername;
    private String hostPassword;
    private Boolean createVlcmCluster;
    private String baseImageVersion;
    private String addOnName;
    private String addOnVersion;
    private String componentName;
    private String componentVersion;

    @Option(name="hostIps", required=true, description="The IPs of the hosts, comma separated")
    public void sethostIps(String string) {
        this.hostIps = string.split(",");
    }

    @Option(name="hostUsername", required=true, description="The username for the hosts to be added")
    public void sethostUsername(String string) {
        this.hostUsername = string;
    }

    @Option(name="hostPassword", required=true, description="The password for the hosts to be added")
    public void sethostPassword(String string) {
        this.hostPassword = string;
    }

    @Option(name="createVlcmCluster", required=true, description="Create a lifecycle managed cluster")
    public void setCreateVlcmCluster(String string) {
        Boolean bl = "yes".equalsIgnoreCase(string);
        this.createVlcmCluster = Boolean.valueOf(string) != false || bl != false;
    }

    @Option(name="baseImageVersion", required=false, description="Base image version to create a lifecycle managed cluster")
    public void setBaseImageVersion(String string) {
        this.baseImageVersion = string;
    }

    @Option(name="addOnName", required=false, description="Name of the addon to include with the base image to create a lifecycle managed cluster")
    public void setAddOnName(String string) {
        this.addOnName = string;
    }

    @Option(name="addOnVersion", required=false, description="Version of the addon to include with the base image to create a lifecycle managed cluster")
    public void setAddOnVersion(String string) {
        this.addOnVersion = string;
    }

    @Option(name="componentName", required=false, description="Name of the component to include with the base image to create a lifecycle managed cluster")
    public void setComponentName(String string) {
        this.componentName = string;
    }

    @Option(name="componentVersion", required=false, description="Version of the component to include with the base image to create a lifecycle managed cluster")
    public void setComponentVersion(String string) {
        this.componentVersion = string;
    }

    boolean getTaskResultAfterDone(ManagedObjectReference managedObjectReference) throws InvalidPropertyFaultMsg, RuntimeFaultFaultMsg, InvalidCollectorVersionFaultMsg {
        boolean bl = false;
        Object[] objectArray = this.waitForValues.wait(managedObjectReference, new String[]{"info.state", "info.error"}, new String[]{"state"}, new Object[][]{{TaskInfoState.SUCCESS, TaskInfoState.ERROR}});
        if (objectArray[0].equals(TaskInfoState.SUCCESS)) {
            bl = true;
        }
        if (objectArray[1] instanceof LocalizedMethodFault) {
            throw new RuntimeException(((LocalizedMethodFault)objectArray[1]).getLocalizedMessage());
        }
        return bl;
    }

    private ManagedObjectReference getEntityFromName(ServiceContent serviceContent, String string, String string2) throws InvalidPropertyFaultMsg, RuntimeFaultFaultMsg {
        Map<String, ManagedObjectReference> map = this.getMOREFs.inContainerByType(serviceContent.getRootFolder(), string);
        for (String string3 : map.keySet()) {
            if (!string3.equals(string2)) continue;
            return map.get(string2);
        }
        return null;
    }

    @Action
    public void main() throws NotFoundFaultMsg, NotSupportedFaultMsg, VsanFaultFaultMsg, InvalidPropertyFaultMsg, RuntimeFaultFaultMsg, DuplicateNameFaultMsg, HostConnectFaultFaultMsg, InvalidNameFaultMsg, InvalidLoginFaultMsg, InvalidCollectorVersionFaultMsg {
        ManagedObjectReference managedObjectReference;
        Object object6;
        Object object2;
        Object object3;
        Object object4;
        HostConnectSpec hostConnectSpec;
        FolderNewHostSpec folderNewHostSpec;
        String string;
        Object object5;
        DesiredSoftwareSpec desiredSoftwareSpec;
        String string2;
        AboutInfo aboutInfo = this.serviceContent.getAbout();
        if (!aboutInfo.getApiType().equals("VirtualCenter")) {
            System.out.println("Configure HCI API is only supported on vCenter");
            System.exit(1);
        }
        if ((string2 = aboutInfo.getApiVersion()).compareTo("6.7") < 0) {
            System.out.format("The Virtual Center with version %s (lower than 6.7) is not supported.", aboutInfo.getApiVersion());
            return;
        }
        this.connect();
        System.out.println("Creating a datacenter.");
        this.vimPort.createDatacenter(this.serviceContent.getRootFolder(), this.datacenterName);
        ManagedObjectReference managedObjectReference2 = this.getEntityFromName(this.serviceContent, "Datacenter", this.datacenterName);
        ManagedObjectReference managedObjectReference3 = (ManagedObjectReference)this.getMOREFs.entityProps(managedObjectReference2, new String[]{"hostFolder"}).get("hostFolder");
        System.out.println("Creating a cluster.");
        ClusterConfigSpecEx clusterConfigSpecEx = new ClusterConfigSpecEx();
        clusterConfigSpecEx.setInHciWorkflow(Boolean.valueOf(true));
        VsanClusterConfigInfo vsanClusterConfigInfo = new VsanClusterConfigInfo();
        vsanClusterConfigInfo.setEnabled(Boolean.valueOf(true));
        clusterConfigSpecEx.setVsanConfig(vsanClusterConfigInfo);
        if (this.createVlcmCluster.booleanValue()) {
            DesiredSoftwareSpecVendorAddOnSpec desiredSoftwareSpecVendorAddOnSpec;
            desiredSoftwareSpec = new DesiredSoftwareSpec();
            object5 = new DesiredSoftwareSpecBaseImageSpec();
            object5.setVersion(this.baseImageVersion);
            desiredSoftwareSpec.setBaseImageSpec((DesiredSoftwareSpecBaseImageSpec)object5);
            if (this.addOnName != null && this.addOnVersion != null) {
                desiredSoftwareSpecVendorAddOnSpec = new DesiredSoftwareSpecVendorAddOnSpec();
                desiredSoftwareSpecVendorAddOnSpec.setName(this.addOnName);
                desiredSoftwareSpecVendorAddOnSpec.setVersion(this.addOnVersion);
                desiredSoftwareSpec.setVendorAddOnSpec(desiredSoftwareSpecVendorAddOnSpec);
            }
            if (this.componentName != null && this.componentVersion != null) {
                desiredSoftwareSpecVendorAddOnSpec = new DesiredSoftwareSpecComponentSpec();
                desiredSoftwareSpecVendorAddOnSpec.setName(this.componentName);
                desiredSoftwareSpecVendorAddOnSpec.setVersion(this.componentVersion);
                ArrayList<DesiredSoftwareSpecVendorAddOnSpec> arrayList = new ArrayList<DesiredSoftwareSpecVendorAddOnSpec>();
                arrayList.add(desiredSoftwareSpecVendorAddOnSpec);
                desiredSoftwareSpec.getComponents().addAll(arrayList);
            }
            clusterConfigSpecEx.setDesiredSoftwareSpec(desiredSoftwareSpec);
        }
        this.vimPort.createClusterEx(managedObjectReference3, this.clusterName, clusterConfigSpecEx);
        desiredSoftwareSpec = this.getEntityFromName(this.serviceContent, "ClusterComputeResource", this.clusterName);
        object5 = new ArrayList();
        int n = this.hostIps.length / 2;
        for (int i = 0; i < n; ++i) {
            string = this.hostIps[i];
            folderNewHostSpec = new FolderNewHostSpec();
            hostConnectSpec = new HostConnectSpec();
            hostConnectSpec.setHostName(string);
            hostConnectSpec.setUserName(this.hostUsername);
            hostConnectSpec.setPassword(this.hostPassword);
            folderNewHostSpec.setHostCnxSpec(hostConnectSpec);
            object5.add(folderNewHostSpec);
        }
        System.out.println("Batch add first half hosts.");
        ManagedObjectReference managedObjectReference4 = this.vimPort.batchAddHostsToClusterTask(managedObjectReference3, (ManagedObjectReference)desiredSoftwareSpec, (List)object5, null, null, null);
        this.getTaskResultAfterDone(managedObjectReference4);
        System.out.println("Config the cluster.");
        string = new ClusterComputeResourceHCIConfigSpec();
        folderNewHostSpec = new ClusterComputeResourceHostConfigurationProfile();
        hostConnectSpec = HostLockdownMode.LOCKDOWN_DISABLED;
        HostDateTimeConfig hostDateTimeConfig = new HostDateTimeConfig();
        String string3 = "time-c-c.nist.gov";
        HostNtpConfig hostNtpConfig = new HostNtpConfig();
        List list = hostNtpConfig.getServer();
        list.add(string3);
        hostDateTimeConfig.setNtpConfig(hostNtpConfig);
        folderNewHostSpec.setLockdownMode((HostLockdownMode)hostConnectSpec);
        folderNewHostSpec.setDateTimeConfig(hostDateTimeConfig);
        string.setHostConfigProfile((ClusterComputeResourceHostConfigurationProfile)folderNewHostSpec);
        ManagedObjectReference managedObjectReference5 = this.vimPort.configureHCITask((ManagedObjectReference)desiredSoftwareSpec, (ClusterComputeResourceHCIConfigSpec)string, null);
        this.getTaskResultAfterDone(managedObjectReference5);
        ArrayList<ClusterComputeResourceHostConfigurationInput> arrayList = new ArrayList<ClusterComputeResourceHostConfigurationInput>();
        ArrayOfManagedObjectReference arrayOfManagedObjectReference = (ArrayOfManagedObjectReference)this.getMOREFs.entityProps((ManagedObjectReference)desiredSoftwareSpec, new String[]{"host"}).get("host");
        List list2 = arrayOfManagedObjectReference.getManagedObjectReference();
        System.out.println("Adding second half hosts to the cluster.");
        for (int i = n; i < this.hostIps.length; ++i) {
            object4 = this.hostIps[i];
            object3 = new FolderNewHostSpec();
            object2 = new HostConnectSpec();
            object2.setHostName((String)object4);
            object2.setUserName(this.hostUsername);
            object2.setPassword(this.hostPassword);
            object3.setHostCnxSpec((HostConnectSpec)object2);
            object5.add(object3);
            object6 = this.vimPort.addHostTask((ManagedObjectReference)desiredSoftwareSpec, (HostConnectSpec)object2, true, null, null);
            this.getTaskResultAfterDone((ManagedObjectReference)object6);
        }
        ArrayOfManagedObjectReference arrayOfManagedObjectReference2 = (ArrayOfManagedObjectReference)this.getMOREFs.entityProps((ManagedObjectReference)desiredSoftwareSpec, new String[]{"host"}).get("host");
        object4 = arrayOfManagedObjectReference2.getManagedObjectReference();
        object3 = new HashSet();
        for (Object object6 : list2) {
            object3.add(object6.getValue());
        }
        object2 = new HashSet();
        object6 = object4.iterator();
        while (object6.hasNext()) {
            managedObjectReference = (ManagedObjectReference)object6.next();
            if (!object3.contains(managedObjectReference.getValue())) continue;
            object2.add(managedObjectReference);
        }
        object4.removeAll((Collection<?>)object2);
        object6 = object4.iterator();
        while (object6.hasNext()) {
            managedObjectReference = (ManagedObjectReference)object6.next();
            ClusterComputeResourceHostConfigurationInput clusterComputeResourceHostConfigurationInput = new ClusterComputeResourceHostConfigurationInput();
            clusterComputeResourceHostConfigurationInput.setHost(managedObjectReference);
            arrayList.add(clusterComputeResourceHostConfigurationInput);
        }
        System.out.println("Extend the config of second half hosts.");
        object6 = this.vimPort.extendHCITask((ManagedObjectReference)desiredSoftwareSpec, arrayList, null);
        this.getTaskResultAfterDone((ManagedObjectReference)object6);
    }
}

