/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.hci;

import com.vmware.common.annotations.Action;
import com.vmware.common.annotations.Option;
import com.vmware.common.annotations.Sample;
import com.vmware.connection.ConnectedVimServiceBase;
import com.vmware.vim25.AboutInfo;
import com.vmware.vim25.ClusterComputeResourceHCIConfigSpec;
import com.vmware.vim25.ClusterComputeResourceHostConfigurationProfile;
import com.vmware.vim25.ClusterConfigSpecEx;
import com.vmware.vim25.DesiredSoftwareSpec;
import com.vmware.vim25.DesiredSoftwareSpecBaseImageSpec;
import com.vmware.vim25.DesiredSoftwareSpecComponentSpec;
import com.vmware.vim25.DesiredSoftwareSpecVendorAddOnSpec;
import com.vmware.vim25.DuplicateNameFaultMsg;
import com.vmware.vim25.HostConnectFaultFaultMsg;
import com.vmware.vim25.HostConnectSpec;
import com.vmware.vim25.HostDateTimeConfig;
import com.vmware.vim25.HostLockdownMode;
import com.vmware.vim25.HostNtpConfig;
import com.vmware.vim25.InvalidCollectorVersionFaultMsg;
import com.vmware.vim25.InvalidLoginFaultMsg;
import com.vmware.vim25.InvalidNameFaultMsg;
import com.vmware.vim25.InvalidPropertyFaultMsg;
import com.vmware.vim25.LocalizedMethodFault;
import com.vmware.vim25.ManagedObjectReference;
import com.vmware.vim25.NotFoundFaultMsg;
import com.vmware.vim25.NotSupportedFaultMsg;
import com.vmware.vim25.RuntimeFaultFaultMsg;
import com.vmware.vim25.ServiceContent;
import com.vmware.vim25.TaskInfoState;
import com.vmware.vim25.VsanClusterConfigInfo;
import com.vmware.vim25.VsanFaultFaultMsg;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

@Sample(name="HCIComputeOnlyCluster", description="This sample code demonstrates how to call vSphere HCI API")
public class HCIComputeOnlyCluster
extends ConnectedVimServiceBase {
    private final String datacenterName = "Datacenter";
    private final String clusterName = "HCI-Cluster";
    private String[] hostIps;
    private String hostUsername;
    private String hostPassword;
    private Boolean createVlcmCluster;
    private String baseImageVersion;
    private String addOnName;
    private String addOnVersion;
    private String componentName;
    private String componentVersion;

    @Option(name="hostIps", required=true, description="The IPs of the hosts, comma separated")
    public void sethostIps(String string) {
        this.hostIps = string.split(",");
    }

    @Option(name="hostUsername", required=true, description="The username for the hosts to be added")
    public void sethostUsername(String string) {
        this.hostUsername = string;
    }

    @Option(name="hostPassword", required=true, description="The password for the hosts to be added")
    public void sethostPassword(String string) {
        this.hostPassword = string;
    }

    @Option(name="createVlcmCluster", required=true, description="Create a lifecycle managed cluster")
    public void setCreateVlcmCluster(String string) {
        Boolean bl = "yes".equalsIgnoreCase(string);
        this.createVlcmCluster = Boolean.valueOf(string) != false || bl != false;
    }

    @Option(name="baseImageVersion", required=false, description="Base image version to create a lifecycle managed cluster")
    public void setBaseImageVersion(String string) {
        this.baseImageVersion = string;
    }

    @Option(name="addOnName", required=false, description="Name of the addon to include with the base image to create a lifecycle managed cluster")
    public void setAddOnName(String string) {
        this.addOnName = string;
    }

    @Option(name="addOnVersion", required=false, description="Version of the addon included with the base image to create a lifecycle managed cluster")
    public void setAddOnVersion(String string) {
        this.addOnVersion = string;
    }

    @Option(name="componentName", required=false, description="Name of the component to include with the base image to create a lifecycle managed cluster")
    public void setComponentName(String string) {
        this.componentName = string;
    }

    @Option(name="componentVersion", required=false, description="Version of the component to include with the base image to create a lifecycle managed cluster")
    public void setComponentVersion(String string) {
        this.componentVersion = string;
    }

    boolean getTaskResultAfterDone(ManagedObjectReference managedObjectReference) throws InvalidPropertyFaultMsg, RuntimeFaultFaultMsg, InvalidCollectorVersionFaultMsg {
        boolean bl = false;
        Object[] objectArray = this.waitForValues.wait(managedObjectReference, new String[]{"info.state", "info.error"}, new String[]{"state"}, new Object[][]{{TaskInfoState.SUCCESS, TaskInfoState.ERROR}});
        if (objectArray[0].equals(TaskInfoState.SUCCESS)) {
            bl = true;
        }
        if (objectArray[1] instanceof LocalizedMethodFault) {
            throw new RuntimeException(((LocalizedMethodFault)objectArray[1]).getLocalizedMessage());
        }
        return bl;
    }

    private ManagedObjectReference getEntityFromName(ServiceContent serviceContent, String string, String string2) throws InvalidPropertyFaultMsg, RuntimeFaultFaultMsg {
        Map<String, ManagedObjectReference> map = this.getMOREFs.inContainerByType(serviceContent.getRootFolder(), string);
        for (String string3 : map.keySet()) {
            if (!string3.equals(string2)) continue;
            return map.get(string2);
        }
        return null;
    }

    @Action
    public void main() throws NotFoundFaultMsg, NotSupportedFaultMsg, VsanFaultFaultMsg, InvalidPropertyFaultMsg, RuntimeFaultFaultMsg, DuplicateNameFaultMsg, HostConnectFaultFaultMsg, InvalidNameFaultMsg, InvalidLoginFaultMsg, InvalidCollectorVersionFaultMsg {
        HostNtpConfig hostNtpConfig;
        Object object;
        String string3;
        ClusterComputeResourceHCIConfigSpec clusterComputeResourceHCIConfigSpec;
        DesiredSoftwareSpec desiredSoftwareSpec;
        String string2;
        AboutInfo aboutInfo = this.serviceContent.getAbout();
        if (!aboutInfo.getApiType().equals("VirtualCenter")) {
            System.out.println("Configure HCI API is only supported on vCenter");
            System.exit(1);
        }
        if ((string2 = aboutInfo.getApiVersion()).compareTo("6.7") < 0) {
            System.out.format("The Virtual Center with version %s (lower than 6.7) is not supported.", aboutInfo.getApiVersion());
            return;
        }
        this.connect();
        System.out.println("Creating a datacenter.");
        this.vimPort.createDatacenter(this.serviceContent.getRootFolder(), this.datacenterName);
        ManagedObjectReference managedObjectReference = this.getEntityFromName(this.serviceContent, "Datacenter", this.datacenterName);
        ManagedObjectReference managedObjectReference2 = (ManagedObjectReference)this.getMOREFs.entityProps(managedObjectReference, new String[]{"hostFolder"}).get("hostFolder");
        ClusterConfigSpecEx clusterConfigSpecEx = new ClusterConfigSpecEx();
        clusterConfigSpecEx.setInHciWorkflow(Boolean.valueOf(true));
        VsanClusterConfigInfo vsanClusterConfigInfo = new VsanClusterConfigInfo();
        vsanClusterConfigInfo.setEnabled(Boolean.valueOf(true));
        clusterConfigSpecEx.setVsanConfig(vsanClusterConfigInfo);
        if (this.createVlcmCluster.booleanValue()) {
            DesiredSoftwareSpecVendorAddOnSpec desiredSoftwareSpecVendorAddOnSpec;
            desiredSoftwareSpec = new DesiredSoftwareSpec();
            clusterComputeResourceHCIConfigSpec = new DesiredSoftwareSpecBaseImageSpec();
            clusterComputeResourceHCIConfigSpec.setVersion(this.baseImageVersion);
            desiredSoftwareSpec.setBaseImageSpec((DesiredSoftwareSpecBaseImageSpec)clusterComputeResourceHCIConfigSpec);
            if (this.addOnName != null && this.addOnVersion != null) {
                desiredSoftwareSpecVendorAddOnSpec = new DesiredSoftwareSpecVendorAddOnSpec();
                desiredSoftwareSpecVendorAddOnSpec.setName(this.addOnName);
                desiredSoftwareSpecVendorAddOnSpec.setVersion(this.addOnVersion);
                desiredSoftwareSpec.setVendorAddOnSpec(desiredSoftwareSpecVendorAddOnSpec);
            }
            if (this.componentName != null && this.componentVersion != null) {
                desiredSoftwareSpecVendorAddOnSpec = new DesiredSoftwareSpecComponentSpec();
                desiredSoftwareSpecVendorAddOnSpec.setName(this.componentName);
                desiredSoftwareSpecVendorAddOnSpec.setVersion(this.componentVersion);
                ArrayList<DesiredSoftwareSpecVendorAddOnSpec> arrayList = new ArrayList<DesiredSoftwareSpecVendorAddOnSpec>();
                arrayList.add(desiredSoftwareSpecVendorAddOnSpec);
                desiredSoftwareSpec.getComponents().addAll(arrayList);
            }
            clusterConfigSpecEx.setDesiredSoftwareSpec(desiredSoftwareSpec);
        }
        System.out.println("Creating the cluster.");
        this.vimPort.createClusterEx(managedObjectReference2, this.clusterName, clusterConfigSpecEx);
        desiredSoftwareSpec = this.getEntityFromName(this.serviceContent, "ClusterComputeResource", this.clusterName);
        System.out.println("Adding hosts to the cluster.");
        for (String string3 : this.hostIps) {
            object = new HostConnectSpec();
            object.setHostName(string3);
            object.setUserName(this.hostUsername);
            object.setPassword(this.hostPassword);
            hostNtpConfig = this.vimPort.addHostTask((ManagedObjectReference)desiredSoftwareSpec, object, true, null, null);
            this.getTaskResultAfterDone((ManagedObjectReference)hostNtpConfig);
        }
        clusterComputeResourceHCIConfigSpec = new ClusterComputeResourceHCIConfigSpec();
        ClusterComputeResourceHostConfigurationProfile clusterComputeResourceHostConfigurationProfile = new ClusterComputeResourceHostConfigurationProfile();
        HostLockdownMode hostLockdownMode = HostLockdownMode.LOCKDOWN_DISABLED;
        string3 = new HostDateTimeConfig();
        object = "time-c-b.nist.gov";
        hostNtpConfig = new HostNtpConfig();
        List list = hostNtpConfig.getServer();
        list.add(object);
        string3.setNtpConfig(hostNtpConfig);
        clusterComputeResourceHostConfigurationProfile.setLockdownMode(hostLockdownMode);
        clusterComputeResourceHostConfigurationProfile.setDateTimeConfig((HostDateTimeConfig)string3);
        clusterComputeResourceHCIConfigSpec.setHostConfigProfile(clusterComputeResourceHostConfigurationProfile);
        System.out.println("Config the cluster.");
        ManagedObjectReference managedObjectReference3 = this.vimPort.configureHCITask((ManagedObjectReference)desiredSoftwareSpec, clusterComputeResourceHCIConfigSpec, null);
        this.getTaskResultAfterDone(managedObjectReference3);
    }
}

