/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.host;

import com.vmware.common.annotations.Action;
import com.vmware.common.annotations.Option;
import com.vmware.common.annotations.Sample;
import com.vmware.connection.ConnectedVimServiceBase;
import com.vmware.vim25.AlreadyExistsFaultMsg;
import com.vmware.vim25.ArrayOfManagedObjectReference;
import com.vmware.vim25.DistributedVirtualSwitchPortConnection;
import com.vmware.vim25.HostConfigFaultFaultMsg;
import com.vmware.vim25.HostConfigManager;
import com.vmware.vim25.HostIpConfig;
import com.vmware.vim25.HostPortGroupSpec;
import com.vmware.vim25.HostVirtualNicSpec;
import com.vmware.vim25.InvalidPropertyFaultMsg;
import com.vmware.vim25.InvalidStateFaultMsg;
import com.vmware.vim25.ManagedObjectReference;
import com.vmware.vim25.RetrieveOptions;
import com.vmware.vim25.RuntimeFaultFaultMsg;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;

@Sample(name="add-virtual-nic", description="This sample is used to add a Virtual Nic to a PortGroup")
public class AddVirtualNic
extends ConnectedVimServiceBase {
    private ManagedObjectReference rootFolder;
    private ManagedObjectReference propCollectorRef;
    String hostname;
    String portgroupname;
    String ipaddress;

    @Option(name="portgroupname", required=true, description="Name of the port group")
    public void setPortgroupname(String string) {
        this.portgroupname = string;
    }

    @Option(name="ipaddress", required=false, description="ipaddress for the nic, if not set DHCP will be in affect for the nic")
    public void setIpaddress(String string) {
        this.ipaddress = string;
    }

    @Option(name="hostname", required=false, description="Name of the host")
    public void setHostname(String string) {
        this.hostname = string;
    }

    void init() {
        this.propCollectorRef = this.serviceContent.getPropertyCollector();
        this.rootFolder = this.serviceContent.getRootFolder();
    }

    HostVirtualNicSpec createVirtualNicSpecification(ManagedObjectReference managedObjectReference) throws InvalidPropertyFaultMsg, RuntimeFaultFaultMsg {
        HostIpConfig hostIpConfig = new HostIpConfig();
        if (this.ipaddress != null && !this.ipaddress.isEmpty()) {
            hostIpConfig.setDhcp(Boolean.FALSE.booleanValue());
            hostIpConfig.setIpAddress(this.ipaddress);
            hostIpConfig.setSubnetMask("255.255.255.0");
        } else {
            hostIpConfig.setDhcp(Boolean.TRUE.booleanValue());
        }
        HostVirtualNicSpec hostVirtualNicSpec = new HostVirtualNicSpec();
        hostVirtualNicSpec.setIp(hostIpConfig);
        if (managedObjectReference.getType().equals("DistributedVirtualPortgroup")) {
            Map<String, Object> map = null;
            map = this.getMOREFs.entityProps(managedObjectReference, new String[]{"config.distributedVirtualSwitch", "key"});
            ManagedObjectReference managedObjectReference2 = (ManagedObjectReference)map.get("config.distributedVirtualSwitch");
            String string = (String)this.getMOREFs.entityProps(managedObjectReference2, new String[]{"uuid"}).get("uuid");
            DistributedVirtualSwitchPortConnection distributedVirtualSwitchPortConnection = new DistributedVirtualSwitchPortConnection();
            distributedVirtualSwitchPortConnection.setPortgroupKey((String)map.get("key"));
            distributedVirtualSwitchPortConnection.setSwitchUuid(string);
            hostVirtualNicSpec.setDistributedVirtualPort(distributedVirtualSwitchPortConnection);
        }
        return hostVirtualNicSpec;
    }

    void addVirtualNIC() throws HostConfigFaultFaultMsg, AlreadyExistsFaultMsg, InvalidStateFaultMsg, InvalidPropertyFaultMsg, RuntimeFaultFaultMsg {
        ManagedObjectReference managedObjectReference4;
        ManagedObjectReference managedObjectReference2 = null;
        Map<String, ManagedObjectReference> map = this.getMOREFs.inFolderByType(this.serviceContent.getRootFolder(), "HostSystem", new RetrieveOptions());
        managedObjectReference2 = map.get(this.hostname);
        if (managedObjectReference2 == null) {
            System.out.println("Host " + this.hostname + " not found");
            return;
        }
        ArrayOfManagedObjectReference arrayOfManagedObjectReference = (ArrayOfManagedObjectReference)this.getMOREFs.entityProps(managedObjectReference2, new String[]{"network"}).get("network");
        ManagedObjectReference managedObjectReference3 = null;
        for (ManagedObjectReference managedObjectReference4 : arrayOfManagedObjectReference.getManagedObjectReference()) {
            if (!this.portgroupname.equals(this.getMOREFs.entityProps(managedObjectReference4, new String[]{"name"}).get("name"))) continue;
            managedObjectReference3 = managedObjectReference4;
        }
        if (managedObjectReference3 == null) {
            System.out.println("Portgroup " + this.portgroupname + " not found");
            return;
        }
        HostConfigManager hostConfigManager = (HostConfigManager)this.getMOREFs.entityProps(managedObjectReference2, new String[]{"configManager"}).get("configManager");
        managedObjectReference4 = hostConfigManager.getNetworkSystem();
        HostPortGroupSpec hostPortGroupSpec = new HostPortGroupSpec();
        hostPortGroupSpec.setName(this.portgroupname);
        HostVirtualNicSpec hostVirtualNicSpec = this.createVirtualNicSpecification(managedObjectReference3);
        String string = null;
        string = managedObjectReference3.getType().equals("DistributedVirtualPortgroup") ? this.vimPort.addVirtualNic(managedObjectReference4, "", hostVirtualNicSpec) : this.vimPort.addVirtualNic(managedObjectReference4, this.portgroupname, hostVirtualNicSpec);
        System.out.println("Successful in creating nic : " + string + " with PortGroup :" + this.portgroupname);
    }

    @Action
    public void run() throws RuntimeFaultFaultMsg, AlreadyExistsFaultMsg, InvalidStateFaultMsg, InvocationTargetException, InvalidPropertyFaultMsg, NoSuchMethodException, IllegalAccessException, HostConfigFaultFaultMsg {
        this.init();
        this.addVirtualNIC();
    }
}

