/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.host;

import com.vmware.common.annotations.Action;
import com.vmware.common.annotations.Option;
import com.vmware.common.annotations.Sample;
import com.vmware.connection.ConnectedVimServiceBase;
import com.vmware.vim25.DvsFaultFaultMsg;
import com.vmware.vim25.InvalidPropertyFaultMsg;
import com.vmware.vim25.ManagedObjectReference;
import com.vmware.vim25.RuntimeFaultFaultMsg;

@Sample(name="nioc-for-dvs", description="demonstrates how to enable NIOC for a DVSwitch")
public class NIOCForDVS
extends ConnectedVimServiceBase {
    private String dvsname = null;
    private String enableNIOC = null;

    @Option(name="dvsname", required=true, description="Distributed Virtual Switch name")
    public void setDvsname(String string) {
        this.dvsname = string;
    }

    @Option(name="enablenioc", required=true, description="If true, enables I/O control. If false, disables network I/O control")
    public void setEnableNIOC(String string) {
        this.enableNIOC = string;
    }

    void enableNIOC(String string, boolean bl) throws DvsFaultFaultMsg, RuntimeFaultFaultMsg, InvalidPropertyFaultMsg {
        ManagedObjectReference managedObjectReference = this.getMOREFs.inFolderByType(this.serviceContent.getRootFolder(), "VmwareDistributedVirtualSwitch").get(string);
        if (managedObjectReference == null) {
            System.out.println("DVS Switch " + string + " Not Found");
            return;
        }
        this.vimPort.enableNetworkResourceManagement(managedObjectReference, bl);
        System.out.printf("Set network I/O control", new Object[0]);
    }

    @Action
    public void run() throws InvalidPropertyFaultMsg, DvsFaultFaultMsg, RuntimeFaultFaultMsg {
        this.enableNIOC(this.dvsname, Boolean.parseBoolean(this.enableNIOC));
    }
}

